/*
 * Decompiled with CFR 0.152.
 */
package moe.yushi.authlibinjector.transform;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.ClassVisitor;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.Handle;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.MethodVisitor;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.Type;
import moe.yushi.authlibinjector.transform.CallbackMethod;
import moe.yushi.authlibinjector.transform.TransformContext;

final class CallbackSupport {
    private static final String METAFACTORY_NAME = "__authlibinjector_metafactory";
    private static final String METAFACTORY_SIGNATURE = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/String;)Ljava/lang/invoke/CallSite;";

    private CallbackSupport() {
    }

    private static Method findCallbackMethod(Class<?> owner, String methodName) {
        for (Method method : owner.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !methodName.equals(method.getName()) || method.getAnnotation(CallbackMethod.class) == null) continue;
            return method;
        }
        throw new IllegalArgumentException("No such method: " + methodName);
    }

    static void callWithInvokeDynamic(MethodVisitor mv, Class<?> owner, String methodName, TransformContext ctx) {
        String descriptor = Type.getMethodDescriptor(CallbackSupport.findCallbackMethod(owner, methodName));
        Handle callbackMetafactory = new Handle(6, ctx.getClassName().replace('.', '/'), METAFACTORY_NAME, METAFACTORY_SIGNATURE, ctx.isInterface());
        mv.visitInvokeDynamicInsn(methodName, descriptor, callbackMetafactory, owner.getName());
    }

    static void callWithIntermediateMethod(MethodVisitor mv0, Class<?> owner, String methodName, TransformContext ctx) {
        Method callbackMethod = CallbackSupport.findCallbackMethod(owner, methodName);
        String descriptor = Type.getMethodDescriptor(callbackMethod);
        String intermediateMethod = "__authlibinjector_intermediate__" + owner.getName().replace('.', '_') + "__" + methodName;
        mv0.visitMethodInsn(184, ctx.getClassName().replace('.', '/'), intermediateMethod, descriptor, ctx.isInterface());
        ctx.addGeneratedMethod(intermediateMethod, cv -> {
            int i;
            int paramNum = callbackMethod.getParameterCount();
            Class<?>[] paramTypes = callbackMethod.getParameterTypes();
            Class<?> returnType = callbackMethod.getReturnType();
            MethodVisitor mv = cv.visitMethod(4106, intermediateMethod, descriptor, null, null);
            mv.visitCode();
            mv.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "publicLookup", "()Ljava/lang/invoke/MethodHandles$Lookup;", false);
            mv.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;", false);
            mv.visitLdcInsn(owner.getName());
            mv.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false);
            mv.visitLdcInsn(methodName);
            CallbackSupport.pushType(mv, returnType);
            mv.visitLdcInsn(paramNum);
            mv.visitTypeInsn(189, "java/lang/Class");
            for (i = 0; i < paramNum; ++i) {
                mv.visitInsn(89);
                mv.visitLdcInsn(i);
                CallbackSupport.pushType(mv, paramTypes[i]);
                mv.visitInsn(83);
            }
            mv.visitMethodInsn(184, "java/lang/invoke/MethodType", "methodType", "(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/invoke/MethodType;", false);
            mv.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "findStatic", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", false);
            for (i = 0; i < paramNum; ++i) {
                Class<?> type = paramTypes[i];
                if (type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE || type == Integer.TYPE) {
                    mv.visitVarInsn(21, i);
                    continue;
                }
                if (type == Long.TYPE) {
                    mv.visitVarInsn(22, i);
                    continue;
                }
                if (type == Float.TYPE) {
                    mv.visitVarInsn(23, i);
                    continue;
                }
                if (type == Double.TYPE) {
                    mv.visitVarInsn(24, i);
                    continue;
                }
                mv.visitVarInsn(25, i);
            }
            mv.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "invokeExact", descriptor, false);
            if (returnType == Void.TYPE) {
                mv.visitInsn(177);
            } else if (returnType == Boolean.TYPE || returnType == Byte.TYPE || returnType == Character.TYPE || returnType == Short.TYPE || returnType == Integer.TYPE) {
                mv.visitInsn(172);
            } else if (returnType == Long.TYPE) {
                mv.visitInsn(173);
            } else if (returnType == Float.TYPE) {
                mv.visitInsn(174);
            } else if (returnType == Double.TYPE) {
                mv.visitInsn(175);
            } else {
                mv.visitInsn(176);
            }
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        });
    }

    private static void pushType(MethodVisitor mv, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
            } else if (type == Byte.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
            } else if (type == Character.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
            } else if (type == Short.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
            } else if (type == Integer.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
            } else if (type == Float.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
            } else if (type == Long.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
            } else if (type == Double.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
            } else if (type == Void.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
            }
        } else {
            mv.visitLdcInsn(Type.getType(type));
        }
    }

    static void insertMetafactory(ClassVisitor visitor) {
        MethodVisitor mv = visitor.visitMethod(4106, METAFACTORY_NAME, METAFACTORY_SIGNATURE, null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/invoke/ConstantCallSite");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;", false);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "findStatic", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", false);
        mv.visitMethodInsn(183, "java/lang/invoke/ConstantCallSite", "<init>", "(Ljava/lang/invoke/MethodHandle;)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }
}

