/*
 * Decompiled with CFR 0.152.
 */
package moe.yushi.authlibinjector.transform;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import moe.yushi.authlibinjector.Config;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.ClassReader;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.ClassVisitor;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.ClassWriter;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.MethodVisitor;
import moe.yushi.authlibinjector.transform.CallbackSupport;
import moe.yushi.authlibinjector.transform.ClassLoadingListener;
import moe.yushi.authlibinjector.transform.PerformanceMetrics;
import moe.yushi.authlibinjector.transform.TransformContext;
import moe.yushi.authlibinjector.transform.TransformUnit;
import moe.yushi.authlibinjector.util.Logging;

public class ClassTransformer
implements ClassFileTransformer {
    public final List<TransformUnit> units = new CopyOnWriteArrayList<TransformUnit>();
    public final List<ClassLoadingListener> listeners = new CopyOnWriteArrayList<ClassLoadingListener>();
    public final PerformanceMetrics performanceMetrics = new PerformanceMetrics();
    private String[] ignores = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String internalClassName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (internalClassName != null && classfileBuffer != null) {
            try {
                long t0 = System.nanoTime();
                String className = internalClassName.replace('/', '.');
                for (String ignore : this.ignores) {
                    if (!className.startsWith(ignore)) continue;
                    this.listeners.forEach(it -> it.onClassLoading(loader, className, classfileBuffer, Collections.emptyList()));
                    long t1 = System.nanoTime();
                    PerformanceMetrics performanceMetrics = this.performanceMetrics;
                    synchronized (performanceMetrics) {
                        ++this.performanceMetrics.classesSkipped;
                        this.performanceMetrics.totalTime += t1 - t0;
                        this.performanceMetrics.matchTime += t1 - t0;
                    }
                    return null;
                }
                long t1 = System.nanoTime();
                TransformHandle handle = new TransformHandle(loader, className, classfileBuffer);
                TransformUnit[] unitsArray = this.units.toArray(new TransformUnit[0]);
                handle.accept(unitsArray);
                Optional<byte[]> transformResult = handle.finish();
                if (Config.printUntransformedClass && !transformResult.isPresent()) {
                    Logging.log(Logging.Level.DEBUG, "No transformation is applied to [" + className + "]");
                }
                this.listeners.forEach(it -> it.onClassLoading(loader, className, handle.getFinalResult(), handle.getAppliedTransformers()));
                long t2 = System.nanoTime();
                PerformanceMetrics performanceMetrics = this.performanceMetrics;
                synchronized (performanceMetrics) {
                    ++this.performanceMetrics.classesScanned;
                    this.performanceMetrics.totalTime += t2 - t0;
                    this.performanceMetrics.matchTime += t1 - t0;
                }
                return transformResult.orElse(null);
            }
            catch (Throwable e) {
                Logging.log(Logging.Level.WARNING, "Failed to transform [" + internalClassName + "]", e);
            }
        }
        return null;
    }

    private static List<String> extractStringConstants(ClassReader reader) {
        ArrayList<String> constants = new ArrayList<String>();
        int constantPoolSize = reader.getItemCount();
        char[] buf = new char[reader.getMaxStringLength()];
        for (int idx = 1; idx < constantPoolSize; ++idx) {
            int type;
            int offset = reader.getItem(idx);
            if (offset == 0 || (type = reader.readByte(offset - 1)) != 8) continue;
            String constant = (String)reader.readConst(idx, buf);
            constants.add(constant);
        }
        return constants;
    }

    public void setIgnores(Collection<String> newIgnores) {
        this.ignores = newIgnores.toArray(this.ignores);
    }

    private class TransformHandle {
        private final String className;
        private final ClassLoader classLoader;
        private byte[] classBuffer;
        private ClassReader cachedClassReader;
        private List<String> cachedConstants;
        private List<TransformUnit> appliedTransformers;
        private boolean addCallbackMetafactory = false;
        private Map<String, Consumer<ClassVisitor>> generatedMethods;

        public TransformHandle(ClassLoader classLoader, String className, byte[] classBuffer) {
            this.className = className;
            this.classBuffer = classBuffer;
            this.classLoader = classLoader;
        }

        private ClassReader getClassReader() {
            if (this.cachedClassReader == null) {
                this.cachedClassReader = new ClassReader(this.classBuffer);
            }
            return this.cachedClassReader;
        }

        private boolean isInterface() {
            return (this.getClassReader().getAccess() & 0x200) != 0;
        }

        private List<String> getStringConstants() {
            if (this.cachedConstants == null) {
                this.cachedConstants = ClassTransformer.extractStringConstants(this.getClassReader());
            }
            return this.cachedConstants;
        }

        private int getClassVersion() {
            ClassReader reader = this.getClassReader();
            return reader.readInt(reader.getItem(1) - 7);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(TransformUnit ... units) {
            Optional<ClassVisitor> visitor;
            long t0 = System.nanoTime();
            ClassWriter writer = new ClassWriter(1);
            TransformContextImpl[] ctxs = new TransformContextImpl[units.length];
            ClassVisitor chain = writer;
            for (int i = units.length - 1; i >= 0; --i) {
                TransformContextImpl ctx = new TransformContextImpl();
                visitor = units[i].transform(this.classLoader, this.className, chain, ctx);
                if (!visitor.isPresent()) continue;
                ctxs[i] = ctx;
                chain = (ClassVisitor)visitor.get();
            }
            long t1 = System.nanoTime();
            visitor = ClassTransformer.this.performanceMetrics;
            synchronized (visitor) {
                ClassTransformer.this.performanceMetrics.scanTime += t1 - t0;
            }
            if (chain == writer) {
                return;
            }
            t0 = System.nanoTime();
            this.getClassReader().accept(chain, 0);
            t1 = System.nanoTime();
            visitor = ClassTransformer.this.performanceMetrics;
            synchronized (visitor) {
                ClassTransformer.this.performanceMetrics.analysisTime += t1 - t0;
            }
            boolean modified = false;
            for (int i = 0; i < units.length; ++i) {
                TransformContextImpl ctx = ctxs[i];
                if (ctx == null || !ctx.modifiedMark) continue;
                Logging.log(Logging.Level.INFO, "Transformed [" + this.className + "] with [" + units[i] + "]");
                if (this.appliedTransformers == null) {
                    this.appliedTransformers = new ArrayList<TransformUnit>();
                }
                this.appliedTransformers.add(units[i]);
                this.addCallbackMetafactory |= ctx.callbackMetafactoryRequested;
                modified = true;
            }
            if (modified) {
                this.updateClassBuffer(writer.toByteArray());
            }
        }

        private void injectCallbackMetafactory() {
            int newVersion;
            Logging.log(Logging.Level.DEBUG, "Adding callback metafactory");
            int classVersion = this.getClassVersion();
            int majorVersion = classVersion & 0xFFFF;
            if (majorVersion < 51) {
                newVersion = 51;
                Logging.log(Logging.Level.DEBUG, "Upgrading class version from " + classVersion + " to " + newVersion);
            } else {
                newVersion = classVersion;
            }
            ClassReader reader = this.getClassReader();
            ClassWriter writer = new ClassWriter(reader, 1);
            ClassVisitor visitor = new ClassVisitor(589824, writer){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    super.visit(newVersion, access, name, signature, superName, interfaces);
                    CallbackSupport.insertMetafactory(this);
                }
            };
            reader.accept(visitor, 0);
            this.updateClassBuffer(writer.toByteArray());
        }

        private void injectGeneratedMethods() {
            ClassReader reader = this.getClassReader();
            ClassWriter writer = new ClassWriter(reader, 1);
            ClassVisitor visitor = new ClassVisitor(589824, writer){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    super.visit(version, access, name, signature, superName, interfaces);
                    for (Map.Entry el : TransformHandle.this.generatedMethods.entrySet()) {
                        Logging.log(Logging.Level.DEBUG, "Adding generated method [" + (String)el.getKey() + "]");
                        ((Consumer)el.getValue()).accept(this);
                    }
                }
            };
            reader.accept(visitor, 0);
            this.updateClassBuffer(writer.toByteArray());
        }

        private void updateClassBuffer(byte[] buf) {
            this.classBuffer = buf;
            this.cachedClassReader = null;
            this.cachedConstants = null;
        }

        public Optional<byte[]> finish() {
            if (this.appliedTransformers == null || this.appliedTransformers.isEmpty()) {
                return Optional.empty();
            }
            if (this.addCallbackMetafactory) {
                this.injectCallbackMetafactory();
            }
            if (this.generatedMethods != null) {
                this.injectGeneratedMethods();
            }
            return Optional.of(this.classBuffer);
        }

        public List<TransformUnit> getAppliedTransformers() {
            return this.appliedTransformers == null ? Collections.emptyList() : this.appliedTransformers;
        }

        public byte[] getFinalResult() {
            return this.classBuffer;
        }

        private class TransformContextImpl
        implements TransformContext {
            public boolean modifiedMark;
            public boolean callbackMetafactoryRequested = false;

            private TransformContextImpl() {
            }

            @Override
            public void markModified() {
                this.modifiedMark = true;
            }

            @Override
            public List<String> getStringConstants() {
                return TransformHandle.this.getStringConstants();
            }

            @Override
            public String getClassName() {
                return TransformHandle.this.className;
            }

            @Override
            public boolean isInterface() {
                return TransformHandle.this.isInterface();
            }

            @Override
            public void invokeCallback(MethodVisitor mv, Class<?> owner, String methodName) {
                boolean useInvokeDynamic;
                boolean bl = useInvokeDynamic = (TransformHandle.this.getClassVersion() & 0xFFFF) >= 50;
                if (useInvokeDynamic) {
                    TransformHandle.this.addCallbackMetafactory = true;
                    CallbackSupport.callWithInvokeDynamic(mv, owner, methodName, this);
                } else {
                    CallbackSupport.callWithIntermediateMethod(mv, owner, methodName, this);
                }
            }

            @Override
            public void addGeneratedMethod(String name, Consumer<ClassVisitor> generator) {
                if (TransformHandle.this.generatedMethods == null) {
                    TransformHandle.this.generatedMethods = new LinkedHashMap();
                }
                TransformHandle.this.generatedMethods.put(name, generator);
            }
        }
    }
}

