/*
 * Decompiled with CFR 0.152.
 */
package moe.yushi.authlibinjector.transform.support;

import java.util.Optional;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.ClassVisitor;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.MethodVisitor;
import moe.yushi.authlibinjector.transform.TransformContext;
import moe.yushi.authlibinjector.transform.TransformUnit;

public class UsernameCharacterCheckTransformer
implements TransformUnit {
    @Override
    public Optional<ClassVisitor> transform(ClassLoader classLoader, String className, ClassVisitor writer, final TransformContext context) {
        if (!context.getStringConstants().contains("Invalid characters in username")) {
            return Optional.empty();
        }
        return Optional.of(new ClassVisitor(589824, writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitor(589824, super.visitMethod(access, name, descriptor, signature, exceptions)){
                    int state;
                    {
                        this.state = 0;
                    }

                    @Override
                    public void visitLdcInsn(Object value) {
                        if (this.state == 0 && "Invalid characters in username".equals(value)) {
                            ++this.state;
                        }
                        super.visitLdcInsn(value);
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        if (this.state == 1 && opcode == 3) {
                            ++this.state;
                        }
                        super.visitInsn(opcode);
                    }

                    @Override
                    public void visitTypeInsn(int opcode, String type) {
                        if (this.state == 2 && opcode == 189 && "java/lang/Object".equals(type)) {
                            ++this.state;
                        }
                        super.visitTypeInsn(opcode, type);
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        if (this.state == 3 && opcode == 184 && "org/apache/commons/lang3/Validate".equals(owner) && "validState".equals(name) && "(ZLjava/lang/String;[Ljava/lang/Object;)V".equals(descriptor)) {
                            context.markModified();
                            ++this.state;
                            super.visitInsn(87);
                            super.visitInsn(87);
                            super.visitInsn(87);
                        } else {
                            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                        }
                    }
                };
            }
        });
    }

    public String toString() {
        return "Username Character Check Transformer";
    }
}

