/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureWaterloggedBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class ModernCoffeeTableBlock
extends FurnitureWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty TALL = BooleanProperty.func_177716_a((String)"tall");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ModernCoffeeTableBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)TALL, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape TABLE_TOP_SHORT = Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape TABLE_TOP_TALL = Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape LEG_SOUTH_EAST_TALL = Block.func_208617_a((double)13.5, (double)0.0, (double)13.5, (double)15.0, (double)14.0, (double)15.0);
        VoxelShape LEG_SOUTH_WEST_TALL = Block.func_208617_a((double)1.0, (double)0.0, (double)13.5, (double)2.5, (double)14.0, (double)15.0);
        VoxelShape LEG_NORTH_WEST_TALL = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)2.5, (double)14.0, (double)2.5);
        VoxelShape LEG_NORTH_EAST_TALL = Block.func_208617_a((double)13.5, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)2.5);
        VoxelShape LEG_SOUTH_EAST_SHORT = Block.func_208617_a((double)13.5, (double)0.0, (double)13.5, (double)15.0, (double)6.0, (double)15.0);
        VoxelShape LEG_SOUTH_WEST_SHORT = Block.func_208617_a((double)1.0, (double)0.0, (double)13.5, (double)2.5, (double)6.0, (double)15.0);
        VoxelShape LEG_NORTH_WEST_SHORT = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)2.5, (double)6.0, (double)2.5);
        VoxelShape LEG_NORTH_EAST_SHORT = Block.func_208617_a((double)13.5, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)2.5);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean tall = (Boolean)state.func_177229_b((Property)TALL);
            boolean north = (Boolean)state.func_177229_b((Property)NORTH);
            boolean east = (Boolean)state.func_177229_b((Property)EAST);
            boolean south = (Boolean)state.func_177229_b((Property)SOUTH);
            boolean west = (Boolean)state.func_177229_b((Property)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(tall ? TABLE_TOP_TALL : TABLE_TOP_SHORT);
            if (!north && !west) {
                shapes.add(tall ? LEG_NORTH_WEST_TALL : LEG_NORTH_WEST_SHORT);
            }
            if (!north && !east) {
                shapes.add(tall ? LEG_NORTH_EAST_TALL : LEG_NORTH_EAST_SHORT);
            }
            if (!south && !west) {
                shapes.add(tall ? LEG_SOUTH_WEST_TALL : LEG_SOUTH_WEST_SHORT);
            }
            if (!south && !east) {
                shapes.add(tall ? LEG_SOUTH_EAST_TALL : LEG_SOUTH_EAST_SHORT);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        boolean tall = (Boolean)state.func_177229_b((Property)TALL);
        boolean north = this.isCoffeeTable(world, pos, Direction.NORTH, tall);
        boolean east = this.isCoffeeTable(world, pos, Direction.EAST, tall);
        boolean south = this.isCoffeeTable(world, pos, Direction.SOUTH, tall);
        boolean west = this.isCoffeeTable(world, pos, Direction.WEST, tall);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    private boolean isCoffeeTable(IWorld world, BlockPos source, Direction direction, boolean tall) {
        BlockState state = world.func_180495_p(source.func_177972_a(direction));
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((Property)TALL) == tall;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        BlockState state = context.func_195991_k().func_180495_p(pos);
        if (state.func_177230_c() == this) {
            return (BlockState)state.func_206870_a((Property)TALL, (Comparable)Boolean.valueOf(true));
        }
        return super.func_196258_a(context);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        return (Boolean)state.func_177229_b((Property)TALL) == false && stack.func_77973_b() == this.func_199767_j();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH});
        builder.func_206894_a(new Property[]{EAST});
        builder.func_206894_a(new Property[]{SOUTH});
        builder.func_206894_a(new Property[]{WEST});
        builder.func_206894_a(new Property[]{TALL});
    }
}

