/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.client;

import com.nosiphus.furniture.client.event.CreativeScreenEvents;
import com.nosiphus.furniture.client.renderer.tileentity.SinkTileEntityRenderer;
import com.nosiphus.furniture.core.ModBlocks;
import com.nosiphus.furniture.core.ModTileEntities;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientHandler {
    public static void setup() {
        ClientHandler.registerTileEntityRenderers();
        ClientHandler.registerLayers();
        if (!ModList.get().isLoaded("filters")) {
            MinecraftForge.EVENT_BUS.register((Object)new CreativeScreenEvents());
        }
    }

    private static void registerTileEntityRenderers() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.SINK.get()), SinkTileEntityRenderer::new);
    }

    private static void registerLayers() {
        Predicate<RenderType> cutoutPredicate = renderType -> renderType == RenderType.func_228643_e_();
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.MICROWAVE_DARK.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.MICROWAVE_LIGHT.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.OVEN_DARK.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.OVEN_LIGHT.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SHOWER_DARK.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SHOWER_LIGHT.get()), cutoutPredicate);
    }
}

