/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class DecimalProperty
extends ConfigProperty {
    private double value;
    private double defaultValue;
    private ConfigProperty.DecimalFormatter formatter = ConfigProperty.DecimalFormatter.RAW_2;
    private Supplier<Double> min = () -> Double.NEGATIVE_INFINITY;
    private Supplier<Double> max = () -> Double.POSITIVE_INFINITY;
    private BiConsumer<ItemStack, DecimalProperty> changeListener = null;

    public DecimalProperty(String name, double defaultValue) {
        super(name);
        this.value = this.defaultValue = defaultValue;
    }

    public DecimalProperty(String name, ITextComponent displayName, double defaultValue) {
        super(name, displayName);
        this.value = this.defaultValue = defaultValue;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = MathHelper.clip((double)value, (double)this.getMin(), (double)this.getMax());
    }

    public DecimalProperty min(double minValue) {
        this.min = () -> minValue;
        this.validateValue();
        return this;
    }

    public DecimalProperty min(Supplier<Double> minSupplier) {
        this.min = minSupplier;
        this.validateValue();
        return this;
    }

    public DecimalProperty max(double maxValue) {
        this.max = () -> maxValue;
        this.validateValue();
        return this;
    }

    public DecimalProperty max(Supplier<Double> maxSupplier) {
        this.max = maxSupplier;
        this.validateValue();
        return this;
    }

    public DecimalProperty range(double minValue, double maxValue) {
        this.min = () -> minValue;
        this.max = () -> maxValue;
        this.validateValue();
        return this;
    }

    public DecimalProperty range(Supplier<Double> minSupplier, Supplier<Double> maxSupplier) {
        this.min = minSupplier;
        this.max = maxSupplier;
        this.validateValue();
        return this;
    }

    public double getMin() {
        return this.min.get();
    }

    public double getMax() {
        return this.max.get();
    }

    @Override
    public String getDisplayValue() {
        return this.formatter.format(this.getValue());
    }

    @Override
    public void onValueChanged(ItemStack stack) {
        if (this.changeListener != null) {
            this.changeListener.accept(stack, this);
        }
    }

    @Override
    public void validateValue() {
        this.value = Math.max(this.min.get(), Math.min(this.max.get(), this.value));
    }

    @Override
    public ConfigProperty.Type getType() {
        return ConfigProperty.Type.DECIMAL;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.run();
    }

    public void setChangeListener(Consumer<ItemStack> changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.accept((ItemStack)stack);
    }

    public void setChangeListener(BiConsumer<ItemStack, DecimalProperty> changeListener) {
        this.changeListener = changeListener;
    }

    public DecimalProperty setFormatter(ConfigProperty.DecimalFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public ConfigProperty.DecimalFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74780_a("value", this.value);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("value")) {
            this.value = nbt.func_74769_h("value");
        }
        this.value = Math.max(this.min.get(), Math.min(this.max.get(), this.value));
        super.deserializeNBT(nbt);
    }

    @Override
    public void serializeMCData(MCDataOutput output) {
        super.serializeMCData(output);
        output.writeDouble(this.value);
    }

    @Override
    public void deSerializeMCData(MCDataInput input) {
        super.deSerializeMCData(input);
        this.value = Math.max(this.min.get(), Math.min(this.max.get(), input.readDouble()));
    }

    @Override
    public void loadData(PropertyData data, ItemStack stack) {
        this.value = Math.max(this.min.get(), Math.min(this.max.get(), data.decimalValue));
        this.onValueChanged(stack);
    }
}

