/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.UndyingData;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class UndyingEntity
extends ModuleEntity {
    private int charge;
    private int invulnerableTime = 0;

    public UndyingEntity(Module<UndyingData> module) {
        super(module);
    }

    @Override
    public void onInstalled(ModuleContext context) {
        super.onInstalled(context);
        this.invulnerableTime = 0;
    }

    @Override
    public void tick(ModuleContext moduleContext) {
        if (this.invulnerableTime > 0) {
            LivingEntity entity;
            --this.invulnerableTime;
            if (moduleContext instanceof StackModuleContext && (entity = ((StackModuleContext)moduleContext).getEntity()) instanceof PlayerEntity) {
                if (this.invulnerableTime == 0) {
                    ((PlayerEntity)entity).func_146105_b((ITextComponent)new StringTextComponent(""), true);
                } else {
                    ((PlayerEntity)entity).func_146105_b((ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.invuln.active", new Object[]{MathUtils.round((double)((double)this.invulnerableTime / 20.0), (double)10.0)}).func_240699_a_(TextFormatting.GOLD), true);
                }
            }
        }
        IOPStorageModifiable storage = moduleContext.getOpStorage();
        if (!(moduleContext instanceof StackModuleContext) || !EffectiveSide.get().isServer() || storage == null) {
            return;
        }
        StackModuleContext context = (StackModuleContext)moduleContext;
        UndyingData data = (UndyingData)this.module.getData();
        if (!context.isEquipped() || this.charge >= data.getChargeTime()) {
            return;
        }
        if (storage.getOPStored() >= data.getChargeEnergyRate()) {
            storage.modifyEnergyStored(-data.getChargeEnergyRate());
            ++this.charge;
        }
    }

    public boolean tryBlockDamage(LivingAttackEvent event) {
        if (this.invulnerableTime > 0) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public boolean tryBlockDamage(LivingDamageEvent event) {
        if (this.invulnerableTime > 0) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public boolean isCharged() {
        UndyingData data = (UndyingData)this.module.getData();
        return this.charge >= data.getChargeTime();
    }

    public double getCharge() {
        UndyingData data = (UndyingData)this.module.getData();
        return (double)this.charge / (double)data.getChargeTime();
    }

    public boolean tryBlockDeath(LivingDeathEvent event) {
        UndyingData data = (UndyingData)this.module.getData();
        if (this.charge >= data.getChargeTime()) {
            LivingEntity entity = event.getEntityLiving();
            entity.func_70606_j(entity.func_110143_aJ() + data.getHealthBoost());
            ItemStack stack = entity.func_184582_a(EquipmentSlotType.CHEST);
            if (!stack.func_190926_b()) {
                LazyOptional optionalHost = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
                optionalHost.ifPresent(stackHost -> {
                    ShieldControlEntity shield = stackHost.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
                    if (shield != null) {
                        shield.boost(data.getShieldBoost(), data.getShieldBoostTime());
                    }
                });
            }
            if (this.module.getModuleTechLevel().index >= 2) {
                entity.func_70066_B();
                Iterator iterator = entity.func_193076_bZ().values().iterator();
                while (iterator.hasNext()) {
                    EffectInstance effect = (EffectInstance)iterator.next();
                    if (effect.func_188419_a().func_188408_i()) continue;
                    entity.func_70688_c(effect);
                    iterator.remove();
                }
            }
            this.charge = 0;
            DraconicNetwork.sendUndyingActivation(entity, this.module.getItem());
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_191263_gW, SoundCategory.PLAYERS, 5.0f, 0.95f + entity.field_70170_p.field_73012_v.nextFloat() * 0.1f);
            this.invulnerableTime = data.getInvulnerableTime();
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderSlotOverlay(IRenderTypeBuffer getter, Minecraft mc, int x, int y, int width, int height, double mouseX, double mouseY, boolean mouseOver, float partialTicks) {
        UndyingData data = (UndyingData)this.module.getData();
        if (this.charge >= data.getChargeTime()) {
            return;
        }
        double diameter = (double)Math.min(width, height) * 0.425;
        double progress = (double)this.charge / Math.max(1.0, (double)data.getChargeTime());
        MatrixStack mStack = new MatrixStack();
        GuiHelper.drawRect((IRenderTypeBuffer)getter, (MatrixStack)mStack, (double)x, (double)y, (double)width, (double)height, (int)0x20FF0000);
        IVertexBuilder builder = getter.getBuffer(GuiHelperOld.FAN_TYPE);
        builder.func_225582_a_((double)x + (double)width / 2.0, (double)y + (double)height / 2.0, 0.0).func_225586_a_(0, 255, 255, 64).func_181675_d();
        for (double d = 0.0; d <= 1.0; d += 0.03333333333333333) {
            double angle = d * progress + 0.5 - progress;
            double vertX = (double)x + (double)width / 2.0 + Math.sin(angle * (Math.PI * 2)) * diameter;
            double vertY = (double)y + (double)height / 2.0 + Math.cos(angle * (Math.PI * 2)) * diameter;
            builder.func_225582_a_(vertX, vertY, 0.0).func_225586_a_(255, 255, 255, 64).func_181675_d();
        }
        ToolRenderBase.endBatch(getter);
        String pText = (int)(progress * 100.0) + "%";
        String tText = (data.getChargeTime() - this.charge) / 20 + "s";
        UndyingEntity.drawBackgroundString(getter, mStack, mc.field_71466_p, pText, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f - 8.0f, 0, 0x4000FF00, 1, false, true);
        UndyingEntity.drawBackgroundString(getter, mStack, mc.field_71466_p, tText, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f + 1.0f, 0, 0x4000FF00, 1, false, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawBackgroundString(IRenderTypeBuffer getter, MatrixStack mStack, FontRenderer font, String text, float x, float y, int colour, int background, int padding, boolean shadow, boolean centered) {
        MatrixStack matrixstack = new MatrixStack();
        int width = font.func_78256_a(text);
        x = centered ? x - (float)width / 2.0f : x;
        double d = x - (float)padding;
        double d2 = y - (float)padding;
        double d3 = width + padding * 2;
        font.getClass();
        GuiHelper.drawRect((IRenderTypeBuffer)getter, (MatrixStack)mStack, (double)d, (double)d2, (double)d3, (double)(9 - 2 + padding * 2), (int)background);
        font.func_228079_a_(text, x, y, colour, shadow, matrixstack.func_227866_c_().func_227870_a_(), getter, false, 0, 0xF000F0);
    }

    @Override
    public void writeToItemStack(ItemStack stack, ModuleContext context) {
        super.writeToItemStack(stack, context);
        stack.func_196082_o().func_74768_a("charge", this.charge);
    }

    @Override
    public void readFromItemStack(ItemStack stack, ModuleContext context) {
        super.readFromItemStack(stack, context);
        if (stack.func_77942_o()) {
            this.charge = stack.func_196082_o().func_74762_e("charge");
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("charge", this.charge);
        compound.func_74768_a("invul", this.invulnerableTime);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.charge = compound.func_74762_e("charge");
        this.invulnerableTime = compound.func_74762_e("invul");
    }
}

