/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.IMultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.TileCoreStructure;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.world.EnergyCoreStructure;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class EnergyCoreStructureBlock
extends BlockBCore {
    public EnergyCoreStructureBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCoreStructure();
    }

    public void observedNeighborChange(BlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        if (EnergyCoreStructure.coreForming) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCoreStructure && ((TileCoreStructure)tile).getController() == null) {
            ((TileCoreStructure)tile).revert();
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (EnergyCoreStructure.coreForming) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCoreStructure && ((TileCoreStructure)tile).getController() == null) {
            ((TileCoreStructure)tile).revert();
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCoreStructure) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(((TileCoreStructure)tile).blockName.get()));
            IMultiBlockPart master = ((TileCoreStructure)tile).getController();
            if (master != null) {
                world.func_217377_a(pos, false);
                master.validateStructure();
                if (block != Blocks.field_150350_a && !player.field_71075_bZ.field_75098_d) {
                    EnergyCoreStructureBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)block));
                }
            }
        }
        return true;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCoreStructure) {
            if (((TileCoreStructure)tile).blockName.get().equals("draconicevolution:block_draconium")) {
                return new ItemStack((IItemProvider)DEContent.block_draconium);
            }
            if (((TileCoreStructure)tile).blockName.get().equals("draconicevolution:block_draconium_awakened")) {
                return new ItemStack((IItemProvider)DEContent.block_draconium_awakened);
            }
            if (((TileCoreStructure)tile).blockName.get().equals("draconicevolution:energy_core_stabilizer")) {
                return new ItemStack((IItemProvider)DEContent.energy_core_stabilizer, 1);
            }
            if (((TileCoreStructure)tile).blockName.get().equals("minecraft:glass")) {
                return new ItemStack((IItemProvider)Blocks.field_150359_w);
            }
            if (((TileCoreStructure)tile).blockName.get().equals("minecraft:redstone_block")) {
                return new ItemStack((IItemProvider)Blocks.field_150451_bX);
            }
        }
        return ItemStack.field_190927_a;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        IMultiBlockPart controller;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCoreStructure && ((TileCoreStructure)tile).blockName.get().equals("draconicevolution:energy_core_stabilizer") && (controller = ((TileCoreStructure)tile).getController()) instanceof TileEnergyCoreStabilizer) {
            TileEnergyCoreStabilizer stabilizer = (TileEnergyCoreStabilizer)controller;
            if (stabilizer.isValidMultiBlock.get()) {
                BlockState stabState = world.func_180495_p(stabilizer.func_174877_v());
                BlockPos offset = stabilizer.func_174877_v().func_177973_b((Vector3i)pos);
                return stabState.func_177230_c().func_220053_a(stabState, world, stabilizer.func_174877_v(), context).func_197751_a((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
            }
        }
        return VoxelShapes.func_197868_b();
    }
}

