/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.MultiIndexedVoxelShape;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlacedItem
extends BlockBCore {
    private static final VoxelShape FALLBACK_SHAPE = VoxelShapes.func_197873_a((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    private static Int2ObjectMap<VoxelShape> SHAPE_CACHE = new Int2ObjectOpenHashMap();
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;

    public PlacedItem(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    private static VoxelShape computeShape(int stackCount, boolean tool, boolean[] isBlock, Direction facing, boolean getCollisionShape) {
        int shapeConfig = 0;
        shapeConfig |= facing.ordinal() & 7;
        shapeConfig |= (tool ? 1 : 0) << 3;
        shapeConfig |= (getCollisionShape ? 1 : 0) << 4;
        for (int i = 0; i < stackCount; ++i) {
            shapeConfig |= (2 | (isBlock[i] ? 1 : 0)) << 5 + i * 2;
        }
        return (VoxelShape)SHAPE_CACHE.computeIfAbsent(shapeConfig, integer -> {
            Cuboid6 baseCuboid = new Cuboid6(0.5, 0.0, 0.5, 0.5, 0.0, 0.5);
            ArrayList<Cuboid6> stackCuboids = new ArrayList<Cuboid6>();
            boolean toolSize = tool && stackCount == 1;
            for (int i = 0; i < stackCount; ++i) {
                double xOffset = PlacedItem.getXOffset(i, stackCount);
                double zOffset = PlacedItem.getZOffset(i, stackCount);
                double xzSize = 3.5;
                double ySize = 0.029296875;
                if (isBlock[i]) {
                    xzSize = 3.0;
                    ySize = 0.375;
                } else if (toolSize) {
                    xzSize = 7.0;
                    ySize = 0.056640625;
                }
                Cuboid6 stackBox = new Cuboid6((8.0 - xzSize) / 16.0 + xOffset, 0.0, (8.0 - xzSize) / 16.0 + zOffset, (8.0 + xzSize) / 16.0 + xOffset, ySize, (8.0 + xzSize) / 16.0 + zOffset);
                baseCuboid.enclose(stackBox);
                stackCuboids.add(stackBox);
            }
            if (getCollisionShape) {
                PlacedItem.rotateCuboid(baseCuboid, facing);
                return VoxelShapeCache.getShape((Cuboid6)baseCuboid);
            }
            baseCuboid.expand(0.015625);
            baseCuboid.max.y = 0.00625;
            baseCuboid.min.y = 0.0;
            PlacedItem.rotateCuboid(baseCuboid, facing);
            ImmutableSet.Builder cuboids = ImmutableSet.builder();
            IndexedVoxelShape baseShape = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)baseCuboid), (Object)0);
            cuboids.add((Object)baseShape);
            for (int i = 0; i < stackCuboids.size(); ++i) {
                PlacedItem.rotateCuboid((Cuboid6)stackCuboids.get(i), facing);
                cuboids.add((Object)new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)((Cuboid6)stackCuboids.get(i))), (Object)(1 + i)));
            }
            return new MultiIndexedVoxelShape((VoxelShape)baseShape, cuboids.build());
        });
    }

    private static void rotateCuboid(Cuboid6 cuboid, Direction rotation) {
        switch (rotation) {
            case DOWN: {
                cuboid.apply(new Rotation(3.1415926535897403, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                break;
            }
            case NORTH: {
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                break;
            }
            case SOUTH: {
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                cuboid.apply(new Rotation(3.1415926535897403, Vector3.Y_POS).at(new Vector3(0.5, 0.5, 0.5)));
                break;
            }
            case WEST: {
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                cuboid.apply(new Rotation(1.5707963267948701, Vector3.Y_POS).at(new Vector3(0.5, 0.5, 0.5)));
                break;
            }
            case EAST: {
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.Y_POS).at(new Vector3(0.5, 0.5, 0.5)));
            }
        }
    }

    public static double getXOffset(int index, int count) {
        double spacing = 0.25;
        double lowerVal = 3.5 + spacing;
        double upperVal = 7.0 + spacing * 2.0;
        if (count == 1) {
            return 0.0;
        }
        if (count == 2) {
            return -(lowerVal / 16.0) + (double)index * (upperVal / 16.0);
        }
        if (count == 3) {
            return index == 2 ? 0.0 : -(lowerVal / 16.0) + (double)index * (upperVal / 16.0);
        }
        return -(lowerVal / 16.0) + (double)(index % 2) * (upperVal / 16.0);
    }

    public static double getZOffset(int index, int count) {
        if (count <= 2) {
            return 0.0;
        }
        double spacing = 0.25;
        double lowerVal = 3.5 + spacing;
        return index <= 1 ? -(lowerVal / 16.0) : lowerVal / 16.0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TilePlacedItem();
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return state.func_204520_s().func_206888_e();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        TileEntity te = reader.func_175625_s(pos);
        if (te instanceof TilePlacedItem) {
            TilePlacedItem tile = (TilePlacedItem)te;
            return PlacedItem.computeShape(tile.stackCount.get(), tile.toolMode.get(), tile.getBlockArray(), (Direction)state.func_177229_b((Property)FACING), false);
        }
        return FALLBACK_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        TileEntity te = reader.func_175625_s(pos);
        if (te instanceof TilePlacedItem) {
            TilePlacedItem tile = (TilePlacedItem)te;
            return PlacedItem.computeShape(tile.stackCount.get(), tile.toolMode.get(), tile.getBlockArray(), (Direction)state.func_177229_b((Property)FACING), true);
        }
        return FALLBACK_SHAPE;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePlacedItem) {
            List<ItemStack> stacks = ((TilePlacedItem)tile).getStacksInOrder();
            int index = target.subHit - 1;
            if (index >= 0 && index < stacks.size()) {
                ItemStack stack = stacks.get(index).func_77946_l();
                stack.func_190920_e(1);
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePlacedItem) {
            ((TilePlacedItem)tile).onBroken(Vector3.fromTileCenter((TileEntity)tile), false);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }
}

