/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortalClient;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Portal
extends BlockBCore {
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.func_177709_a((String)"axis", Direction.Axis.class);
    public static final BooleanProperty DRAW_UP = BooleanProperty.func_177716_a((String)"drawup");
    public static final BooleanProperty DRAW_DOWN = BooleanProperty.func_177716_a((String)"drawdown");
    public static final BooleanProperty DRAW_EAST = BooleanProperty.func_177716_a((String)"draweast");
    public static final BooleanProperty DRAW_WEST = BooleanProperty.func_177716_a((String)"drawwest");
    public static final BooleanProperty VISIBLE = BooleanProperty.func_177716_a((String)"visible");

    public Portal(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X)).func_206870_a((Property)DRAW_UP, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)DRAW_EAST, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)DRAW_WEST, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)VISIBLE, (Comparable)Boolean.valueOf(true)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS, DRAW_UP, DRAW_DOWN, DRAW_EAST, DRAW_WEST, VISIBLE});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return world instanceof ServerWorld ? new TilePortal() : new TilePortalClient();
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TilePortal)) {
            return false;
        }
        TileDislocatorReceptacle controller = ((TilePortal)tile).getController();
        if (controller != null && controller.ignitionStage.get() == 2) {
            return true;
        }
        if (!((TilePortal)tile).isPortalActive()) {
            return false;
        }
        for (Direction dir : FacingUtils.getFacingsAroundAxis((Direction.Axis)((Direction.Axis)state.func_177229_b(AXIS)))) {
            if (Portal.isFrame(world, pos.func_177972_a(dir)) || Portal.isPortal(world, pos.func_177972_a(dir))) continue;
            return false;
        }
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            world.func_217377_a(pos, false);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileDislocatorReceptacle) {
                ((TileDislocatorReceptacle)tile).deactivate();
            }
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
        world.func_175656_a(pos, Portal.getPlacementState(state, world, pos));
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePortal && ((TilePortal)tile).getController() != null) {
            ((TilePortal)tile).getController().handleEntityTeleport(entity);
        }
    }

    public static BlockState getPlacementState(BlockState state, World world, BlockPos pos) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)DRAW_UP, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177984_a())))).func_206870_a((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177977_b())))).func_206870_a((Property)DRAW_EAST, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177974_f())))).func_206870_a((Property)DRAW_WEST, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177976_e())));
            }
            case Y: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)DRAW_UP, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177978_c())))).func_206870_a((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177968_d())))).func_206870_a((Property)DRAW_EAST, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177974_f())))).func_206870_a((Property)DRAW_WEST, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177976_e())));
            }
            case X: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)DRAW_UP, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177984_a())))).func_206870_a((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177977_b())))).func_206870_a((Property)DRAW_EAST, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177968_d())))).func_206870_a((Property)DRAW_WEST, (Comparable)Boolean.valueOf(Portal.isFrame((IWorldReader)world, pos.func_177978_c())));
            }
        }
        return state;
    }

    private static boolean isFrame(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == DEContent.infused_obsidian || state.func_177230_c() == DEContent.dislocator_receptacle;
    }

    private static boolean isPortal(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == DEContent.portal;
    }
}

