/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.Vec3B;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerClientWireless;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerServerWireless;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXRing;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ChunkHolder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCrystalWirelessIO
extends TileCrystalBase {
    protected Map<Vec3B, Direction> receiverSideMap = new HashMap<Vec3B, Direction>();
    protected LinkedList<Vec3B> linkedReceivers = new LinkedList();
    protected LinkedList<BlockPos> receiverCache = null;
    protected Map<BlockPos, Direction> receiverFaceCache = null;
    protected List<LinkedDevice> fastList = new ArrayList<LinkedDevice>();
    protected List<LinkedDevice> slowList = new ArrayList<LinkedDevice>();
    public LinkedList<int[]> receiverTransferRates = new LinkedList();
    public LinkedList<Byte> receiverFlowRates = new LinkedList();
    public final ManagedBool useUpdateOptimisation = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("transport_state", true, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public final ManagedBool inputMode = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("input_mode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public Map<Integer, Integer> containerReceiverFlow = new HashMap<Integer, Integer>();

    public TileCrystalWirelessIO() {
        super(DEContent.tile_crystal_wireless);
    }

    public TileCrystalWirelessIO(TechLevel techLevel) {
        super(DEContent.tile_crystal_wireless, techLevel);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateEnergyFlow();
        }
        super.func_73660_a();
    }

    private void updateEnergyFlow() {
        if (this.receiverTransferRates.size() != this.linkedReceivers.size()) {
            this.rebuildReceiverTransferList();
        }
        this.getReceiversFaces();
        ArrayList<LinkedDevice> moveToSlow = new ArrayList<LinkedDevice>();
        for (LinkedDevice receiver : this.fastList) {
            if (!this.updateDevice(receiver)) {
                this.removeReceiver(receiver.pos);
                return;
            }
            if (receiver.timeOut <= 40) continue;
            moveToSlow.add(receiver);
        }
        if (this.tick % 80 == 0) {
            ArrayList<LinkedDevice> moveToFast = new ArrayList<LinkedDevice>();
            for (LinkedDevice receiver : this.slowList) {
                if (!this.updateDevice(receiver)) {
                    this.removeReceiver(receiver.pos);
                    return;
                }
                if (receiver.timeOut != 0) continue;
                moveToFast.add(receiver);
            }
            if (!moveToFast.isEmpty()) {
                this.fastList.addAll(moveToFast);
                this.slowList.removeAll(moveToFast);
            }
        }
        if (!moveToSlow.isEmpty()) {
            this.slowList.addAll(moveToSlow);
            this.fastList.removeAll(moveToSlow);
        }
        if (!this.field_145850_b.field_72995_K && DEEventHandler.serverTicks % 10 == 0) {
            this.receiverFlowRates.clear();
            for (int i = 0; i < this.linkedReceivers.size(); ++i) {
                this.receiverFlowRates.add(this.flowConversion(this.receiverTransfer(i)));
            }
        }
    }

    @Override
    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_225608_bj_()) {
            this.inputMode.invert();
            return true;
        }
        return super.onBlockActivated(state, player, handIn, hit);
    }

    protected boolean updateDevice(LinkedDevice receiver) {
        long transferred;
        if (!receiver.isLinkValid(this.field_145850_b)) {
            return receiver.invalidTime++ < 100;
        }
        receiver.invalidTime = 0;
        TileEntity tile = receiver.getCachedTile();
        if (tile == null) {
            receiver.timeOut = receiver.timeOut < 40 ? 40 : ++receiver.timeOut;
            return true;
        }
        if (this.inputMode.get()) {
            transferred = EnergyUtils.extractEnergy((TileEntity)tile, (long)this.opStorage.receiveEnergy(this.getMaxWirelessTransfer(), true), (Direction)receiver.side, (boolean)false);
            this.opStorage.receiveOP(transferred, false);
        } else {
            transferred = EnergyUtils.insertEnergy((TileEntity)tile, (long)this.opStorage.extractEnergy(this.getMaxWirelessTransfer(), true), (Direction)receiver.side, (boolean)false);
            this.opStorage.extractOP(transferred, false);
        }
        receiver.timeOut = transferred > 0L ? 0 : ++receiver.timeOut;
        this.receiverTransferRates.get((int)receiver.index)[this.tick % 20] = (int)Math.min(transferred, Integer.MAX_VALUE);
        return true;
    }

    public void rebuildReceiverTransferList() {
        this.receiverTransferRates.clear();
        this.receiverFlowRates.clear();
        for (int i = 0; i < this.linkedReceivers.size(); ++i) {
            this.receiverTransferRates.add(new int[20]);
            this.receiverFlowRates.add((byte)0);
        }
    }

    public int getMaxWirelessTransfer() {
        return this.getTier() == 0 ? 32000 : (this.getTier() == 1 ? 128000 : 512000);
    }

    public int receiverTransfer(int index) {
        long sum = 0L;
        for (int transfer : this.receiverTransferRates.get(index)) {
            sum += (long)transfer;
        }
        return (int)(sum / 20L);
    }

    public byte flowConversion(int transferRate) {
        double d = (double)transferRate / ((double)this.getMaxWirelessTransfer() * 0.01 + (double)transferRate);
        return (byte)(d * 255.0);
    }

    @Override
    public boolean binderUsed(PlayerEntity player, BlockPos linkTarget, Direction sideClicked) {
        TileEntity tile = this.field_145850_b.func_175625_s(linkTarget);
        if (tile == null || tile instanceof ICrystalLink) {
            return super.binderUsed(player, linkTarget, sideClicked);
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        Vec3B offset = this.getOffset(linkTarget);
        if (this.linkedReceivers.contains(offset)) {
            this.removeReceiver(linkTarget);
            ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.link_broken").func_240699_a_(TextFormatting.GREEN), (int)99);
            return true;
        }
        if (this.inputMode.get()) {
            if (!EnergyUtils.canExtractEnergy((TileEntity)tile, (Direction)sideClicked)) {
                if (EnergyUtils.getStorage((TileEntity)tile, (Direction)sideClicked) != null) {
                    ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.side_can_not_extract").func_240699_a_(TextFormatting.RED), (int)99);
                    return false;
                }
                return super.binderUsed(player, linkTarget, sideClicked);
            }
        } else if (!EnergyUtils.canReceiveEnergy((TileEntity)tile, (Direction)sideClicked)) {
            if (EnergyUtils.getStorage((TileEntity)tile, (Direction)sideClicked) != null) {
                ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.side_can_not_receive").func_240699_a_(TextFormatting.RED), (int)99);
                return false;
            }
            return super.binderUsed(player, linkTarget, sideClicked);
        }
        if (this.linkedReceivers.size() >= this.getMaxReceivers()) {
            ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.max_receivers").func_240699_a_(TextFormatting.RED), (int)99);
            return false;
        }
        this.addReceiver(linkTarget, sideClicked);
        ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.devices_linked").func_240699_a_(TextFormatting.GREEN), (int)99);
        return true;
    }

    public List<BlockPos> getReceivers() {
        if (this.receiverCache == null || this.receiverCache.size() != this.linkedReceivers.size()) {
            this.reCachePositions();
        }
        return this.receiverCache;
    }

    public Map<BlockPos, Direction> getReceiversFaces() {
        if (this.receiverCache == null || this.receiverCache.size() != this.linkedReceivers.size() || this.receiverFaceCache == null || this.receiverFaceCache.size() != this.linkedReceivers.size()) {
            this.reCachePositions();
        }
        return this.receiverFaceCache;
    }

    public int getMaxReceivers() {
        return this.getTier() == 0 ? 16 : (this.getTier() == 1 ? 32 : 64);
    }

    private void reCachePositions() {
        this.receiverCache = new LinkedList();
        this.receiverFaceCache = new HashMap<BlockPos, Direction>();
        this.fastList.clear();
        this.slowList.clear();
        for (Vec3B offset : this.linkedReceivers) {
            this.receiverCache.add(this.fromOffset(offset));
            this.receiverFaceCache.put(this.fromOffset(offset), this.receiverSideMap.get(offset));
            this.fastList.add(new LinkedDevice(this.linkedReceivers.indexOf(offset), this.fromOffset(offset), this.receiverSideMap.get(offset)));
        }
        this.updateBlock();
    }

    @Override
    public EnergyCrystal.CrystalType getCrystalType() {
        return EnergyCrystal.CrystalType.WIRELESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CrystalFXBase createStaticFX() {
        return new CrystalFXRing((ClientWorld)this.field_145850_b, this);
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        Vec3D thisVec = Vec3D.getCenter((BlockPos)this.field_174879_c);
        Vec3D targVec = Vec3D.getCenter((BlockPos)linkTo);
        double dist = thisVec.distXZ(targVec);
        double offM = 0.4;
        if (dist == 0.0) {
            if (this.field_174879_c.func_177956_o() > linkTo.func_177956_o()) {
                return thisVec.subtract(0.0, 0.4, 0.0);
            }
            return thisVec.subtract(0.0, -0.4, 0.0);
        }
        double xDist = thisVec.x - targVec.x;
        double zDist = thisVec.z - targVec.z;
        double xOff = xDist / dist;
        double zOff = zDist / dist;
        return thisVec.subtract(xOff * offM, 0.0, zOff * offM);
    }

    @Override
    public boolean renderBeamTermination() {
        return true;
    }

    @Override
    public ENetFXHandler createServerFXHandler() {
        return new ENetFXHandlerServerWireless(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ENetFXHandler createClientFXHandler() {
        return new ENetFXHandlerClientWireless(this);
    }

    @Override
    public void addDisplayData(List<ITextComponent> displayList) {
        super.addDisplayData(displayList);
        displayList.add((ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.hud_wireless_links").func_240702_b_(": " + this.getReceivers().size() + " / " + this.getMaxReceivers()).func_240699_a_(TextFormatting.GREEN));
        TextFormatting colour = !this.inputMode.get() ? TextFormatting.GOLD : TextFormatting.DARK_AQUA;
        displayList.add((ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.io_output_" + !this.inputMode.get(), new Object[]{colour}));
    }

    public void addReceiver(BlockPos pos, Direction side) {
        Vec3B offset = this.getOffset(pos);
        this.linkedReceivers.add(offset);
        this.receiverSideMap.put(offset, side);
        this.reCachePositions();
        this.updateBlock();
    }

    public void removeReceiver(BlockPos pos) {
        Vec3B offset = this.getOffset(pos);
        this.linkedReceivers.remove(offset);
        this.receiverSideMap.remove(offset);
        this.reCachePositions();
        this.updateBlock();
    }

    @Override
    public void writeExtraNBT(CompoundNBT compound) {
        super.writeExtraNBT(compound);
        ListNBT list = new ListNBT();
        for (Vec3B vec : this.linkedReceivers) {
            CompoundNBT receiver = new CompoundNBT();
            receiver.func_74773_a("offset", new byte[]{vec.x, vec.y, vec.z});
            receiver.func_74774_a("side", (byte)this.receiverSideMap.get(vec).func_176745_a());
            list.add((Object)receiver);
        }
        compound.func_218657_a("linked_receivers", (INBT)list);
    }

    @Override
    public void readExtraNBT(CompoundNBT compound) {
        super.readExtraNBT(compound);
        ListNBT list = compound.func_150295_c("linked_receivers", 10);
        this.linkedReceivers.clear();
        this.receiverSideMap.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT receiver = list.func_150305_b(i);
            byte[] offset = receiver.func_74770_j("offset");
            Vec3B vec = new Vec3B(offset[0], offset[1], offset[2]);
            this.linkedReceivers.add(vec);
            this.receiverSideMap.put(vec, Direction.func_82600_a((int)receiver.func_74771_c("side")));
        }
        this.receiverCache = null;
    }

    @Override
    public void detectAndSendContainerChanges(List<IContainerListener> listeners) {
        super.detectAndSendContainerChanges(listeners);
        if (this.linkedReceivers.size() != this.receiverTransferRates.size() && !this.field_145850_b.field_72995_K) {
            this.rebuildReceiverTransferList();
        }
        List<BlockPos> positions = this.getReceivers();
        ListNBT list = new ListNBT();
        for (BlockPos lPos : positions) {
            int index = positions.indexOf(lPos);
            if (this.containerReceiverFlow.containsKey(index) && this.containerReceiverFlow.get(index).intValue() == this.receiverTransfer(index)) continue;
            this.containerReceiverFlow.put(index, this.receiverTransfer(index));
            CompoundNBT data = new CompoundNBT();
            data.func_74774_a("I", (byte)index);
            data.func_74768_a("E", this.receiverTransfer(index));
            list.add((Object)data);
        }
        CompoundNBT compound = new CompoundNBT();
        if (!list.isEmpty()) {
            compound.func_218657_a("L", (INBT)list);
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> output.writeCompoundNBT(compound), 1));
        } else if (this.containerReceiverFlow.size() > this.linkedReceivers.size()) {
            this.containerReceiverFlow.clear();
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> output.writeCompoundNBT(compound), 1));
        }
    }

    @Override
    public void receivePacketFromServer(MCDataInput data, int id) {
        super.receivePacketFromServer(data, id);
        if (id == 1) {
            CompoundNBT compound = data.readCompoundNBT();
            ListNBT list = compound.func_150295_c("L", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tagData = list.func_150305_b(i);
                this.containerReceiverFlow.put(Integer.valueOf(tagData.func_74771_c("I")), tagData.func_74762_e("E"));
            }
        }
    }

    @Override
    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        super.receivePacketFromClient(data, client, id);
        if (id == 11) {
            int intValue = data.readInt();
            if (this.getReceivers().size() > intValue && intValue >= 0) {
                BlockPos target = this.getReceivers().get(intValue);
                this.removeReceiver(target);
            }
        } else if (id == 21) {
            ArrayList<BlockPos> links = new ArrayList<BlockPos>(this.getReceivers());
            for (BlockPos target : links) {
                this.removeReceiver(target);
            }
        }
    }

    private class LinkedDevice {
        public final int index;
        public final BlockPos pos;
        private Direction side;
        public int timeOut = 0;
        private TileEntity tileCache = null;
        private int invalidTime = 0;

        public LinkedDevice(int index, BlockPos pos, Direction side) {
            this.index = index;
            this.pos = pos;
            this.side = side;
        }

        public boolean isLinkValid(World world) {
            this.tileCache = world.func_175625_s(this.pos);
            return this.tileCache != null && EnergyUtils.getStorage((TileEntity)this.tileCache, (Direction)this.side) != null || !Utils.isAreaLoaded((World)world, (BlockPos)this.pos, (ChunkHolder.LocationType)ChunkHolder.LocationType.TICKING);
        }

        public TileEntity getCachedTile() {
            return this.tileCache;
        }
    }
}

