/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.utils.LogHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkHolder;

public abstract class TileReactorComponent
extends TileBCore
implements ITickableTileEntity {
    private final ManagedVec3I coreOffset = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("core_offset", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedEnum<Direction> facing = (ManagedEnum)this.register((IManagedData)new ManagedEnum("facing", (Enum)Direction.UP, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool isBound = (ManagedBool)this.register((IManagedData)new ManagedBool("is_bound", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedEnum<RSMode> rsMode = (ManagedEnum)this.register((IManagedData)new ManagedEnum("rs_mode", (Enum)RSMode.TEMP, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedInt rsPower = (ManagedInt)this.register((IManagedData)new ManagedInt("rs_power", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public float animRotation = 0.0f;
    public float animRotationSpeed = 0.0f;
    private TileReactorCore cachedCore = null;
    public boolean coreFalureIminent = false;
    private boolean moveCheckComplete = false;

    public TileReactorComponent(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public int getAccessDistanceSq() {
        return 256;
    }

    public void func_73660_a() {
        super.tick();
        this.moveCheckComplete = false;
        if (this.field_145850_b.field_72995_K) {
            TileReactorCore core = this.tryGetCore();
            if (core != null) {
                this.animRotationSpeed = core.shieldAnimationState * 15.0f;
                this.coreFalureIminent = core.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE;
            } else {
                this.coreFalureIminent = false;
                this.animRotationSpeed = 0.0f;
            }
            this.animRotation += this.animRotationSpeed;
            if (this.coreFalureIminent && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                this.animRotation = (float)((double)this.animRotation + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 360.0);
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                } else {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197613_f, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                }
            }
        } else {
            int rs;
            TileReactorCore core = this.getCachedCore();
            if (core != null && (rs = ((RSMode)this.rsMode.get()).getRSSignal(core)) != this.rsPower.get()) {
                this.rsPower.set(rs);
                this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
    }

    public void bindToCore(TileReactorCore core) {
        LogHelper.dev("Reactor-Comp: Bind To Core");
        this.isBound.set(true);
        this.coreOffset.set(this.getCoreOffset(core.func_174877_v()));
    }

    public void pokeCore() {
        TileReactorCore core;
        LogHelper.dev("Reactor-Comp: Try Poke Core");
        if (this.isBound.get() && (core = this.checkAndGetCore()) != null) {
            core.pokeCore(this, ((Direction)this.facing.get()).func_176734_d());
            return;
        }
        LogHelper.dev("Reactor-Comp: Try Poke Core | Find");
        for (int i = 1; i < 8; ++i) {
            BlockPos searchPos = this.field_174879_c.func_177967_a((Direction)this.facing.get(), i);
            if (this.field_145850_b.func_175623_d(searchPos)) continue;
            TileEntity tile = this.field_145850_b.func_175625_s(searchPos);
            LogHelper.dev("Reactor-Comp: Check: " + tile);
            LogHelper.dev("Reactor-Comp: Try Poke Core | Found: " + tile);
            if (tile instanceof TileReactorCore && i > 1) {
                ((TileReactorCore)tile).pokeCore(this, ((Direction)this.facing.get()).func_176734_d());
            }
            return;
        }
    }

    public void invalidateComponent() {
        this.isBound.set(false);
    }

    public void onPlaced() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.pokeCore();
    }

    public void onBroken() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileReactorCore core = this.checkAndGetCore();
        if (core != null) {
            core.componentBroken(this, ((Direction)this.facing.get()).func_176734_d());
        }
    }

    public void onActivated(PlayerEntity player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.pokeCore();
        TileReactorCore core = this.checkAndGetCore();
        if (core != null) {
            core.onComponentClicked(player, this);
        }
    }

    public void setRSMode(PlayerEntity player, RSMode rsMode) {
        if (this.field_145850_b.field_72995_K) {
            TileReactorCore core = this.tryGetCore();
            if (core != null) {
                core.sendPacketToServer(output -> output.writeString(rsMode.name()).writePos(this.func_174877_v()), 99);
            }
        } else {
            this.rsMode.set((Enum)rsMode);
        }
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        if (id == 0) {
            this.setRSMode((PlayerEntity)client, RSMode.valueOf(data.readString()));
        }
    }

    protected BlockPos getCorePos() {
        return this.field_174879_c.func_177973_b((Vector3i)this.coreOffset.get().getPos());
    }

    protected Vec3I getCoreOffset(BlockPos corePos) {
        return new Vec3I(this.field_174879_c.func_177973_b((Vector3i)corePos));
    }

    protected TileReactorCore checkAndGetCore() {
        if (!this.isBound.get()) {
            LogHelper.dev("Reactor-Comp: Not Bound");
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.getCorePos());
        if (tile instanceof TileReactorCore) {
            return (TileReactorCore)tile;
        }
        if (this.field_145850_b.isAreaLoaded(this.getCorePos(), 16)) {
            this.invalidateComponent();
        }
        LogHelper.dev("Reactor-Comp: Core Connection Lost");
        return null;
    }

    public TileReactorCore tryGetCore() {
        if (!this.isBound.get()) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.getCorePos());
        if (tile instanceof TileReactorCore) {
            return (TileReactorCore)tile;
        }
        return null;
    }

    public TileReactorCore getCachedCore() {
        if (this.isBound.get()) {
            BlockPos corePos = this.getCorePos();
            Chunk coreChunk = this.field_145850_b.func_175726_f(corePos);
            if (!Utils.isAreaLoaded((World)this.field_145850_b, (BlockPos)corePos, (ChunkHolder.LocationType)ChunkHolder.LocationType.TICKING)) {
                this.cachedCore = null;
                return null;
            }
            TileEntity tileAtPos = coreChunk.func_177424_a(corePos, Chunk.CreateEntityType.CHECK);
            if (tileAtPos == null || this.cachedCore == null || tileAtPos != this.cachedCore || tileAtPos.func_145837_r()) {
                TileEntity tile = this.field_145850_b.func_175625_s(corePos);
                if (tile instanceof TileReactorCore) {
                    this.cachedCore = (TileReactorCore)tile;
                } else {
                    this.cachedCore = null;
                    this.isBound.set(false);
                }
            }
        }
        return this.cachedCore;
    }

    public static enum RSMode {
        TEMP{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return (int)(tile.temperature.get() / 10000.0 * 15.0);
            }
        }
        ,
        TEMP_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - TEMP.getRSSignal(tile);
            }
        }
        ,
        FIELD{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                double value = tile.shieldCharge.get() / tile.maxShieldCharge.get();
                value -= 0.05;
                return (int)((value *= 1.2) * 15.0);
            }
        }
        ,
        FIELD_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - FIELD.getRSSignal(tile);
            }
        }
        ,
        SAT{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return (int)((double)tile.saturation.get() / (double)tile.maxSaturation.get() * 15.0);
            }
        }
        ,
        SAT_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - SAT.getRSSignal(tile);
            }
        }
        ,
        FUEL{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                double value = tile.convertedFuel.get() / (tile.convertedFuel.get() + tile.reactableFuel.get());
                value += 0.1;
                value = MathUtils.map((double)value, (double)0.1, (double)1.0, (double)0.0, (double)1.0);
                return (int)(value * 15.0);
            }
        }
        ,
        FUEL_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - FUEL.getRSSignal(tile);
            }
        };


        public abstract int getRSSignal(TileReactorCore var1);
    }
}

