/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor.tileentity;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public class TileReactorStabilizer
extends TileReactorComponent {
    public TileReactorStabilizer() {
        super(DEContent.tile_reactor_stabilizer);
        OPExtractor opExtractor = new OPExtractor(this);
        this.capManager.set(CapabilityOP.OP, (Object)opExtractor, new Direction[0]);
        this.capManager.setCapSideValidator((Object)opExtractor, face -> face == ((Direction)this.facing.get()).func_176734_d());
    }

    @Override
    public void func_73660_a() {
        TileEntity output;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileReactorCore tile = this.getCachedCore();
        if (tile != null && tile.reactorState.get() == TileReactorCore.ReactorState.RUNNING && (output = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(((Direction)this.facing.get()).func_176734_d()))) != null && EnergyUtils.canReceiveEnergy((TileEntity)output, (Direction)((Direction)this.facing.get()))) {
            long sent = EnergyUtils.insertEnergy((TileEntity)output, (long)tile.saturation.get(), (Direction)((Direction)this.facing.get()), (boolean)false);
            tile.saturation.subtract(sent);
        }
    }

    private class OPExtractor
    implements IOPStorage {
        private TileReactorStabilizer tile;

        public OPExtractor(TileReactorStabilizer tile) {
            this.tile = tile;
        }

        public long extractOP(long maxExtract, boolean simulate) {
            TileReactorCore core = TileReactorStabilizer.this.getCachedCore();
            if (core != null && core.reactorState.get() == TileReactorCore.ReactorState.RUNNING) {
                long subtracted = Math.min(core.saturation.get(), maxExtract);
                if (!simulate) {
                    core.saturation.subtract(subtracted);
                }
                return subtracted;
            }
            return 0L;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)this.extractOP(maxExtract, simulate);
        }

        public long getMaxOPStored() {
            return Long.MAX_VALUE;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

