/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.blocks.machines.Grinder;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileGrinder
extends TileBCore
implements ITickableTileEntity,
IRSSwitchable,
INamedContainerProvider,
IInteractTile {
    private static FakePlayer cachedFakePlayer;
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedByte aoe = (ManagedByte)this.register((IManagedData)new ManagedByte("aoe", (int)((byte)this.getMaxAOE()), new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool showAOE = (ManagedBool)this.register((IManagedData)new ManagedBool("show_aoe", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool collectItems = (ManagedBool)this.register((IManagedData)new ManagedBool("collect_items", true, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool collectXP = (ManagedBool)this.register((IManagedData)new ManagedBool("collect_xp", true, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER, DataFlags.CLIENT_CONTROL}));
    public final ManagedInt storedXP = (ManagedInt)this.register((IManagedData)new ManagedInt("stored_xp", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler(2);
    public EntityFilter entityFilter;
    public OPStorage opStorage = new OPStorage(1000000L, 128000L, 0L);
    public Entity targetA = null;
    public float animA = 0.8f;
    public Entity targetB = null;
    public float animB = 0.8f;
    private boolean swordFlipFlop = false;
    public float fanRotation = 0.0f;
    public float fanSpeed = 0.0f;
    public float aoeDisplay = 0.0f;
    public AxisAlignedBB killZone;
    private int coolDown = 0;
    private LivingEntity nextTarget = null;
    private int killRate = 5;

    public TileGrinder() {
        super(DEContent.tile_grinder);
        this.enablePlayerAccessTracking(true);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.installIOTracker(this.opStorage);
        this.capManager.setInternalManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler).saveBoth();
        this.setupPowerSlot((IItemHandler)this.itemHandler, 0, (IOPStorage)this.opStorage, false);
        this.entityFilter = new EntityFilter(true, new FilterType[]{FilterType.HOSTILE, FilterType.TAMED, FilterType.ADULTS, FilterType.ENTITY_TYPE, FilterType.FILTER_GROUP, FilterType.PLAYER});
        this.entityFilter.setDirtyHandler(() -> ((TileGrinder)this).func_70296_d());
        this.entityFilter.setTypePredicate(e -> e != FilterType.PLAYER || DEOldConfig.allowGrindingPlayers);
        this.entityFilter.setupServerPacketHandling(() -> this.createClientBoundPacket(0), packet -> this.sendPacketToClients(this.getAccessingPlayers(), (PacketCustom)packet));
        this.entityFilter.setupClientPacketHandling(() -> this.createServerBoundPacket(0), packetCustom -> BrandonsCore.proxy.sendToServer(packetCustom));
        this.setClientSidePacketHandler(0, input -> this.entityFilter.receivePacketFromServer(input));
        this.setServerSidePacketHandler(0, (input, player) -> this.entityFilter.receivePacketFromClient(input));
        this.setSavedDataObject("entity_filter", (INBTSerializable)this.entityFilter);
        this.setItemSavedDataObject("entity_filter", (INBTSerializable)this.entityFilter);
        this.aoe.setValidator(value -> (byte)MathHelper.clip((int)value.byteValue(), (int)1, (int)this.getMaxAOE()));
        this.aoe.addValueListener(e -> {
            this.killZone = null;
        });
    }

    private boolean canExtractItem(int slot, ItemStack stack) {
        return EnergyUtils.isEmptyOrInvalid((ItemStack)stack);
    }

    public void onPlayerOpenContainer(PlayerEntity player) {
        super.onPlayerOpenContainer(player);
        if (player instanceof ServerPlayerEntity) {
            this.entityFilter.syncClient((ServerPlayerEntity)player);
        }
    }

    public void func_73660_a() {
        super.tick();
        if (this.field_145850_b.field_72995_K) {
            if (this.animA < 1.0f) {
                this.animA += this.getAnimSpeed();
            } else {
                this.targetA = null;
            }
            if (this.animB < 1.0f) {
                this.animB += this.getAnimSpeed();
            } else {
                this.targetB = null;
            }
            this.fanRotation += this.fanSpeed;
            if (this.active.get() && this.fanSpeed < 1.0f) {
                this.fanSpeed = Math.min(this.fanSpeed + 0.03f, 1.0f);
            } else if (!this.active.get() && this.fanSpeed > 0.0f) {
                this.fanSpeed = Math.max(this.fanSpeed - 0.08f, 0.0f);
            }
            this.aoeDisplay = this.showAOE.get() ? (float)MathHelper.approachExp((double)this.aoeDisplay, (double)this.aoe.get(), (double)0.1f) : MathHelper.approachLinear((float)this.aoeDisplay, (float)0.5f, (float)0.15f);
            return;
        }
        if (this.updateActiveState()) {
            if (this.onInterval(20)) {
                this.validateKillZone(false);
                this.handleLootCollection();
            }
            if (this.coolDown > 0) {
                --this.coolDown;
                return;
            }
            this.validateKillZone(false);
            if (this.attackTarget()) {
                this.queNextTarget();
            }
        }
    }

    private boolean updateActiveState() {
        int eph = DEOldConfig.grinderEnergyPerHeart;
        boolean isActive = this.isTileEnabled();
        if (isActive && this.opStorage.getOPStored() < (long)(eph * 50)) {
            isActive = false;
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)Grinder.ACTIVE, (Comparable)Boolean.valueOf(isActive)));
        return this.active.set(isActive);
    }

    public void validateKillZone(boolean forceReCalc) {
        if (forceReCalc || this.killZone == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            Direction facing = (Direction)state.func_177229_b((Property)Grinder.FACING);
            int aoe = this.aoe.get();
            BlockPos pos1 = this.field_174879_c.func_177982_a(-(aoe - 1), -(aoe - 1), -(aoe - 1));
            BlockPos pos2 = this.field_174879_c.func_177982_a(aoe, aoe, aoe);
            pos1 = pos1.func_177982_a(facing.func_82601_c() * aoe, 0, facing.func_82599_e() * aoe);
            pos2 = pos2.func_177982_a(facing.func_82601_c() * aoe, 0, facing.func_82599_e() * aoe);
            this.killZone = new AxisAlignedBB(pos1, pos2);
        }
    }

    private boolean attackTarget() {
        if (this.nextTarget == null || !this.nextTarget.func_70089_S()) {
            return true;
        }
        ItemStack weapon = this.itemHandler.getStackInSlot(1);
        IOPStorage weaponEnergy = null;
        if (weapon.func_190926_b()) {
            weapon = ItemStack.field_190927_a;
        } else {
            weaponEnergy = EnergyUtils.getStorage((ItemStack)weapon);
            if (weaponEnergy instanceof IOPStorageModifiable) {
                if (weaponEnergy.getEnergyStored() < DEConfig.grinderItemSlotEnergy) {
                    weapon = ItemStack.field_190927_a;
                }
            } else if (weaponEnergy != null) {
                if (weaponEnergy.extractEnergy(DEConfig.grinderItemSlotEnergy, true) != DEConfig.grinderItemSlotEnergy) {
                    weapon = ItemStack.field_190927_a;
                }
            } else if (weapon.func_77952_i() >= weapon.func_77958_k() - 1) {
                weapon = ItemStack.field_190927_a;
            }
        }
        this.getFakePlayer().func_184611_a(Hand.MAIN_HAND, weapon);
        int eph = DEOldConfig.grinderEnergyPerHeart;
        float health = this.nextTarget.func_110143_aJ();
        if (health < 5.0f) {
            health = 5.0f;
        }
        int cost = (int)(health * (float)eph);
        boolean willKill = false;
        if ((long)cost > this.opStorage.getOPStored()) {
            cost = this.opStorage.getEnergyStored();
        } else {
            willKill = true;
        }
        float damage = willKill ? Float.MAX_VALUE : (float)cost / (float)eph * 1.1f;
        DamageSource source = DamageSource.func_76365_a((PlayerEntity)this.getFakePlayer());
        if (this.nextTarget.func_70097_a(source, damage)) {
            if (!weapon.func_190926_b()) {
                if (weaponEnergy instanceof IOPStorageModifiable) {
                    ((IOPStorageModifiable)weaponEnergy).modifyEnergyStored((long)(-DEConfig.grinderItemSlotEnergy));
                } else if (weaponEnergy != null) {
                    weaponEnergy.extractEnergy(DEConfig.grinderItemSlotEnergy, false);
                } else {
                    ItemStack justInCase = weapon.func_77946_l();
                    justInCase.func_196085_b(justInCase.func_77958_k() - 1);
                    weapon.func_222118_a(1, (LivingEntity)this.getFakePlayer(), fakePlayer -> this.itemHandler.setStackInSlot(1, justInCase));
                }
            }
            this.nextTarget = null;
            this.opStorage.modifyEnergyStored((long)(-cost));
            return true;
        }
        if (!this.killZone.func_72326_a(this.nextTarget.func_174813_aQ())) {
            this.nextTarget = null;
        }
        return false;
    }

    private void queNextTarget() {
        List entitiesInRange = this.field_145850_b.func_175647_a(LivingEntity.class, this.killZone, (Predicate)this.entityFilter.predicate());
        boolean foundInvulnerable = false;
        while (!entitiesInRange.isEmpty()) {
            LivingEntity randEntity = (LivingEntity)entitiesInRange.remove(this.field_145850_b.field_73012_v.nextInt(entitiesInRange.size()));
            if (!this.isValidEntity(randEntity)) continue;
            if (randEntity.func_190530_aW()) {
                foundInvulnerable = true;
                continue;
            }
            this.nextTarget = randEntity;
            this.sendPacketToChunk(output -> output.writeInt(this.nextTarget.func_145782_y()), 1);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_203274_ip, SoundCategory.BLOCKS, 1.0f, 0.55f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f);
            this.coolDown = this.killRate;
            return;
        }
        this.coolDown = foundInvulnerable ? 5 : 100;
        this.nextTarget = null;
    }

    private boolean isValidEntity(LivingEntity livingBase) {
        if (!livingBase.func_70089_S()) {
            return false;
        }
        if (livingBase instanceof PlayerEntity && !DEOldConfig.allowGrindingPlayers) {
            return false;
        }
        if (DEOldConfig.grinderBlacklist.isEmpty()) {
            return true;
        }
        ResourceLocation reg = livingBase.func_200600_R().getRegistryName();
        return reg == null || !DEOldConfig.grinderBlacklist.contains(reg.toString());
    }

    private void handleLootCollection() {
        List xp = this.field_145850_b.func_217357_a(ExperienceOrbEntity.class, this.killZone.func_72314_b(4.0, 4.0, 4.0));
        for (ExperienceOrbEntity orb : xp) {
            if (!orb.func_70089_S()) continue;
            if (this.collectXP.get() && this.storedXP.get() + orb.field_70530_e <= this.getXPStorageCapacity()) {
                this.storedXP.add(orb.field_70530_e);
                orb.func_70106_y();
                continue;
            }
            if (orb.field_70531_b >= 5400) continue;
            orb.field_70531_b = 5700;
        }
        if (this.collectItems.get()) {
            List items = this.field_145850_b.func_217357_a(ItemEntity.class, this.killZone.func_72314_b(1.0, 1.0, 1.0));
            for (Direction dir : Direction.values()) {
                TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
                if (target == null) continue;
                LazyOptional opCap = target.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
                opCap.ifPresent(iItemHandler -> {
                    Iterator i = items.iterator();
                    while (i.hasNext()) {
                        ItemEntity next = (ItemEntity)i.next();
                        if (!next.func_70089_S()) continue;
                        ItemStack stack = next.func_92059_d();
                        if ((stack = InventoryUtils.insertItem((IItemHandler)iItemHandler, (ItemStack)stack, (boolean)false)).func_190926_b()) {
                            next.func_92058_a(ItemStack.field_190927_a);
                            next.func_70106_y();
                            i.remove();
                            continue;
                        }
                        next.func_92058_a(stack);
                    }
                });
            }
        }
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        super.receivePacketFromClient(data, client, id);
        if (id == 1) {
            int levels = 0;
            switch (data.readByte()) {
                case 0: {
                    client.func_195068_e(this.storedXP.get());
                    this.storedXP.set(0);
                    return;
                }
                case 1: {
                    levels = 1;
                    break;
                }
                case 2: {
                    levels = 5;
                    break;
                }
                case 3: {
                    levels = 10;
                }
            }
            for (int i = 0; i < levels; ++i) {
                int xp = Math.min(client.func_71050_bK(), this.storedXP.get());
                this.storedXP.subtract(xp);
                client.func_195068_e(xp);
            }
        }
        this.coolDown = this.killRate;
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        Entity target;
        super.receivePacketFromServer(data, id);
        if (id == 1 && (target = this.field_145850_b.func_73045_a(data.readInt())) != null) {
            if (this.swordFlipFlop) {
                this.targetA = target;
                this.animA = 0.0f;
            } else {
                this.targetB = target;
                this.animB = 0.0f;
            }
            this.swordFlipFlop = !this.swordFlipFlop;
        }
    }

    public int getMaxAOE() {
        return 4;
    }

    public int getXPStorageCapacity() {
        return 8192;
    }

    public float getAnimSpeed() {
        return 0.425f / (float)this.killRate;
    }

    public FakePlayer getFakePlayer() {
        if (cachedFakePlayer == null) {
            cachedFakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.field_145850_b), (GameProfile)new GameProfile(UUID.fromString("5b5689b9-e43d-4282-a42a-dc916f3616b7"), "Draconic Evolution Grinder"));
        }
        return cachedFakePlayer;
    }

    public void onNeighborChange(BlockPos neighbor) {
        super.onNeighborChange(neighbor);
        if (this.coolDown > this.killRate) {
            this.updateActiveState();
            this.validateKillZone(true);
            this.coolDown = this.killRate;
        }
    }

    @Nullable
    public Container createMenu(int currentWindowIndex, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerBCTile(DEContent.container_grinder, currentWindowIndex, playerInventory, (TileBCore)this, GuiLayoutFactories.GRINDER_LAYOUT);
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
        }
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.showAOE.get()) {
            return INFINITE_EXTENT_AABB;
        }
        return super.getRenderBoundingBox();
    }
}

