/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFlowGate;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.brandon3055.draconicevolution.lib.WTFException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileFluidGate
extends TileFlowGate {
    private FlowHandler inputHandler = new FlowHandler(this, true);
    private FlowHandler outputHandler = new FlowHandler(this, false);

    public TileFluidGate() {
        super(DEContent.tile_fluid_gate);
    }

    @Override
    public String getUnits() {
        return "MB/t";
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side != null && side.func_176740_k() == this.getDirection().func_176740_k()) {
            return side == this.getDirection() ? LazyOptional.of(() -> this.outputHandler) : LazyOptional.of(() -> this.inputHandler);
        }
        return super.getCapability(capability, side);
    }

    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerBCTile(DEContent.container_flow_gate, id, player.field_71071_by, (TileBCore)this, (ContainerSlotLayout.LayoutFactory)SneakyUtils.unsafeCast(GuiLayoutFactories.PLAYER_ONLY_LAYOUT));
    }

    public ITextComponent func_200200_C_() {
        return super.func_200200_C_();
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
        }
        return true;
    }

    private class FlowHandler
    implements IFluidHandler {
        private final TileFluidGate gate;
        private final boolean isInput;

        public FlowHandler(TileFluidGate gate, boolean isInput) {
            this.gate = gate;
            this.isInput = isInput;
        }

        public int getTanks() {
            LazyOptional fluidHandler;
            TileEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, TileFluidGate.this.getDirection().func_176734_d())).isPresent()) {
                return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).getTanks();
            }
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            LazyOptional fluidHandler;
            TileEntity tile;
            if (!this.isInput && (tile = TileFluidGate.this.getSource()) != null && (fluidHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, TileFluidGate.this.getDirection().func_176734_d())).isPresent()) {
                return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).getFluidInTank(tank);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            LazyOptional fluidHandler;
            TileEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, TileFluidGate.this.getDirection().func_176734_d())).isPresent()) {
                return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).getTankCapacity(tank);
            }
            return 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            LazyOptional fluidHandler;
            TileEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, TileFluidGate.this.getDirection().func_176734_d())).isPresent()) {
                return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).isFluidValid(tank, stack);
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            LazyOptional fluidHandler;
            TileEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, TileFluidGate.this.getDirection().func_176734_d())).isPresent()) {
                IFluidHandler handler = (IFluidHandler)fluidHandler.orElseThrow(WTFException::new);
                int transfer = (int)Math.min(TileFluidGate.this.getFlow(), (long)handler.fill(resource, IFluidHandler.FluidAction.SIMULATE));
                if (transfer < resource.getAmount()) {
                    FluidStack newStack = resource.copy();
                    newStack.setAmount(transfer);
                    return handler.fill(newStack, action);
                }
                return handler.fill(resource, action);
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isInput) {
                LazyOptional fluidHandler;
                TileEntity tile;
                if ((long)resource.getAmount() > TileFluidGate.this.getFlow()) {
                    resource.setAmount((int)TileFluidGate.this.getFlow());
                }
                if ((tile = TileFluidGate.this.getSource()) != null && (fluidHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, TileFluidGate.this.getDirection().func_176734_d())).isPresent()) {
                    return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).drain(resource, action);
                }
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            TileEntity tile;
            if (!this.isInput && (tile = TileFluidGate.this.getSource()) != null) {
                LazyOptional fluidHandler;
                if ((long)maxDrain > TileFluidGate.this.getFlow()) {
                    maxDrain = (int)TileFluidGate.this.getFlow();
                }
                if ((fluidHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, TileFluidGate.this.getDirection().func_176734_d())).isPresent()) {
                    return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).drain(maxDrain, action);
                }
            }
            return FluidStack.EMPTY;
        }
    }
}

