/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexturedPointer;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import com.brandon3055.draconicevolution.inventory.ContainerReactor;
import com.brandon3055.draconicevolution.utils.ResourceHelperDE;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiReactor
extends ModularGuiContainer<ContainerReactor> {
    private PlayerEntity player = this.player;
    private final TileReactorCore tile;
    public TileReactorComponent component = null;
    private static double compPanelAnim = 0.0;
    private static boolean compPanelExtended = false;
    private GuiElement<?> compPanel;

    public GuiReactor(ContainerReactor container, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)container, inv, titleIn);
        this.tile = (TileReactorCore)container.tile;
        this.field_146999_f = 248;
        this.field_147000_g = 222;
    }

    public void addElements(GuiElementManager manager) {
        ArrayList exclusions = new ArrayList();
        this.compPanel = new GuiBorderedRect(this.field_147003_i + this.field_146999_f, this.field_147009_r + 125, 0, 91);
        manager.addChild((GuiElement)this.compPanel);
        exclusions.add(this.compPanel);
        manager.setJeiExclusions(() -> exclusions);
        GuiTexture background = (GuiTexture)manager.addChild(new GuiTexture(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g, new ResourceLocation("draconicevolution:textures/gui/reactor.png")){

            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                super.renderElement(minecraft, mouseX, mouseY, partialTicks);
                RenderTileReactorCore.renderGUI(GuiReactor.this.tile, GuiReactor.this.field_147003_i + GuiReactor.this.field_146999_f / 2, GuiReactor.this.field_147009_r + 70);
            }
        }.onReload(e -> {
            GuiTexture cfr_ignored_0 = (GuiTexture)e.setPosAndSize(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        }));
        background.addChild((GuiElement)((GuiBorderedRect)new GuiBorderedRect(this.field_147003_i + 12, this.field_147009_r + 138, 162, 77).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD)).setShadeColours(-16777216, -1));
        int y = this.field_147009_r + 140;
        background.addChild(((GuiLabel)((GuiLabel)new GuiLabel(this.field_147003_i + 10 + 5, y, 162, 8, I18n.func_135052_a((String)"gui.draconicevolution.reactor.core_volume", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(49407).setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.reactor.core_volume.info", (Object[])new Object[0]))).setHoverTextDelay(2));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.field_147003_i + 13 + 5, y += 8, 162, 8, "").setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> MathUtils.round((double)((this.tile.reactableFuel.get() + this.tile.convertedFuel.get()) / 1296.0), (double)100.0) + " m^3").setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        background.addChild(((GuiLabel)((GuiLabel)new GuiLabel(this.field_147003_i + 10 + 5, y += 11, 162, 8, I18n.func_135052_a((String)"gui.draconicevolution.reactor.gen_rate", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(49407).setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.reactor.gen_rate.info", (Object[])new Object[0]))).setHoverTextDelay(2));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.field_147003_i + 13 + 5, y += 8, 162, 8, "").setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> Utils.addCommas((int)((int)this.tile.generationRate.get())) + " OP/t").setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        background.addChild(((GuiLabel)((GuiLabel)new GuiLabel(this.field_147003_i + 10 + 5, y += 11, 162, 8, I18n.func_135052_a((String)"gui.draconicevolution.reactor.field_rate", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(49407).setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.reactor.field_rate.info", (Object[])new Object[0]))).setHoverTextDelay(2));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.field_147003_i + 13 + 5, y += 8, 162, 8, "").setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> {
            double inputRate = (double)this.tile.fieldDrain.get() / (1.0 - this.tile.shieldCharge.get() / this.tile.maxShieldCharge.get());
            return Utils.addCommas((int)((int)Math.min(inputRate, 2.147483647E9))) + " OP/t";
        }).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        background.addChild(((GuiLabel)((GuiLabel)new GuiLabel(this.field_147003_i + 10 + 5, y += 11, 162, 8, I18n.func_135052_a((String)"gui.draconicevolution.reactor.convert_rate", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(49407).setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.reactor.convert_rate.info", (Object[])new Object[0]))).setHoverTextDelay(2));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.field_147003_i + 13 + 5, y += 8, 162, 8, "").setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> Utils.addCommas((int)((int)Math.round(this.tile.fuelUseRate.get() * 1000000.0))) + " nb/t").setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.field_147003_i + 13 + 5, this.field_147009_r + 139, 161, 77, I18n.func_135052_a((String)"gui.draconicevolution.reactor.go_boom_now", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setWrap(true).setShadow(false).setTextColour(0xB0B0B0));
        background.addChild(new GuiElement(){

            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                if (((GuiReactor)GuiReactor.this).tile.reactorState.get() == TileReactorCore.ReactorState.COLD) {
                    int x;
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderMaterial mat = BCSprites.getThemed((String)"slot");
                    this.bindTexture(mat.func_229310_a_());
                    IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                    GuiHelperOld.drawPlayerSlots((AbstractGui)GuiReactor.this, (int)(GuiReactor.this.field_147003_i + 43 - 31), (int)(GuiReactor.this.field_147009_r + 139), (boolean)false);
                    for (x = 0; x < 3; ++x) {
                        this.drawSprite(getter.getBuffer(mat.func_229312_a_(BCSprites::makeType)), GuiReactor.this.field_147003_i + 182 + x * 18, GuiReactor.this.field_147009_r + 148, 18.0f, 18.0f, mat.func_229314_c_());
                    }
                    for (x = 0; x < 3; ++x) {
                        this.drawSprite(getter.getBuffer(mat.func_229312_a_(BCSprites::makeType)), GuiReactor.this.field_147003_i + 182 + x * 18, GuiReactor.this.field_147009_r + 179, 18.0f, 18.0f, mat.func_229314_c_());
                    }
                    getter.func_228461_a_();
                }
            }
        });
        background.addChild((GuiElement)new GuiLabel(this.field_147003_i, this.field_147009_r + 2, this.field_146999_f, 12, I18n.func_135052_a((String)"gui.draconicevolution.reactor.title", (Object[])new Object[0])).setAlignment(GuiAlign.CENTER).setTextColour(65535));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.field_147003_i + 182, this.field_147009_r + 139, 54, 8, I18n.func_135052_a((String)"gui.draconicevolution.reactor.fuel_in", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.COLD)).setAlignment(GuiAlign.CENTER).setTrim(false));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.field_147003_i + 182, this.field_147009_r + 170, 54, 8, I18n.func_135052_a((String)"gui.draconicevolution.reactor.chaos_out", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.COLD)).setAlignment(GuiAlign.CENTER).setTrim(false));
        background.addChild((GuiElement)new GuiLabel(this.field_147003_i + 7, this.field_147009_r + 127, this.field_146999_f, 12, "").setShadowStateSupplier(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE).setDisplaySupplier(() -> {
            String s = ((TileReactorCore.ReactorState)this.tile.reactorState.get()).localize();
            if (this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE && ClientEventHandler.elapsedTicks % 10 > 5) {
                s = TextFormatting.DARK_RED + "**" + s + "**";
            } else if (this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE) {
                s = TextFormatting.DARK_RED + "--" + s + "--";
            }
            return TextFormatting.GOLD + I18n.func_135052_a((String)"gui.draconicevolution.reactor.status", (Object[])new Object[0]) + ": " + s;
        }).setAlignment(GuiAlign.LEFT));
        background.addChild(((GuiTexturedPointer)new GuiTexturedPointer(this.field_147003_i + 11, this.field_147009_r + 5, 14, 112, 0, 222, 5, ResourceHelperDE.getResource("textures/gui/reactor.png")){

            public double getPos() {
                return MathHelper.clip((double)(((GuiReactor)GuiReactor.this).tile.temperature.get() / 10000.0), (double)0.0, (double)1.0);
            }
        }.setHoverText(element -> this.getTempStats())).setHoverTextDelay(5));
        background.addChild(((GuiTexturedPointer)new GuiTexturedPointer(this.field_147003_i + 35, this.field_147009_r + 5, 14, 112, 0, 222, 5, ResourceHelperDE.getResource("textures/gui/reactor.png")){

            public double getPos() {
                return MathHelper.clip((double)(((GuiReactor)GuiReactor.this).tile.shieldCharge.get() / Math.max(((GuiReactor)GuiReactor.this).tile.maxShieldCharge.get(), 1.0)), (double)0.0, (double)1.0);
            }
        }.setHoverText(element -> this.getShieldStats())).setHoverTextDelay(5));
        background.addChild(((GuiTexturedPointer)new GuiTexturedPointer(this.field_147003_i + 199, this.field_147009_r + 5, 14, 112, 0, 222, 5, ResourceHelperDE.getResource("textures/gui/reactor.png")){

            public double getPos() {
                return MathHelper.clip((double)((double)((GuiReactor)GuiReactor.this).tile.saturation.get() / (double)Math.max(((GuiReactor)GuiReactor.this).tile.maxSaturation.get(), 1L)), (double)0.0, (double)1.0);
            }
        }.setHoverText(element -> this.getSaturationStats())).setHoverTextDelay(5));
        background.addChild(((GuiTexturedPointer)new GuiTexturedPointer(this.field_147003_i + 223, this.field_147009_r + 5, 14, 112, 0, 222, 5, ResourceHelperDE.getResource("textures/gui/reactor.png")){

            public double getPos() {
                return MathHelper.clip((double)(((GuiReactor)GuiReactor.this).tile.convertedFuel.get() / Math.max(((GuiReactor)GuiReactor.this).tile.reactableFuel.get() + ((GuiReactor)GuiReactor.this).tile.convertedFuel.get(), 1.0)), (double)0.0, (double)1.0);
            }
        }.setHoverText(element -> this.getFuelStats())).setHoverTextDelay(5));
        background.addChild((GuiElement)((GuiButton)new GuiButton(this.field_147003_i + 177, this.field_147009_r + 199, 64, 14, I18n.func_135052_a((String)"gui.draconicevolution.reactor.charge", (Object[])new Object[0])).setEnabledCallback(this.tile::canCharge)).setBorderColours(-11184811, -8947849).setFillColour(-16777216).setTrim(false).onPressed(this.tile::chargeReactor));
        background.addChild((GuiElement)((GuiButton)new GuiButton(this.field_147003_i + 177, this.field_147009_r + 182, 64, 14, I18n.func_135052_a((String)"gui.draconicevolution.reactor.activate", (Object[])new Object[0])).setEnabledCallback(this.tile::canActivate)).setBorderColours(-11184811, -8947849).setFillColour(-16777216).setTrim(false).onPressed(this.tile::activateReactor));
        background.addChild((GuiElement)((GuiButton)new GuiButton(this.field_147003_i + 177, this.field_147009_r + 199, 64, 14, I18n.func_135052_a((String)"gui.draconicevolution.reactor.shutdown", (Object[])new Object[0])).setEnabledCallback(this.tile::canStop)).setBorderColours(-11184811, -8947849).setFillColour(-16777216).setTrim(false).onPressed(this.tile::shutdownReactor));
        background.addChild(((GuiButton)new GuiButton(this.field_147003_i + 177, this.field_147009_r + 165, 64, 14, I18n.func_135052_a((String)"gui.draconicevolution.reactor.sas", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setBorderColours(-11184811, -8947849).setRectFillColourGetter((hovering, disabled) -> this.tile.failSafeMode.get() ? -12566273 : -16777216).setTrim(false).onPressed(this.tile::toggleFailSafe).setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.reactor.sas.info", (Object[])new Object[0])));
        background.addChild(((GuiButton)((GuiButton)new GuiButton(this.field_147003_i + 177, this.field_147009_r + 138, 64, 24, I18n.func_135052_a((String)"gui.draconicevolution.reactor.rs_mode", (Object[])new Object[0]).replaceAll("\\\\n", "\n")).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.component != null && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setWrap(true).setBorderColours(-11184811, -8947849).setFillColour(-16777216).onPressed(() -> {
            compPanelExtended = !compPanelExtended;
        }).setInsets(5, 0, 5, 0)).setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.reactor.rs_mode.info", (Object[])new Object[0])));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.field_147003_i + 175, this.field_147009_r + 138, 68, 80, "ETE").setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> "Estimated\nTime\nUntil\nDetonation\n\n" + TextFormatting.UNDERLINE + (this.tile.explosionCountdown.get() >= 0 ? this.tile.explosionCountdown.get() / 20 + "s" : "Calculating..")).setWrap(true).setShadow(false).setTextColour(0xFF0000));
        y = 0;
        for (TileReactorComponent.RSMode mode : TileReactorComponent.RSMode.values()) {
            background.addChild((GuiElement)((GuiButton)((GuiButton)new GuiButton(this.field_147003_i + this.field_146999_f + 2, this.field_147009_r + 127 + y, 76, 10, I18n.func_135052_a((String)("gui.draconicevolution.reactor.rs_mode_" + mode.name().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0])).setEnabledCallback(() -> compPanelAnim == 1.0 && this.component != null)).setRectFillColourGetter((hovering, disabled) -> {
                if (this.component != null && this.component.rsMode.get() == mode) {
                    return -5636096;
                }
                if (hovering) {
                    return -10132123;
                }
                return -16777216;
            }).setRectBorderColourGetter((hovering, disabled) -> {
                if (this.component != null && this.component.rsMode.get() == mode) {
                    return -5636096;
                }
                if (hovering) {
                    return -10132123;
                }
                return -16777216;
            }).onPressed(() -> {
                if (this.component != null) {
                    this.component.setRSMode(this.player, mode);
                }
            }).setHoverText(I18n.func_135052_a((String)("gui.draconicevolution.reactor.rs_mode_" + mode.name().toLowerCase(Locale.ENGLISH) + ".info"), (Object[])new Object[0]))).setTrim(false));
            y += 11;
        }
    }

    public List<String> getTempStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)"gui.draconicevolution.reactor.reaction_temp", (Object[])new Object[0]));
        list.add(MathUtils.round((double)this.tile.temperature.get(), (double)10.0) + "C");
        return list;
    }

    public List<String> getShieldStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)"gui.draconicevolution.reactor.field_strength", (Object[])new Object[0]));
        if (this.tile.maxShieldCharge.get() > 0.0) {
            list.add(MathUtils.round((double)(this.tile.shieldCharge.get() / this.tile.maxShieldCharge.get() * 100.0), (double)100.0) + "%");
        }
        list.add(Utils.addCommas((int)((int)this.tile.shieldCharge.get())) + " / " + Utils.addCommas((int)((int)this.tile.maxShieldCharge.get())));
        return list;
    }

    public List<String> getSaturationStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)"gui.draconicevolution.reactor.energy_saturation", (Object[])new Object[0]));
        if (this.tile.maxSaturation.get() > 0L) {
            list.add(MathUtils.round((double)((double)this.tile.saturation.get() / (double)this.tile.maxSaturation.get() * 100.0), (double)100.0) + "%");
        }
        list.add(Utils.addCommas((long)this.tile.saturation.get()) + " / " + Utils.addCommas((long)this.tile.maxSaturation.get()));
        return list;
    }

    public List<String> getFuelStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)"gui.draconicevolution.reactor.fuel_conversion", (Object[])new Object[0]));
        if (this.tile.reactableFuel.get() + this.tile.convertedFuel.get() > 0.0) {
            list.add(MathUtils.round((double)(this.tile.convertedFuel.get() / (this.tile.reactableFuel.get() + this.tile.convertedFuel.get()) * 100.0), (double)100.0) + "%");
        }
        list.add(MathUtils.round((double)this.tile.convertedFuel.get(), (double)100.0) + " / " + MathUtils.round((double)(this.tile.convertedFuel.get() + this.tile.reactableFuel.get()), (double)100.0));
        return list;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.tile.reactorState.get() == TileReactorCore.ReactorState.COLD != ((ContainerReactor)this.container).fuelSlots) {
            ((ContainerReactor)this.container).setSlotState();
        }
        if (compPanelExtended && (compPanelAnim < 1.0 || this.compPanel.xSize() != 80)) {
            if ((compPanelAnim += 0.1) > 1.0) {
                compPanelAnim = 1.0;
            }
            this.compPanel.setXSize((int)(compPanelAnim * 80.0));
        } else if (!compPanelExtended && compPanelAnim > 0.0) {
            if ((compPanelAnim -= 0.1) < 0.0) {
                compPanelAnim = 0.0;
            }
            this.compPanel.setXSize((int)(compPanelAnim * 80.0));
        }
        if (this.compPanel.isEnabled() && compPanelAnim == 0.0) {
            this.compPanel.setEnabled(false);
        } else if (!this.compPanel.isEnabled() && compPanelAnim > 0.0) {
            this.compPanel.setEnabled(true);
        }
    }
}

