/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;

public class ExplosionFX
extends Particle {
    public static CCModel model;
    public static CCModel model_inv;
    public CoreEffect coreEffect;
    private LinkedList<EffectPart> effectParts = new LinkedList();
    private static final Random rand;
    public static ShaderProgram leadingWaveProgram;
    public static ShaderProgram blastWaveProgram;
    public static ShaderProgram coreEffectProgram;
    private final Vec3D pos;
    public final int radius;
    private static final IParticleRenderType FX_HANDLER;

    public ExplosionFX(ClientWorld worldIn, Vec3D pos, int radius) {
        super(worldIn, pos.x, pos.y, pos.z);
        this.pos = pos;
        this.radius = radius;
        this.field_70547_e = 240;
        this.coreEffect = new CoreEffect(0.0);
    }

    public boolean shouldCull() {
        return false;
    }

    public void func_189213_a() {
        if (this.effectParts.size() > 0) {
            Iterator i = this.effectParts.iterator();
            while (i.hasNext()) {
                EffectPart part = (EffectPart)i.next();
                if (part.isDead()) {
                    i.remove();
                    continue;
                }
                part.update();
            }
        }
        this.coreEffect.update();
        if (this.field_70546_d > this.field_70547_e) {
            this.func_187112_i();
        }
        if (this.field_70546_d == 0) {
            this.coreEffect = new CoreEffect(0.0);
            ClientEventHandler.triggerExplosionEffect(this.pos.getPos());
        } else if (this.field_70546_d == 3 || this.field_70546_d == 8 || this.field_70546_d == 13) {
            this.effectParts.addFirst(new LeadingWave(this.field_70546_d));
        } else if (this.field_70546_d > 30 && this.field_70546_d <= 35) {
            this.effectParts.addFirst(new BlastWave(this.field_70546_d - 30));
        }
        if (this.field_70546_d == 10) {
            this.field_187122_b.func_184134_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, DESounds.fusionExplosion, SoundCategory.PLAYERS, 100.0f, 0.9f, false);
        }
        ++this.field_70546_d;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d viewVec = renderInfo.func_216785_c();
        Vec3D pos = new Vec3D(this.field_187126_f - viewVec.field_72450_a, this.field_187127_g - viewVec.field_72448_b, this.field_187128_h - viewVec.field_72449_c);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.baseColour = -1;
        float ttl = 1.0f - ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        ttl = Math.min(1.0f, ttl * 5.0f);
        double od = 1200.0;
        double id = (double)this.radius / 100.0;
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.15f * ttl * Math.min(1.0f, (float)this.field_70547_e / 25.0f)));
        ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
        for (double i = 0.0; i < 16.0; i += 1.0) {
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos.toVector3(), (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(od, id * i, od));
            model.render(ccrs, new IVertexOperation[]{mat});
            od += id * i;
        }
        ccrs.draw();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.coreEffect.isDead()) {
            this.coreEffect.render(pos, ccrs, partialTicks);
        }
        for (EffectPart part : this.effectParts) {
            part.render(pos, ccrs, partialTicks);
        }
    }

    public IParticleRenderType func_217558_b() {
        return FX_HANDLER;
    }

    static {
        rand = new Random();
        leadingWaveProgram = ShaderProgramBuilder.builder().addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/explosion_leading_wave.frag")).uniform("time", UniformType.FLOAT).uniform("scale", UniformType.FLOAT).uniform("alpha", UniformType.FLOAT)).build();
        blastWaveProgram = ShaderProgramBuilder.builder().addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/explosion_blast_wave.frag")).uniform("time", UniformType.FLOAT).uniform("scale", UniformType.FLOAT).uniform("alpha", UniformType.FLOAT)).build();
        coreEffectProgram = ShaderProgramBuilder.builder().addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/explosion_core_effect.frag")).uniform("time", UniformType.FLOAT).uniform("scale", UniformType.FLOAT).uniform("alpha", UniformType.FLOAT)).build();
        Map map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/reactor/reactor_core.obj"));
        model = CCModel.combine(map.values());
        model_inv = model.backfacedCopy();
        FX_HANDLER = new FXHandler();
    }

    private class CoreEffect
    extends EffectPart {
        public CoreEffect(double scale) {
            super(scale);
            this.maxAge = 60;
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vec3D pos, CCRenderState ccrs, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (double)ExplosionFX.this.radius / 6.0 * (double)ttl * 2.0;
            float a = (float)this.age + partialTicks;
            UniformCache uniforms = coreEffectProgram.pushCache();
            uniforms.glUniform1f("time", ((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
            uniforms.glUniform1f("scale", a > 35.0f ? (a - 35.0f) / 20.0f * 2.0f : 0.0f);
            uniforms.glUniform1f("alpha", a > 50.0f ? 1.0f - (a - 50.0f) / 10.0f : 1.0f);
            coreEffectProgram.use();
            coreEffectProgram.popCache(uniforms);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos.toVector3(), (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, scale / 2.0, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            coreEffectProgram.release();
        }
    }

    private class BlastWave
    extends EffectPart {
        public BlastWave(double scale) {
            super(scale);
            this.maxAge = 150 + (int)(scale * 5.0);
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vec3D pos, CCRenderState ccrs, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (float)ExplosionFX.this.radius * ttl * 2.0f;
            double vScale = (double)ExplosionFX.this.radius / 5.0 * (double)ttl * this.scale;
            float a = (float)this.age + partialTicks;
            UniformCache uniforms = blastWaveProgram.pushCache();
            uniforms.glUniform1f("time", ((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
            uniforms.glUniform1f("scale", ttl);
            uniforms.glUniform1f("alpha", a < 40.0f ? (a - 20.0f) / 20.0f : 1.0f - ttl);
            blastWaveProgram.use();
            blastWaveProgram.popCache(uniforms);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos.toVector3(), (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, vScale, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            blastWaveProgram.release();
        }
    }

    private class LeadingWave
    extends EffectPart {
        public LeadingWave(double scale) {
            super(scale);
            this.maxAge = 40 + (int)scale;
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vec3D pos, CCRenderState ccrs, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (float)ExplosionFX.this.radius * ttl * 2.0f;
            UniformCache uniforms = leadingWaveProgram.pushCache();
            uniforms.glUniform1f("time", ((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
            uniforms.glUniform1f("scale", ttl * 3.0f);
            uniforms.glUniform1f("alpha", 1.0f - ttl);
            leadingWaveProgram.use();
            leadingWaveProgram.popCache(uniforms);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos.toVector3(), (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, 1.0, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            leadingWaveProgram.release();
        }
    }

    private static abstract class EffectPart {
        private boolean isDead = false;
        protected int age = 0;
        protected int maxAge = 0;
        public double scale;
        public int randOffset;

        public EffectPart(double scale) {
            this.scale = scale;
            this.randOffset = rand.nextInt(3265324);
        }

        public abstract void update();

        public abstract void render(Vec3D var1, CCRenderState var2, float var3);

        public void setDead() {
            this.isDead = true;
        }

        public boolean isDead() {
            return this.isDead;
        }
    }

    public static class FXHandler
    implements IParticleRenderType {
        public void func_217600_a(BufferBuilder builder, TextureManager p_217600_2_) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.alphaFunc((int)516, (float)0.0f);
            RenderSystem.disableTexture();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            if (!DEConfig.reactorShaders) {
                RenderSystem.texParameter((int)3553, (int)10242, (int)10497);
                RenderSystem.texParameter((int)3553, (int)10243, (int)10497);
            }
        }

        public void func_217599_a(Tessellator tessellator) {
            RenderSystem.alphaFunc((int)516, (float)0.1f);
            RenderSystem.enableTexture();
            RenderSystem.enableCull();
            if (!DEConfig.reactorShaders) {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
        }
    }
}

