/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.machines.Grinder;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGrinder;
import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderTileGrinder
extends TileEntityRenderer<TileGrinder> {
    private static final double[] ROTATION_MAP = new double[]{0.0, 180.0, 90.0, -90.0};
    private static final RenderType swordType = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/grinder.png"));
    private static final RenderType fanType = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/parts/machine_fan.png"));
    private static final RenderType aoeOutlineType = RenderType.func_228632_a_((String)"aoe", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228515_g_).func_228714_a_(RenderState.field_228491_A_).func_228727_a_(RenderState.field_228496_F_).func_228720_a_(new RenderState.LineState(OptionalDouble.of(4.0))).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private static final RenderType aoeSolidType = RenderType.func_228632_a_((String)"aoe_solid", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228515_g_).func_228714_a_(RenderState.field_228491_A_).func_228727_a_(RenderState.field_228496_F_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private final CCModel swordModel;
    private final CCModel fanModel;

    public RenderTileGrinder(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Map map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/grinder/grinder_fan.obj"), (int)7, null);
        this.fanModel = CCModel.combine(map.values());
        map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/grinder/grinder_sword.obj"), (int)7, null);
        this.swordModel = CCModel.combine(map.values());
        this.swordModel.computeNormals();
        this.swordModel.apply((Transformation)new Scale(-0.0625));
        this.swordModel.apply((Transformation)new Rotation(3.1415926535897403, 0.0, 0.0, 1.0));
        this.swordModel.apply((Transformation)new Rotation(1.5707963267948701, 0.0, 1.0, 0.0));
    }

    public void render(TileGrinder tile, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        BlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state.func_177230_c() != DEContent.grinder) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((Property)Grinder.FACING);
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind(swordType, getter);
        ccrs.r = new TransformingVertexBuilder(ccrs.r, (Transformation)mat);
        Vector3 tilePos = Vector3.fromTileCenter((TileEntity)tile);
        Vector3 vecA = tile.targetA == null ? null : this.getEntityMovingVec(tile.targetA, partialTicks);
        Vector3 vecB = tile.targetB == null ? null : this.getEntityMovingVec(tile.targetB, partialTicks);
        this.renderSword(ccrs, facing, 0.34, tilePos, vecA, Math.min(tile.animA + partialTicks * tile.getAnimSpeed(), 1.0f), partialTicks);
        this.renderSword(ccrs, facing, -0.34, tilePos, vecB, Math.min(tile.animB + partialTicks * tile.getAnimSpeed(), 1.0f), partialTicks);
        ccrs.bind(fanType, getter);
        Matrix4 fanMat = mat.copy();
        fanMat.translate(Vector3.CENTER);
        fanMat.apply((Transformation)new Rotation((double)facing.func_185119_l() * -0.017453292519943, 0.0, 1.0, 0.0));
        fanMat.apply((Transformation)new Scale(-0.0625));
        fanMat.apply((Transformation)new Rotation((double)(tile.fanRotation + tile.fanSpeed * partialTicks), 0.0, 0.0, 1.0));
        this.fanModel.render(ccrs, new IVertexOperation[]{fanMat});
        if ((double)tile.aoeDisplay > 0.51) {
            tile.validateKillZone(true);
            TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(aoeOutlineType), (Transformation)mat);
            Cuboid6 box = new Cuboid6(tile.killZone.func_186670_a(Vector3.fromTile((TileEntity)tile).multiply(-1.0).pos()).func_186664_h(0.01).func_186664_h((double)((float)tile.aoe.get() - tile.aoeDisplay)));
            RenderUtils.bufferCuboidOutline((IVertexBuilder)builder, (Cuboid6)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            builder = new TransformingVertexBuilder(getter.getBuffer(aoeSolidType), (Transformation)mat);
            RenderUtils.bufferCuboidSolid((IVertexBuilder)builder, (Cuboid6)box, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.2f);
        }
    }

    private void renderSword(CCRenderState ccrs, Direction tileFacing, double sideOffset, Vector3 tilePos, Vector3 targetPos, double attackAnimTime, float partialTicks) {
        double yoyo = (attackAnimTime *= 2.0) > 1.0 ? 1.0 - (attackAnimTime - 1.0) : attackAnimTime;
        double sideAngle = ROTATION_MAP[tileFacing.func_176745_a() - 2] * 0.017453292519943;
        Transformation rotation = new Rotation(yoyo * Math.PI * -2.8, 1.0, 0.0, 0.0).at(new Vector3(0.0, -0.2, 0.0));
        Vector3 handPos = new Vector3(0.4975 + (sideOffset *= 1.0 - yoyo), 0.5, 0.125 + yoyo * 0.375);
        handPos.apply(new Rotation(sideAngle, 0.0, 1.0, 0.0).at(new Vector3(0.5, 0.0, 0.5)));
        Translation translation = new Translation(handPos);
        TransformationList transforms = rotation.with((Transformation)translation);
        if (targetPos == null) {
            transforms = transforms.with(new Rotation(sideAngle, 0.0, 1.0, 0.0).at(handPos));
        } else {
            Vector3 targetVec = targetPos.copy().subtract(tilePos);
            double angle = Math.atan2(targetVec.x, targetVec.z) + Math.PI;
            transforms = transforms.with(new Rotation(angle, 0.0, 1.0, 0.0).at(handPos));
            transforms = transforms.with((Transformation)new Translation(targetVec.multiply(yoyo)));
        }
        this.swordModel.render(ccrs, new IVertexOperation[]{transforms});
    }

    private Vector3 getEntityMovingVec(Entity entity, float partialTicks) {
        Vector3 vec = new Vector3(entity.field_70142_S, entity.field_70137_T - entity.func_70033_W() + (double)(entity.func_213302_cg() / 2.0f), entity.field_70136_U);
        vec.add(Vector3.fromEntityCenter((Entity)entity).subtract(entity.field_70142_S, entity.field_70137_T - entity.func_70033_W() + (double)(entity.func_213302_cg() / 2.0f), entity.field_70136_U).multiply((double)partialTicks));
        return vec;
    }
}

