/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.world.ChaosWorldGenHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public enum GuardianSpawnState {
    START_WAIT_FOR_PLAYER{

        @Override
        public void process(ServerWorld world, GuardianFightManager manager, List<EnderCrystalEntity> crystals, int ticks, BlockPos pos) {
            if (ticks % 20 == 0) {
                for (ServerPlayerEntity player : manager.getTrackedPlayers()) {
                    if (!(pos.func_177981_b(15).func_177951_i((Vector3i)player.func_233580_cy_()) <= 225.0)) continue;
                    DraconicEvolution.LOGGER.info("Player In Range. Guardian spawn progressing to PREPARING_TO_SUMMON_PILLARS");
                    manager.setRespawnState(PREPARING_TO_SUMMON_PILLARS);
                }
            }
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS{

        @Override
        public void process(ServerWorld world, GuardianFightManager manager, List<EnderCrystalEntity> crystals, int ticks, BlockPos pos) {
            if (ticks < 70) {
                if (ticks == 0 || ticks == 20 || ticks == 21 || ticks == 22 || ticks >= 65) {
                    world.func_217379_c(3001, new BlockPos(pos.func_177958_n(), 128, pos.func_177952_p()), 0);
                }
            } else {
                manager.setRespawnState(SUMMONING_PILLARS);
                DraconicEvolution.LOGGER.info("Guardian spawn progressing to SUMMONING_PILLARS");
            }
        }
    }
    ,
    SUMMONING_PILLARS{

        @Override
        public void process(ServerWorld world, GuardianFightManager manager, List<EnderCrystalEntity> crystals, int ticks, BlockPos pos) {
            boolean spawn;
            int spawnRate = 15;
            boolean bl = spawn = ticks % spawnRate == 0;
            if (spawn) {
                BlockPos nextSpawn = manager.getNextCrystalPos(ticks == 0);
                if (nextSpawn != null) {
                    for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)nextSpawn.func_177982_a(-10, -10, -10), (BlockPos)nextSpawn.func_177982_a(10, 10, 10))) {
                        world.func_217377_a(blockpos, false);
                    }
                    ChaosWorldGenHandler.generateObelisk(world, nextSpawn, world.field_73012_v);
                    world.func_180501_a(nextSpawn, DEContent.infused_obsidian.func_176223_P(), 3);
                    GuardianCrystalEntity crystal = new GuardianCrystalEntity((World)world.func_201672_e(), (double)nextSpawn.func_177958_n() + 0.5, nextSpawn.func_177956_o() + 1, (double)nextSpawn.func_177952_p() + 0.5, manager.getUniqueID());
                    crystal.func_184224_h(true);
                    world.func_217376_c((Entity)crystal);
                    crystal.setBeamTarget(pos.func_177982_a(0, 80, 0));
                    manager.crystalSpawned();
                } else {
                    manager.setRespawnState(SUMMONING_GUARDIAN);
                    DraconicEvolution.LOGGER.info("Guardian spawn progressing to SUMMONING_GUARDIAN");
                }
            }
        }
    }
    ,
    SUMMONING_GUARDIAN{

        @Override
        public void process(ServerWorld world, GuardianFightManager manager, List<EnderCrystalEntity> crystals, int ticks, BlockPos pos) {
            if (ticks >= 50) {
                manager.setRespawnState(END);
                manager.resetCrystals();
            } else if (ticks >= 30) {
                world.func_217379_c(3001, pos.func_177982_a(0, 80, 0), 0);
            } else if (ticks < 5) {
                world.func_217379_c(3001, pos.func_177982_a(0, 80, 0), 0);
            }
        }
    }
    ,
    END{

        @Override
        public void process(ServerWorld world, GuardianFightManager manager, List<EnderCrystalEntity> crystals, int ticks, BlockPos pos) {
        }
    };


    public abstract void process(ServerWorld var1, GuardianFightManager var2, List<EnderCrystalEntity> var3, int var4, BlockPos var5);
}

