/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.entity.guardian.control.StartPhase;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class ArialBombardPhase
extends ChargeUpPhase {
    private int volleys = 0;
    private int volleysFired = 0;
    private PlayerEntity attackTarget = null;
    private int volleyRounds = 0;
    private Vector3 targetVec = null;

    public ArialBombardPhase(DraconicGuardianEntity guardian) {
        super(guardian, 100);
        this.trapPlayers = true;
        this.disableFlight = true;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        Vector3 guardianPos = Vector3.fromEntity((Entity)this.guardian);
        if ((this.attackTarget == null || !this.isValidTarget((LivingEntity)this.attackTarget)) && this.getChargeProgress() > 0.75) {
            Vector3d focus = Vector3d.func_237489_a_((Vector3i)this.guardian.getArenaOrigin());
            List targetOptions = this.guardian.field_70170_p.func_217369_A().stream().filter(e -> e.func_195048_a(focus) <= 40000.0).filter(e -> StartPhase.AGRO_TARGETS.func_221015_a((LivingEntity)this.guardian, (LivingEntity)e)).collect(Collectors.toList());
            if (targetOptions.isEmpty()) {
                return;
            }
            if (targetOptions.size() == 1) {
                this.attackTarget = (PlayerEntity)targetOptions.get(0);
            } else {
                for (int i = 0; i < targetOptions.size() * 2; ++i) {
                    PlayerEntity target = (PlayerEntity)targetOptions.get(this.random.nextInt(targetOptions.size()));
                    BlockRayTraceResult result = this.guardian.field_70170_p.func_217299_a(new RayTraceContext(guardianPos.vec3(), Vector3.fromEntityCenter((Entity)target).vec3(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.guardian));
                    if (result.func_216346_c() != RayTraceResult.Type.MISS) continue;
                    this.attackTarget = target;
                    break;
                }
                if (this.attackTarget == null) {
                    this.attackTarget = (PlayerEntity)targetOptions.get(this.random.nextInt(targetOptions.size()));
                }
            }
            this.volleyRounds = 15 + this.random.nextInt(5);
        } else if (this.attackTarget == null) {
            this.guardian.field_70177_z += 5.0f;
            return;
        }
        Vector3 targetPos = Vector3.fromEntity((Entity)this.attackTarget);
        Vector3 dirVec = targetPos.copy();
        dirVec.subtract(guardianPos);
        dirVec.normalize();
        float dirVecXZDist = MathHelper.func_76133_a((double)(dirVec.x * dirVec.x + dirVec.z * dirVec.z));
        float targetYaw = (float)(MathHelper.func_181159_b((double)dirVec.x, (double)dirVec.z) * 57.2957763671875);
        float targetPitch = (float)(MathHelper.func_181159_b((double)dirVec.y, (double)dirVecXZDist) * 57.2957763671875);
        this.guardian.field_70177_z = -targetYaw - 180.0f;
        this.guardian.field_70125_A = targetPitch + 180.0f;
        Vector3 headPos = guardianPos.copy();
        float rotation = (this.guardian.field_70177_z - 90.0f) / 360.0f * (float)Math.PI * 2.0f;
        headPos.add((double)(MathHelper.func_76134_b((float)rotation) * 7.0f), 0.0, (double)(MathHelper.func_76126_a((float)rotation) * 7.0f));
        if (this.chargedTime < 10) {
            return;
        }
        if (this.targetVec == null) {
            this.targetVec = targetPos.subtract(headPos).normalize();
        }
        double randMult = 0.1;
        Vector3 randVec = this.targetVec.copy().add((this.random.nextDouble() - 0.5) * randMult, (this.random.nextDouble() - 0.5) * randMult, (this.random.nextDouble() - 0.5) * randMult);
        GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.field_70170_p, (LivingEntity)this.guardian, randVec.x, randVec.y, randVec.z, null, 25.0, 15.0);
        projectile.func_70012_b(headPos.x, headPos.y, headPos.z, 0.0f, 0.0f);
        this.guardian.field_70170_p.func_217376_c((Entity)projectile);
        BCoreNetwork.sendSound((World)this.guardian.field_70170_p, (Entity)this.guardian, (SoundEvent)SoundEvents.field_187527_aQ, (SoundCategory)SoundCategory.HOSTILE, (float)32.0f, (float)((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f), (boolean)false);
        if (this.volleyRounds > 0) {
            --this.volleyRounds;
        } else {
            ++this.volleysFired;
            this.attackTarget = null;
            this.chargedTime = 0;
            this.chargeTime = 0;
            this.requiredChargeTime = 20 + (int)((1.0 - (double)this.volleysFired / (double)this.volleys) * 80.0);
            this.sendPacket(e -> e.writeVarInt(this.requiredChargeTime), 0);
            this.targetVec = null;
        }
        if (this.volleysFired >= this.volleys) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
        }
    }

    @Override
    public void resetCharge() {
        super.resetCharge();
        this.chargedTime = 0;
    }

    @Override
    public void initPhase() {
        super.initPhase();
        this.volleys = 5 + this.random.nextInt(5);
        this.volleysFired = 0;
        this.volleyRounds = 0;
        this.targetVec = null;
        this.attackTarget = null;
        this.requiredChargeTime = 100;
    }

    public PhaseType<ArialBombardPhase> getType() {
        return PhaseType.ARIAL_BOMBARD;
    }

    @Override
    public void handlePacket(MCDataInput input, int func) {
        if (func == 0) {
            this.resetCharge();
            this.requiredChargeTime = input.readVarInt();
        }
    }
}

