/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class BombardPlayerPhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    private int tick;
    private int timeSinceStart;
    private float damageTaken;
    private boolean bombarding = false;
    private Vector3d targetLocation;
    private PlayerEntity targetPlayer;
    private int minAttackRange = 20;
    private int maxAttackRange = 90;

    public BombardPlayerPhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    @Override
    public void serverTick() {
        if (this.targetPlayer == null || !this.isValidTarget((LivingEntity)this.targetPlayer)) {
            this.debug("Aborting bombardment as no target is available. or target is dead.");
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
        } else if (this.timeSinceStart > 0 && this.timeSinceStart >= 160) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            this.debug("Ending bombardment, Timed out");
        } else {
            double distance = this.targetPlayer.func_70032_d((Entity)this.guardian);
            this.targetLocation = this.targetPlayer.func_213303_ch();
            if (!this.bombarding) {
                double tRelZ;
                double tRelX = this.targetLocation.field_72450_a - this.guardian.func_226277_ct_();
                double relTargetAngle = MathHelper.func_151237_a((double)MathHelper.func_76138_g((double)(180.0 - MathHelper.func_181159_b((double)tRelX, (double)(tRelZ = this.targetLocation.field_72449_c - this.guardian.func_226281_cx_())) * 57.2957763671875 - (double)this.guardian.field_70177_z)), (double)-50.0, (double)50.0);
                boolean bl = this.bombarding = Math.abs(relTargetAngle) < 1.0;
                if (this.bombarding) {
                    this.debug("Bombs Away!");
                }
            } else {
                ++this.timeSinceStart;
            }
            if (distance < (double)this.minAttackRange) {
                this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
                this.debug("Ending bombardment, To close");
            } else if (this.bombarding && distance <= (double)this.maxAttackRange && this.timeSinceStart % 2 == 0) {
                Vector3d vector3d2 = this.guardian.func_70676_i(1.0f);
                double headX = this.guardian.dragonPartHead.func_226277_ct_() - vector3d2.field_72450_a;
                double headY = this.guardian.dragonPartHead.func_226283_e_(0.5) + 0.5;
                double headZ = this.guardian.dragonPartHead.func_226281_cx_() - vector3d2.field_72449_c;
                Vector3d targetPos = this.targetPlayer.func_213303_ch().func_178787_e(this.targetPlayer.func_213322_ci().func_216372_d(5.0, 5.0, 5.0));
                targetPos = targetPos.func_72441_c(this.guardian.func_70681_au().nextGaussian() * 10.0, this.guardian.func_70681_au().nextGaussian() * 10.0, this.guardian.func_70681_au().nextGaussian() * 10.0);
                double targetRelX = targetPos.field_72450_a - headX;
                double targetRelY = targetPos.field_72448_b - headY;
                double targetRelZ = targetPos.field_72449_c - headZ;
                if (!this.guardian.func_174814_R()) {
                    BCoreNetwork.sendSound((World)this.guardian.field_70170_p, (Entity)this.guardian, (SoundEvent)SoundEvents.field_187527_aQ, (SoundCategory)SoundCategory.HOSTILE, (float)32.0f, (float)((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f), (boolean)false);
                }
                GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.field_70170_p, (LivingEntity)this.guardian, targetRelX, targetRelY, targetRelZ, targetPos, 25.0, 15.0);
                projectile.func_70012_b(headX, headY, headZ, 0.0f, 0.0f);
                this.guardian.field_70170_p.func_217376_c((Entity)projectile);
            }
        }
        if (this.tick > 100) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
            this.debug("Aborting charge, Master timed out");
        } else if (this.bombarding && this.timeSinceStart < 20 && this.timeSinceStart % 5 == 0) {
            this.guardian.func_184185_a(SoundEvents.field_187525_aO, 20.0f, 0.95f + this.guardian.func_70681_au().nextFloat() * 0.2f);
        }
        ++this.tick;
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
        this.timeSinceStart = 0;
        this.bombarding = false;
        this.tick = 0;
        this.damageTaken = 0.0f;
    }

    @Override
    public void targetPlayer(PlayerEntity player) {
        this.targetPlayer = player;
    }

    @Override
    public float getMaxRiseOrFall() {
        return 3.0f;
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseType<BombardPlayerPhase> getType() {
        return PhaseType.BOMBARD_PLAYER;
    }

    @Override
    public double getGuardianSpeed() {
        double speed = 1.0;
        if (this.targetPlayer != null) {
            double distance = this.targetPlayer.func_70032_d((Entity)this.guardian);
            double sweetSpot = (double)this.minAttackRange + (double)(this.maxAttackRange - this.minAttackRange) / 2.0;
            speed = MathHelper.func_151237_a((double)((distance - sweetSpot) / 10.0), (double)0.5, (double)3.0);
        }
        return this.bombarding ? speed : 0.5;
    }

    @Override
    public float getYawFactor() {
        return super.getYawFactor() * (float)(this.bombarding ? 2 : 1);
    }

    @Override
    public boolean highVerticalAgility() {
        return false;
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        float abortThreshold;
        this.damageTaken += damage;
        float f = abortThreshold = shield > damage ? 512.0f : 128.0f;
        if (this.damageTaken > abortThreshold && !this.bombarding && this.tick > 80) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
            this.debug("Aborting bombardment, Damage Taken");
        }
        return super.onAttacked(source, damage, shield, effective);
    }
}

