/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class DislocatorSaveData
extends WorldSavedData {
    private static final String SAVE_DATA_NAME = "draconic_dislocator_data";
    private Map<UUID, Map<UUID, DislocatorTarget>> linkTargetMap = new HashMap<UUID, Map<UUID, DislocatorTarget>>();

    public DislocatorSaveData(String name) {
        super(name);
    }

    @Nullable
    public static DislocatorTarget getLinkTarget(World world, ItemStack stack) {
        UUID linkID;
        DislocatorSaveData saveData;
        if (BoundDislocator.isValid(stack) && (saveData = DislocatorSaveData.getInstance(world)) != null && saveData.linkTargetMap.containsKey(linkID = BoundDislocator.getLinkId(stack))) {
            Map<UUID, DislocatorTarget> targetMap = saveData.linkTargetMap.get(linkID);
            UUID targetID = BoundDislocator.getDislocatorId(stack);
            for (Map.Entry<UUID, DislocatorTarget> entry : targetMap.entrySet()) {
                UUID entryID = entry.getKey();
                if (entryID.equals(targetID)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public static void updateLinkTarget(World world, ItemStack stack, DislocatorTarget target) {
        DislocatorSaveData saveData;
        if (BoundDislocator.isValid(stack) && (saveData = DislocatorSaveData.getInstance(world)) != null) {
            UUID linkID = BoundDislocator.getLinkId(stack);
            UUID targetID = BoundDislocator.getDislocatorId(stack);
            saveData.linkTargetMap.computeIfAbsent(linkID, uuid -> new HashMap()).put(targetID, target);
            saveData.func_76185_a();
        }
    }

    @Nullable
    public static DislocatorSaveData getInstance(World world) {
        ServerWorld level;
        if (world instanceof ServerWorld && world.func_73046_m() != null && (level = world.func_73046_m().func_71218_a(World.field_234918_g_)) != null) {
            return (DislocatorSaveData)level.func_217481_x().func_215752_a(() -> new DislocatorSaveData(SAVE_DATA_NAME), SAVE_DATA_NAME);
        }
        return null;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.linkTargetMap.clear();
        ListNBT linkList = nbt.func_150295_c("link_map", 10);
        for (INBT lnbt : linkList) {
            CompoundNBT linkNBT = (CompoundNBT)lnbt;
            UUID linkID = linkNBT.func_186857_a("link_id");
            ListNBT targetList = linkNBT.func_150295_c("targets", 10);
            Map targetMap = this.linkTargetMap.computeIfAbsent(linkID, uuid -> new HashMap());
            for (INBT tnbt : targetList) {
                CompoundNBT targetNBT = (CompoundNBT)tnbt;
                UUID targetID = targetNBT.func_186857_a("target_id");
                DislocatorTarget target = DislocatorTarget.load(targetNBT);
                targetMap.put(targetID, target);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT linkList = new ListNBT();
        for (UUID linkID : this.linkTargetMap.keySet()) {
            Map<UUID, DislocatorTarget> targetMap = this.linkTargetMap.get(linkID);
            CompoundNBT linkNBT = new CompoundNBT();
            linkNBT.func_186854_a("link_id", linkID);
            ListNBT targetList = new ListNBT();
            for (UUID targetID : targetMap.keySet()) {
                DislocatorTarget target = targetMap.get(targetID);
                CompoundNBT targetNBT = new CompoundNBT();
                targetNBT.func_186854_a("target_id", targetID);
                target.save(targetNBT);
                targetList.add((Object)targetNBT);
            }
            linkNBT.func_218657_a("targets", (INBT)targetList);
            linkList.add((Object)linkNBT);
        }
        nbt.func_218657_a("link_map", (INBT)linkList);
        return nbt;
    }
}

