/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.dislocator.EntityTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.GroundTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.TileTarget;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class DislocatorTarget {
    protected RegistryKey<World> worldKey;

    public DislocatorTarget(RegistryKey<World> worldKey) {
        this.worldKey = worldKey;
    }

    @Nullable
    public abstract TargetPos getTargetPos(MinecraftServer var1, UUID var2, UUID var3);

    public void preTeleport(MinecraftServer server, Entity entity) {
    }

    protected ServerWorld getTargetWorld(MinecraftServer server) {
        return server.func_71218_a(this.worldKey);
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt.func_74774_a("target_type", (byte)this.getType().ordinal());
        nbt.func_74778_a("world_key", this.worldKey.func_240901_a_().toString());
        return nbt;
    }

    protected void loadInternal(CompoundNBT nbt) {
    }

    public RegistryKey<World> getWorldKey() {
        return this.worldKey;
    }

    public static DislocatorTarget load(CompoundNBT nbt) {
        try {
            TargetType type = TargetType.values()[nbt.func_74771_c("target_type")];
            RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("world_key")));
            DislocatorTarget target = type.createInstance((RegistryKey<World>)worldKey);
            target.loadInternal(nbt);
            return target;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract TargetType getType();

    static enum TargetType {
        TILE(TileTarget::new),
        PLAYER(PlayerTarget::new),
        ENTITY_INVENTORY(EntityTarget::new),
        ON_GROUND(GroundTarget::new);

        private Function<RegistryKey<World>, DislocatorTarget> factory;

        private TargetType(Function<RegistryKey<World>, DislocatorTarget> factory) {
            this.factory = factory;
        }

        public DislocatorTarget createInstance(RegistryKey<World> worldKey) {
            return this.factory.apply(worldKey);
        }
    }
}

