/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PlayerTarget
extends DislocatorTarget {
    private UUID playerID;

    public PlayerTarget(PlayerEntity player) {
        super((RegistryKey<World>)player.field_70170_p.func_234923_W_());
        this.playerID = player.func_110124_au();
    }

    public PlayerTarget(RegistryKey<World> world) {
        super(world);
    }

    @Override
    public TargetPos getTargetPos(MinecraftServer server, UUID linkID, UUID sourceDislocatorID) {
        ServerPlayerEntity player = server.func_184103_al().func_177451_a(this.playerID);
        if (player != null) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!BoundDislocator.isValid(stack) || sourceDislocatorID.equals(BoundDislocator.getDislocatorId(stack))) continue;
                return new TargetPos((Entity)player);
            }
        }
        return null;
    }

    @Override
    protected ServerWorld getTargetWorld(MinecraftServer server) {
        ServerPlayerEntity player = server.func_184103_al().func_177451_a(this.playerID);
        if (player != null) {
            return (ServerWorld)player.field_70170_p;
        }
        return super.getTargetWorld(server);
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt.func_186854_a("player_id", this.playerID);
        return super.save(nbt);
    }

    @Override
    protected void loadInternal(CompoundNBT nbt) {
        super.loadInternal(nbt);
        this.playerID = nbt.func_186857_a("player_id");
    }

    @Override
    public DislocatorTarget.TargetType getType() {
        return DislocatorTarget.TargetType.PLAYER;
    }
}

