/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration;

import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.integration.jei.DEJEIPlugin;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class ModHelper {
    private static Map<String, String> loadedMods = null;
    public static boolean isTConInstalled;
    public static boolean isAvaritiaInstalled;
    public static boolean isRotaryCraftInstalled;
    public static boolean isJEIInstalled;
    public static boolean isBaublesInstalled;
    private static Item cleaver;
    private static Item avaritiaSword;
    private static Item bedrockSword;

    public static void init() {
        isTConInstalled = ModList.get().isLoaded("tconstruct");
        isAvaritiaInstalled = ModList.get().isLoaded("avaritia");
        isRotaryCraftInstalled = ModList.get().isLoaded("rotarycraft");
        isJEIInstalled = ModList.get().isLoaded("jei");
        isBaublesInstalled = ModList.get().isLoaded("baubles");
    }

    public static boolean isHoldingCleaver(PlayerEntity player) {
        if (!isTConInstalled) {
            return false;
        }
        if (cleaver == null) {
            cleaver = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tconstruct", "cleaver"));
        }
        return cleaver != null && HandHelper.getItem((PlayerEntity)player, (Item)cleaver) != null;
    }

    public static boolean isHoldingAvaritiaSword(PlayerEntity player) {
        if (!isAvaritiaInstalled) {
            return false;
        }
        if (avaritiaSword == null) {
            avaritiaSword = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("avaritia", "infinity_sword"));
        }
        return avaritiaSword != null && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b().equals(avaritiaSword);
    }

    public static boolean isHoldingBedrockSword(PlayerEntity player) {
        if (!isRotaryCraftInstalled) {
            return false;
        }
        if (bedrockSword == null) {
            bedrockSword = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rotarycraft", "rotarycraft_item_bedsword"));
        }
        return bedrockSword != null && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b().equals(bedrockSword);
    }

    public static boolean canRemoveEnchants(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        ResourceLocation registry = stack.func_77973_b().getRegistryName();
        return registry != null && !registry.func_110624_b().equals("tconstruct");
    }

    public static float applyModDamageAdjustments(LivingAttackEvent event, ModuleHost host) {
        PlayerEntity attacker;
        PlayerEntity playerEntity = attacker = event.getSource().func_76346_g() instanceof PlayerEntity ? (PlayerEntity)event.getSource().func_76346_g() : null;
        if (attacker == null) {
            return event.getAmount();
        }
        if (ModHelper.isHoldingAvaritiaSword(attacker)) {
            event.getEntityLiving().field_70172_ad = 0;
            return 300.0f;
        }
        if (event.getSource().func_76363_c() || event.getSource().func_76357_e()) {
            return event.getAmount() * 2.0f;
        }
        return event.getAmount();
    }

    public static void reloadJEI() {
        if (isJEIInstalled) {
            DEJEIPlugin.reloadJEI();
        }
    }

    public static boolean isWrench(ItemStack stack) {
        String name = String.valueOf(stack.func_77973_b().getRegistryName()).toLowerCase(Locale.ENGLISH);
        return name.contains("wrench") || name.contains("binder") || name.contains("hammer");
    }

    public static Map<String, String> getLoadedMods() {
        if (loadedMods == null) {
            loadedMods = Collections.synchronizedMap(new HashMap());
            for (ModInfo mod : ModList.get().getMods()) {
                loadedMods.put(mod.getModId(), mod.getDisplayName());
            }
        }
        return loadedMods;
    }
}

