/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.inventory.ContainerBCore;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.google.common.collect.Streams;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;

public class ContainerConfigurableItem
extends ContainerBCore<Object> {
    private static final UUID DEFAULT_UUID = UUID.fromString("d12b41e3-16ce-4653-ab36-1cd913719af8");
    private UUID selectedId;
    private Runnable onInventoryChange;
    private Consumer<Boolean> onSelectionMade;
    private ItemStack stackCache = ItemStack.field_190927_a;
    private boolean initialSync = false;
    private UUID lastSelected = null;

    public ContainerConfigurableItem(int windowId, PlayerInventory player, PacketBuffer extraData, ContainerSlotLayout.LayoutFactory<Object> factory) {
        super(DEContent.container_configurable_item, windowId, player, extraData, factory);
        PlayerSlot slot = PlayerSlot.fromBuff((ByteBuf)extraData);
        UUID found = this.getProviderID(slot.getStackInSlot(player.field_70458_d));
        if (found != null) {
            this.stackCache = slot.getStackInSlot(player.field_70458_d);
        }
        this.selectedId = found == null ? DEFAULT_UUID : found;
    }

    public ContainerConfigurableItem(int windowId, PlayerInventory player, PlayerSlot itemSlot, ContainerSlotLayout.LayoutFactory<Object> factory) {
        super(DEContent.container_configurable_item, windowId, player, factory);
        this.sanitizeProviders();
        UUID found = this.getProviderID(itemSlot.getStackInSlot(player.field_70458_d));
        if (found != null) {
            this.stackCache = itemSlot.getStackInSlot(player.field_70458_d);
        }
        this.selectedId = found == null ? DEFAULT_UUID : found;
    }

    private Stream<ItemStack> getInventoryStacks() {
        return this.field_75151_b.stream().map(Slot::func_75211_c).filter(stack -> !stack.func_190926_b());
    }

    public void setOnInventoryChange(Runnable onInventoryChange) {
        this.onInventoryChange = onInventoryChange;
    }

    public void setSelectionListener(Consumer<Boolean> onSelectionMade) {
        this.onSelectionMade = onSelectionMade;
    }

    public static Stream<PropertyProvider> getProviders(Stream<ItemStack> stacks) {
        return stacks.map(e -> e.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY)).filter(LazyOptional::isPresent).map(e -> (PropertyProvider)e.orElseThrow(WTFException::new));
    }

    public PropertyProvider findProvider(UUID providerID) {
        return ContainerConfigurableItem.getProviders(this.getInventoryStacks()).filter(provider -> provider.getProviderID().equals(providerID)).findFirst().orElse(null);
    }

    private void sanitizeProviders() {
        HashSet uuids = new HashSet();
        ContainerConfigurableItem.getProviders(this.getInventoryStacks()).filter(provider -> !uuids.add(provider.getProviderID())).forEach(PropertyProvider::regenProviderID);
    }

    public ItemStack func_184996_a(int slotId, int button, ClickType clickTypeIn, PlayerEntity player) {
        LazyOptional optionalCap;
        Slot slot;
        if (slotId >= 0 && slotId < this.field_75151_b.size() && (slot = (Slot)this.field_75151_b.get(slotId)) != null && !slot.func_75211_c().func_190926_b() && (optionalCap = slot.func_75211_c().getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY)).isPresent()) {
            PropertyProvider provider = (PropertyProvider)optionalCap.orElseThrow(WTFException::new);
            if (clickTypeIn == ClickType.PICKUP && button == 0 && player.field_71071_by.func_70445_o().func_190926_b()) {
                this.selectedId = provider.getProviderID();
                if (this.onSelectionMade != null) {
                    this.onSelectionMade.accept(false);
                }
                this.stackCache = slot.func_75211_c();
                return ItemStack.field_190927_a;
            }
        }
        if (slotId > 40) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = super.func_184996_a(slotId, button, clickTypeIn, player);
        if (this.onInventoryChange != null) {
            this.onInventoryChange.run();
        }
        return ret;
    }

    public UUID getSelectedId() {
        return this.selectedId;
    }

    private UUID getProviderID(ItemStack stack) {
        LazyOptional optionalCap = stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY);
        if (!stack.func_190926_b() && optionalCap.isPresent()) {
            return ((PropertyProvider)optionalCap.orElseThrow(WTFException::new)).getProviderID();
        }
        return null;
    }

    private static Stream<ItemStack> getPlayerInventory(PlayerInventory player) {
        return Streams.concat((Stream[])new Stream[]{player.field_70462_a.stream(), player.field_70460_b.stream(), player.field_184439_c.stream(), EquipmentManager.getAllItems((LivingEntity)player.field_70458_d).stream()}).filter(e -> !e.func_190926_b());
    }

    public static Stream<Pair<ItemStack, PropertyProvider>> getStackProviders(Stream<ItemStack> stacks) {
        return stacks.map(e -> Pair.of((Object)e, (Object)e.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY))).filter(e -> ((LazyOptional)e.value()).isPresent()).map(e -> Pair.of((Object)e.key(), (Object)((LazyOptional)e.value()).orElseThrow(WTFException::new)));
    }

    public static void handlePropertyData(PlayerEntity player, PropertyData data) {
        if (data.isGlobal) {
            ContainerConfigurableItem.getStackProviders(ContainerConfigurableItem.getPlayerInventory(player.field_71071_by)).filter(e -> ((PropertyProvider)e.value()).getProviderName().equals(data.providerName)).map(e -> Pair.of((Object)e.key(), (Object)((PropertyProvider)e.value()).getProperty(data.getPropertyName()))).filter(e -> Objects.nonNull(e.value())).filter(e -> ((ConfigProperty)e.value()).getType() == data.type).forEach(e -> ((ConfigProperty)e.value()).loadData(data, (ItemStack)e.key()));
        } else {
            ContainerConfigurableItem.getStackProviders(ContainerConfigurableItem.getPlayerInventory(player.field_71071_by)).filter(e -> ((PropertyProvider)e.value()).getProviderID().equals(data.providerID)).map(e -> Pair.of((Object)e.key(), (Object)((PropertyProvider)e.value()).getProperty(data.getPropertyName()))).filter(e -> Objects.nonNull(e.value())).filter(e -> ((ConfigProperty)e.value()).getType() == data.type).findAny().ifPresent(e -> ((ConfigProperty)e.value()).loadData(data, (ItemStack)e.key()));
        }
    }

    public void func_190896_a(List<ItemStack> stacks) {
        super.func_190896_a(stacks);
        this.onSyncDataReceived();
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
        this.onSyncDataReceived();
    }

    private void onSyncDataReceived() {
        if (!this.initialSync) {
            this.initialSync = true;
            if (this.onSelectionMade != null) {
                this.onSelectionMade.accept(true);
            }
        }
        if (this.onInventoryChange != null && this.selectedId != this.lastSelected || this.findProvider(this.selectedId) == null) {
            this.lastSelected = this.selectedId;
            this.onInventoryChange.run();
        }
    }

    public ItemStack getLastStack() {
        return this.stackCache;
    }

    public static void tryOpenGui(ServerPlayerEntity sender) {
        ItemStack stack = sender.func_184614_ca();
        if (!stack.func_190926_b() && stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).isPresent()) {
            PlayerSlot slot = new PlayerSlot((PlayerEntity)sender, Hand.MAIN_HAND);
            NetworkHooks.openGui((ServerPlayerEntity)sender, (INamedContainerProvider)new Provider(slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        PlayerSlot slot = PlayerSlot.findStackActiveFirst((PlayerInventory)sender.field_71071_by, e -> e.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).isPresent());
        if (slot != null) {
            NetworkHooks.openGui((ServerPlayerEntity)sender, (INamedContainerProvider)new Provider(slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        sender.func_145747_a((ITextComponent)new TranslationTextComponent("gui.draconicevolution.item_config.no_configurable_items").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
    }

    public static class Provider
    implements INamedContainerProvider {
        private PlayerSlot slot;

        public Provider(PlayerSlot slot) {
            this.slot = slot;
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("gui.draconicevolution.item_config.name");
        }

        @Nullable
        public Container createMenu(int menuID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return new ContainerConfigurableItem(menuID, playerInventory, this.slot, GuiLayoutFactories.CONFIGURABLE_ITEM_LAYOUT);
        }
    }
}

