/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerModuleHost;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.google.common.collect.Streams;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.NetworkHooks;

public class ContainerModularItem
extends ContainerModuleHost<TileBCore> {
    private PlayerSlot slot;
    public ItemStack hostStack;
    private ModuleGrid moduleGrid;
    private ModuleHost moduleHost;

    public ContainerModularItem(int windowId, PlayerInventory player, PacketBuffer extraData, ContainerSlotLayout.LayoutFactory<TileBCore> factory) {
        super(DEContent.container_modular_item, windowId, player, extraData, factory);
        this.slot = PlayerSlot.fromBuff((ByteBuf)extraData);
        this.onContainerOpen();
        this.moduleGrid = new ModuleGrid(this, player);
    }

    public ContainerModularItem(int windowId, PlayerInventory player, PlayerSlot itemSlot, ContainerSlotLayout.LayoutFactory<TileBCore> factory) {
        super(DEContent.container_modular_item, windowId, player, factory);
        this.slot = itemSlot;
        this.onContainerOpen();
        this.moduleGrid = new ModuleGrid(this, player);
    }

    private static Stream<ItemStack> getPlayerInventory(PlayerInventory player) {
        return Streams.concat((Stream[])new Stream[]{player.field_70462_a.stream(), player.field_70460_b.stream(), player.field_184439_c.stream()}).filter(e -> !e.func_190926_b());
    }

    public static void tryOpenGui(ServerPlayerEntity sender) {
        ItemStack stack = sender.func_184614_ca();
        if (!stack.func_190926_b() && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            PlayerSlot slot = new PlayerSlot((PlayerEntity)sender, Hand.MAIN_HAND);
            NetworkHooks.openGui((ServerPlayerEntity)sender, (INamedContainerProvider)new Provider(stack, slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        PlayerSlot slot = PlayerSlot.findStackActiveFirst((PlayerInventory)sender.field_71071_by, e -> e.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent());
        if (slot != null) {
            NetworkHooks.openGui((ServerPlayerEntity)sender, (INamedContainerProvider)new Provider(slot.getStackInSlot((PlayerEntity)sender), slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        sender.func_145747_a((ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.error.no_modular_items").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
    }

    @Override
    public ModuleHost getModuleHost() {
        LazyOptional optional;
        if ((this.moduleHost == null || EffectiveSide.get().isClient()) && (optional = this.hostStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY)).isPresent()) {
            this.moduleHost = (ModuleHost)optional.orElseThrow(RuntimeException::new);
        }
        return this.moduleHost;
    }

    @Override
    public ModuleContext getModuleContext() {
        return new StackModuleContext(this.hostStack, (LivingEntity)this.player, this.slot.getEquipmentSlot());
    }

    @Override
    public void onGridChange() {
        if (EffectiveSide.get().isServer()) {
            for (int i = 0; i < this.field_75151_b.size(); ++i) {
                ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
                ItemStack itemstack1 = (ItemStack)this.field_75153_a.get(i);
                if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
                itemstack1 = itemstack.func_77946_l();
                this.field_75153_a.set(i, (Object)itemstack1);
                for (IContainerListener icontainerlistener : this.field_75149_d) {
                    icontainerlistener.func_71111_a((Container)this, i, itemstack1);
                }
            }
        }
    }

    private void onContainerOpen() {
        this.hostStack = this.slot.getStackInSlot(this.player);
        this.getModuleHost();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        if (this.moduleHost == null || this.hostStack != this.slot.getStackInSlot(this.player)) {
            return false;
        }
        return this.moduleHost == this.hostStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElse(null);
    }

    @Override
    public ModuleGrid getGrid() {
        return this.moduleGrid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        ItemStack stack = this.slot.getStackInSlot(this.player);
        if (stack != this.hostStack && !stack.func_190926_b() && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            this.hostStack = stack;
        }
    }

    public void func_190896_a(List<ItemStack> stacks) {
        super.func_190896_a(stacks);
        ItemStack stack = this.slot.getStackInSlot(this.player);
        if (stack != this.hostStack && !stack.func_190926_b() && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            this.hostStack = stack;
        }
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
        stack = this.slot.getStackInSlot(this.player);
        if (stack != this.hostStack && !stack.func_190926_b() && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            this.hostStack = stack;
        }
    }

    public ItemStack func_184996_a(int slotId, int button, ClickType clickTypeIn, PlayerEntity player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.field_75151_b.size() && (slot = (Slot)this.field_75151_b.get(slotId)) != null && !slot.func_75211_c().func_190926_b()) {
            if (slot.func_75211_c() == this.hostStack) {
                return ItemStack.field_190927_a;
            }
            if (clickTypeIn == ClickType.PICKUP && button == 0 && player.field_71071_by.func_70445_o().func_190926_b() && slot.func_75211_c().getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
                if (player instanceof ServerPlayerEntity) {
                    PlayerSlot playerSlot = slotId >= 41 ? new PlayerSlot(slotId - 41, PlayerSlot.EnumInvCategory.EQUIPMENT) : (slotId >= 40 ? new PlayerSlot(slotId - 40, PlayerSlot.EnumInvCategory.OFF_HAND) : (slotId >= 36 ? new PlayerSlot(slotId - 36, PlayerSlot.EnumInvCategory.ARMOR) : new PlayerSlot(slotId, PlayerSlot.EnumInvCategory.MAIN)));
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new Provider(slot.func_75211_c(), playerSlot), arg_0 -> ((PlayerSlot)playerSlot).toBuff(arg_0));
                } else {
                    GuiButton.playGenericClick();
                }
                return ItemStack.field_190927_a;
            }
        }
        if (slotId > 40) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, button, clickTypeIn, player);
    }

    public static class Provider
    implements INamedContainerProvider {
        private ItemStack stack;
        private PlayerSlot slot;

        public Provider(ItemStack stack, PlayerSlot slot) {
            this.stack = stack;
            this.slot = slot;
        }

        public ITextComponent func_145748_c_() {
            return this.stack.func_200301_q().func_230531_f_().func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("gui.draconicevolution.modular_item.modules"));
        }

        @Nullable
        public Container createMenu(int menuID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return new ContainerModularItem(menuID, playerInventory, this.slot, GuiLayoutFactories.MODULAR_ITEM_LAYOUT);
        }
    }
}

