/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.TechPropBuilder;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.damage.IDraconicDamage;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.items.equipment.DEItemTier;
import com.brandon3055.draconicevolution.items.equipment.IModularMiningTool;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModularAxe
extends AxeItem
implements IReaperItem,
IModularMiningTool,
IDraconicDamage {
    public static final Set<Material> EFFECTIVE_MATS = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_215713_z, (Object)Material.field_151584_j);
    private final TechLevel techLevel;
    private final DEItemTier itemTier;

    public ModularAxe(TechPropBuilder props) {
        super((IItemTier)new DEItemTier(props, EquipCfg::getAxeDmgMult, EquipCfg::getAxeSpeedMult), 0.0f, 0.0f, props.axeProps());
        this.techLevel = props.techLevel;
        this.itemTier = (DEItemTier)this.func_200891_e();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public DEItemTier getItemTier() {
        return this.itemTier;
    }

    @Override
    public TechLevel getTechLevel(@Nullable ItemStack stack) {
        return this.techLevel;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "axe", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.MELEE_WEAPON);
        return host;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        return new ModularOPStorage(host, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return IModularMiningTool.super.getDestroySpeed(stack, state);
    }

    @Override
    public float getBaseEfficiency() {
        return this.func_200891_e().func_200928_b();
    }

    @Override
    public Set<Block> effectiveBlockAdditions() {
        return Collections.emptySet();
    }

    @Override
    public boolean overrideEffectivity(Material material) {
        return EFFECTIVE_MATS.contains(material);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return 0;
    }
}

