/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.world.ChaosWorldGenHandler;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="draconicevolution", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DEWorldGen {
    public static final RuleTest BASE_STONE_END = new BlockMatchRuleTest(Blocks.field_150377_bs);
    public static ConfiguredFeature<?, ?> ORE_DRACONIUM_END;
    public static ConfiguredFeature<?, ?> ORE_DRACONIUM_OVERWORLD;
    public static ConfiguredFeature<?, ?> ORE_DRACONIUM_NETHER;
    public static ConfiguredFeature<?, ?> CHAOS_ISLAND;

    public static void init() {
        ORE_DRACONIUM_END = DEWorldGen.register("ore_draconium_end", (ConfiguredFeature)((ConfiguredFeature)new ConfiguredFeature(Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(BASE_STONE_END, DEContent.ore_draconium_end.func_176223_P(), DEConfig.veinSizeEnd)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 80))).func_242728_a()).func_242731_b(DEConfig.veinsPerChunkEnd));
        ORE_DRACONIUM_NETHER = DEWorldGen.register("ore_draconium_nether", (ConfiguredFeature)new ConfiguredFeature(Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241884_c, DEContent.ore_draconium_nether.func_176223_P(), DEConfig.veinSizeNether)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(4, 4, DEConfig.maxOreHeightNether))).func_242729_a(10));
        ORE_DRACONIUM_OVERWORLD = DEWorldGen.register("ore_draconium_overworld", (ConfiguredFeature)new ConfiguredFeature(Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, DEContent.ore_draconium_overworld.func_176223_P(), DEConfig.veinSizeOverworld)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(4, 4, DEConfig.maxOreHeightOverworld))).func_242729_a(10));
        CHAOS_ISLAND = DEWorldGen.register("chaos_island", new ConfiguredFeature((Feature)new Feature<NoFeatureConfig>(NoFeatureConfig.field_236558_a_){

            public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
                return ChaosWorldGenHandler.generateChunk(this, reader, generator, rand, pos);
            }
        }, (IFeatureConfig)NoFeatureConfig.field_202429_e));
    }

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(String key, ConfiguredFeature<FC, ?> configuredFeature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("draconicevolution", key), configuredFeature);
    }

    @SubscribeEvent
    public static void biomeLoading(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.THEEND) {
            if (DEConfig.enableOreEnd) {
                builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ORE_DRACONIUM_END);
            }
            builder.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, CHAOS_ISLAND);
        } else if (category == Biome.Category.NETHER) {
            if (DEConfig.enableOreNether) {
                builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ORE_DRACONIUM_NETHER);
            }
        } else if (DEConfig.enableOreOverworld) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ORE_DRACONIUM_OVERWORLD);
        }
    }
}

