/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.api.Ageable;
import com.ferreusveritas.dynamictrees.api.RootyBlockDecayer;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.NullTreePart;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.init.DTClient;
import com.ferreusveritas.dynamictrees.systems.nodemappers.TwinkleNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class TreeHelper {
    public static final TreePart NULL_TREE_PART = new NullTreePart();

    public static void growPulse(World world, BlockPos rootPos) {
        BlockState rootyState = world.func_180495_p(rootPos);
        RootyBlock dirt = TreeHelper.getRooty(rootyState);
        if (dirt != null) {
            dirt.updateTree(rootyState, world, rootPos, world.field_73012_v, false);
            TreeHelper.ageVolume((IWorld)world, rootPos, 8, 32, 1, SafeChunkBounds.ANY);
        }
    }

    public static void ageVolume(IWorld world, SimpleVoxmap leafMap, int iterations, SafeChunkBounds safeBounds) {
        SimpleVoxmap iterMap = leafMap != null ? new SimpleVoxmap(leafMap) : null;
        Iterable<BlockPos.Mutable> iterable = iterMap.getAllNonZero();
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos.Mutable iPos : iterable) {
                BlockState blockState = world.func_180495_p((BlockPos)iPos);
                Block block = blockState.func_177230_c();
                if (block instanceof DynamicLeavesBlock) {
                    byte prevHydro = leafMap.getVoxel((BlockPos)iPos);
                    int newHydro = ((Ageable)block).age(world, (BlockPos)iPos, blockState, world.func_201674_k(), safeBounds);
                    if (newHydro == -1) {
                        leafMap.setVoxel((BlockPos)iPos, (byte)0);
                        iterMap.setVoxel((BlockPos)iPos, (byte)0);
                        continue;
                    }
                    if (prevHydro == newHydro) {
                        iterMap.setVoxel((BlockPos)iPos, (byte)0);
                        continue;
                    }
                    leafMap.setVoxel((BlockPos)iPos, (byte)newHydro);
                    iterMap.setVoxel((BlockPos)iPos, (byte)newHydro);
                    for (Direction dir : Direction.values()) {
                        BlockPos dPos = iPos.func_177972_a(dir);
                        iterMap.setVoxel(dPos, leafMap.getVoxel(dPos));
                    }
                    continue;
                }
                if (block instanceof Ageable) {
                    ((Ageable)block).age(world, (BlockPos)iPos, blockState, world.func_201674_k(), safeBounds);
                    continue;
                }
                leafMap.setVoxel((BlockPos)iPos, (byte)0);
                iterMap.setVoxel((BlockPos)iPos, (byte)0);
            }
        }
    }

    public static void ageVolume(IWorld world, BlockPos treePos, int halfWidth, int height, int iterations, SafeChunkBounds safeBounds) {
        Iterable iterable = BlockPos.func_218278_a((BlockPos)treePos.func_177971_a((Vector3i)new BlockPos(-halfWidth, 0, -halfWidth)), (BlockPos)treePos.func_177971_a((Vector3i)new BlockPos(halfWidth, height, halfWidth)));
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos iPos : iterable) {
                BlockState blockState = world.func_180495_p(iPos);
                Block block = blockState.func_177230_c();
                if (!(block instanceof Ageable)) continue;
                ((Ageable)block).age(world, iPos, blockState, world.func_201674_k(), safeBounds);
            }
        }
    }

    public static Optional<JoCode> getJoCode(World world, BlockPos pos) {
        return TreeHelper.getJoCode(world, pos, Direction.SOUTH);
    }

    public static Optional<JoCode> getJoCode(World world, BlockPos pos, Direction direction) {
        if (pos == null) {
            return Optional.empty();
        }
        BlockPos rootPos = TreeHelper.findRootNode(world, pos = TreeHelper.dereferenceTrunkShell(world, pos));
        return rootPos != BlockPos.field_177992_a ? Optional.of(new JoCode(world, rootPos, direction)) : Optional.empty();
    }

    public static BlockPos dereferenceTrunkShell(World world, BlockPos pos) {
        TrunkShellBlock.ShellMuse muse;
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() instanceof TrunkShellBlock && (muse = ((TrunkShellBlock)blockState.func_177230_c()).getMuse((IBlockReader)world, blockState, pos)) != null) {
            return muse.pos;
        }
        return pos;
    }

    public static Species getCommonSpecies(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos = TreeHelper.dereferenceTrunkShell(world, pos));
        if (state.func_177230_c() instanceof BranchBlock) {
            BranchBlock branch = (BranchBlock)state.func_177230_c();
            return branch.getFamily().getCommonSpecies();
        }
        return Species.NULL_SPECIES;
    }

    public static Species getExactSpecies(World world, BlockPos pos) {
        BlockPos rootPos = TreeHelper.findRootNode(world, pos);
        if (rootPos != BlockPos.field_177992_a) {
            BlockState rootyState = world.func_180495_p(rootPos);
            return TreeHelper.getRooty(rootyState).getSpecies(rootyState, (IWorld)world, rootPos);
        }
        return Species.NULL_SPECIES;
    }

    public static Species getBestGuessSpecies(World world, BlockPos pos) {
        Species species = TreeHelper.getExactSpecies(world, pos);
        return species == Species.NULL_SPECIES ? TreeHelper.getCommonSpecies(world, pos) : species;
    }

    public static BlockPos findRootNode(World world, BlockPos pos) {
        pos = TreeHelper.dereferenceTrunkShell(world, pos);
        BlockState state = world.func_180495_p(pos);
        TreePart treePart = TreeHelper.getTreePart(world.func_180495_p(pos));
        switch (treePart.getTreePartType()) {
            case BRANCH: {
                MapSignal signal = treePart.analyse(state, (IWorld)world, pos, null, new MapSignal());
                if (!signal.foundRoot) break;
                return signal.root;
            }
            case ROOT: {
                return pos;
            }
            default: {
                return BlockPos.field_177992_a;
            }
        }
        return BlockPos.field_177992_a;
    }

    public static void setCustomRootBlockDecay(RootyBlockDecayer decay) {
        RootyBlock.rootyBlockDecayer = decay;
    }

    public static RootyBlockDecayer getCustomRootBlockDecay() {
        return RootyBlock.rootyBlockDecayer;
    }

    public static void treeParticles(World world, BlockPos rootPos, BasicParticleType type, int num) {
        if (world.field_72995_K) {
            TreeHelper.startAnalysisFromRoot((IWorld)world, rootPos, new MapSignal(new TwinkleNode(type, num)));
        }
    }

    public static void rootParticles(World world, BlockPos rootPos, Direction offset, BasicParticleType type, int num) {
        if (world.field_72995_K && world.func_201670_d() && world.func_180495_p(rootPos).func_177230_c() instanceof RootyBlock) {
            BlockPos particlePos = rootPos.func_177971_a(offset.func_176730_m());
            DTClient.spawnParticles((IWorld)world, type, particlePos.func_177958_n(), particlePos.func_177956_o(), particlePos.func_177952_p(), num, world.func_201674_k());
        }
    }

    public static boolean startAnalysisFromRoot(IWorld world, BlockPos rootPos, MapSignal signal) {
        RootyBlock dirt = TreeHelper.getRooty(world.func_180495_p(rootPos));
        if (dirt != null) {
            dirt.startAnalysis(world, rootPos, signal);
            return true;
        }
        return false;
    }

    public static boolean isTreePart(Block block) {
        return block instanceof TreePart;
    }

    public static boolean isTreePart(BlockState blockState) {
        return TreeHelper.isTreePart(blockState.func_177230_c());
    }

    public static boolean isTreePart(IWorld blockAccess, BlockPos pos) {
        return TreeHelper.isTreePart(blockAccess.func_180495_p(pos).func_177230_c());
    }

    public static TreePart getTreePart(Block block) {
        return TreeHelper.isTreePart(block) ? (TreePart)block : NULL_TREE_PART;
    }

    public static TreePart getTreePart(BlockState blockState) {
        return TreeHelper.getTreePart(blockState.func_177230_c());
    }

    public static boolean isBranch(Block block) {
        return block instanceof BranchBlock;
    }

    public static boolean isBranch(@Nullable BlockState state) {
        return state != null && TreeHelper.isBranch(state.func_177230_c());
    }

    @Nullable
    public static BranchBlock getBranch(Block block) {
        return TreeHelper.isBranch(block) ? (BranchBlock)block : null;
    }

    @Nullable
    public static BranchBlock getBranch(TreePart treepart) {
        return treepart instanceof BranchBlock ? (BranchBlock)treepart : null;
    }

    @Nullable
    public static BranchBlock getBranch(BlockState state) {
        return TreeHelper.getBranch(state.func_177230_c());
    }

    public static int getRadius(IBlockReader access, BlockPos pos) {
        BlockState state = access.func_180495_p(pos);
        return TreeHelper.getTreePart(state).getRadius(state);
    }

    public static Optional<BranchBlock> getBranchOpt(Block block) {
        return TreeHelper.isBranch(block) ? Optional.of((BranchBlock)block) : Optional.empty();
    }

    public static Optional<BranchBlock> getBranchOpt(BlockState state) {
        Block block = state.func_177230_c();
        return TreeHelper.isBranch(block) ? Optional.of((BranchBlock)block) : Optional.empty();
    }

    public static Optional<BranchBlock> getBranchOpt(TreePart treepart) {
        return treepart instanceof BranchBlock ? Optional.of((BranchBlock)treepart) : Optional.empty();
    }

    public static Optional<RootyBlock> getRootyOpt(BlockState blockState) {
        Block block = blockState.func_177230_c();
        return TreeHelper.isRooty(block) ? Optional.of((RootyBlock)block) : Optional.empty();
    }

    public static boolean isLeaves(Block block) {
        return block instanceof DynamicLeavesBlock;
    }

    public static boolean isLeaves(BlockState blockState) {
        return TreeHelper.isLeaves(blockState.func_177230_c());
    }

    @Nullable
    public static DynamicLeavesBlock getLeaves(Block block) {
        return TreeHelper.isLeaves(block) ? (DynamicLeavesBlock)block : null;
    }

    @Nullable
    public static DynamicLeavesBlock getLeaves(TreePart treepart) {
        return treepart instanceof DynamicLeavesBlock ? (DynamicLeavesBlock)treepart : null;
    }

    @Nullable
    public static DynamicLeavesBlock getLeaves(BlockState state) {
        return TreeHelper.getLeaves(state.func_177230_c());
    }

    public static Optional<DynamicLeavesBlock> getLeavesOpt(BlockState state) {
        return Optional.ofNullable(TreeHelper.getLeaves(state.func_177230_c()));
    }

    public static boolean isRooty(Block block) {
        return block instanceof RootyBlock;
    }

    public static boolean isRooty(BlockState blockState) {
        return TreeHelper.isRooty(blockState.func_177230_c());
    }

    @Nullable
    public static RootyBlock getRooty(Block block) {
        return TreeHelper.isRooty(block) ? (RootyBlock)block : null;
    }

    @Nullable
    public static RootyBlock getRooty(TreePart treepart) {
        return treepart instanceof RootyBlock ? (RootyBlock)treepart : null;
    }

    @Nullable
    public static RootyBlock getRooty(BlockState blockState) {
        return TreeHelper.getRooty(blockState.func_177230_c());
    }
}

