/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.cells.CellKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;

public final class TreeRegistry {
    public static final Map<BlockState, Species> SAPLING_REPLACERS = new HashMap<BlockState, Species>();

    private TreeRegistry() {
    }

    public static Species findSpecies(String name) {
        return TreeRegistry.findSpecies(TreeRegistry.getResLoc(name));
    }

    public static Species findSpecies(ResourceLocation name) {
        return (Species)Species.REGISTRY.get(name);
    }

    public static Species findSpeciesSloppy(String name) {
        ResourceLocation resourceLocation = TreeRegistry.getResLoc(name);
        if (Species.REGISTRY.has(resourceLocation)) {
            return TreeRegistry.findSpecies(resourceLocation);
        }
        for (Species species : Species.REGISTRY) {
            if (!species.getRegistryName().func_110623_a().equals(resourceLocation.func_110623_a())) continue;
            return species;
        }
        return Species.NULL_SPECIES;
    }

    public static List<ResourceLocation> getSpeciesDirectory() {
        return new ArrayList<ResourceLocation>(Species.REGISTRY.getRegistryNames());
    }

    public static List<ResourceLocation> getTransformableSpeciesLocations() {
        return Species.REGISTRY.getRegistryNames().stream().filter(resLoc -> TreeRegistry.findSpecies(resLoc).isTransformable()).collect(Collectors.toList());
    }

    public static List<Species> getTransformableSpecies() {
        return TreeRegistry.getTransformableSpeciesLocations().stream().map(TreeRegistry::findSpecies).collect(Collectors.toList());
    }

    public static List<Species> getPotionTransformableSpecies() {
        return TreeRegistry.getTransformableSpecies().stream().filter(species -> species.hasSeed() && (!species.isCommonSpecies() || species.isSeedCommon())).collect(Collectors.toList());
    }

    public static void registerSaplingReplacer(BlockState state, Species species) {
        SAPLING_REPLACERS.put(state, species);
    }

    public static CellKit findCellKit(String name) {
        return TreeRegistry.findCellKit(TreeRegistry.getResLoc(name));
    }

    public static CellKit findCellKit(ResourceLocation name) {
        return (CellKit)CellKit.REGISTRY.get(name);
    }

    public static GrowthLogicKit findGrowthLogicKit(String name) {
        return TreeRegistry.findGrowthLogicKit(TreeRegistry.getResLoc(name));
    }

    public static GrowthLogicKit findGrowthLogicKit(ResourceLocation name) {
        return (GrowthLogicKit)GrowthLogicKit.REGISTRY.get(name);
    }

    public static ResourceLocation getResLoc(String resLocStr) {
        return TreeRegistry.processResLoc(new ResourceLocation(resLocStr));
    }

    public static ResourceLocation parseResLoc(String resourceLocationString) {
        return Optional.ofNullable(ResourceLocation.func_208304_a((String)resourceLocationString)).orElse(DTTrees.NULL);
    }

    public static ResourceLocation processResLoc(ResourceLocation resourceLocation) {
        return "minecraft".equals(resourceLocation.func_110624_b()) ? DynamicTrees.resLoc(resourceLocation.func_110623_a()) : resourceLocation;
    }
}

