/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.registry;

import com.ferreusveritas.dynamictrees.api.registry.ConcurrentRegistry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;

public class RegistryHandler
extends RegistryEntry<RegistryHandler> {
    public static final ConcurrentRegistry<RegistryHandler> REGISTRY = new ConcurrentRegistry<RegistryHandler>(RegistryHandler.class, new RegistryHandler("null"), true);
    protected final Map<ResourceLocation, Block> blocks = new LinkedHashMap<ResourceLocation, Block>();
    protected final Map<ResourceLocation, Item> items = new LinkedHashMap<ResourceLocation, Item>();

    public static void setup(String modId) {
        RegistryHandler registryHandler = new RegistryHandler(modId);
        REGISTRY.register(registryHandler);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)registryHandler);
    }

    public static RegistryHandler get(String modId) {
        return (RegistryHandler)REGISTRY.get(new ResourceLocation(modId, modId));
    }

    public static RegistryHandler getOrCorrected(String modId) {
        RegistryHandler handler = RegistryHandler.get(modId);
        return handler.isValid() ? handler : RegistryHandler.get("dynamictrees");
    }

    public static ResourceLocation correctRegistryName(ResourceLocation registryName) {
        if (!RegistryHandler.get(registryName.func_110624_b()).isValid()) {
            registryName = ResourceLocationUtils.namespace(registryName, "dynamictrees");
        }
        return registryName;
    }

    public static <T extends Block> T addBlock(ResourceLocation registryName, T block) {
        registryName = RegistryHandler.correctRegistryName(registryName);
        RegistryHandler.get(registryName.func_110624_b()).putBlock(registryName, block);
        return block;
    }

    public static <T extends Item> T addItem(ResourceLocation registryName, T item) {
        registryName = RegistryHandler.correctRegistryName(registryName);
        RegistryHandler.get(registryName.func_110624_b()).putItem(registryName, item);
        return item;
    }

    public RegistryHandler(String modId) {
        super(new ResourceLocation(modId, modId));
    }

    @Nullable
    public Block getBlock(ResourceLocation registryName) {
        return this.blocks.get(registryName);
    }

    @Nullable
    public ResourceLocation getRegName(Block block) {
        return this.blocks.entrySet().stream().filter(entry -> entry.getValue() == block).map(Map.Entry::getKey).findAny().orElse(null);
    }

    @Nullable
    public Item getItem(ResourceLocation registryName) {
        return this.items.get(registryName);
    }

    @Nullable
    public ResourceLocation getRegName(Item item) {
        return this.items.entrySet().stream().filter(entry -> entry.getValue() == item).map(Map.Entry::getKey).findAny().orElse(null);
    }

    public void putBlock(ResourceLocation registryName, Block block) {
        if (this.warnIfInvalid("Block", registryName)) {
            return;
        }
        this.blocks.put(registryName, block);
    }

    public void putItem(ResourceLocation registryName, Item item) {
        if (this.warnIfInvalid("Item", registryName)) {
            return;
        }
        this.items.put(registryName, item);
    }

    private boolean warnIfInvalid(String type, ResourceLocation registryName) {
        if (!this.isValid()) {
            LogManager.getLogger().warn("{} '{}' was added to null registry handler.", (Object)type, (Object)registryName);
        }
        return !this.isValid();
    }

    @SubscribeEvent
    public void onBlockRegistry(RegistryEvent.Register<Block> event) {
        this.blocks.forEach((resourceLocation, block) -> event.getRegistry().register(block.setRegistryName(resourceLocation)));
    }

    @SubscribeEvent
    public void onItemRegistry(RegistryEvent.Register<Item> event) {
        this.items.forEach((resourceLocation, item) -> event.getRegistry().register(item.setRegistryName(resourceLocation)));
    }
}

