/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.resource;

import com.ferreusveritas.dynamictrees.api.resource.Resource;
import com.ferreusveritas.dynamictrees.api.resource.ResourceAccessor;
import com.ferreusveritas.dynamictrees.api.resource.ResourceCollector;
import com.ferreusveritas.dynamictrees.api.resource.SimpleResourceAccessor;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;

final class SimpleResourceCollector<R>
implements ResourceCollector<R> {
    private final Supplier<Map> mapSupplier;
    public Map<ResourceLocation, Resource<R>> resources;

    public SimpleResourceCollector(Supplier<Map> mapSupplier) {
        this.mapSupplier = mapSupplier;
        this.resources = mapSupplier.get();
    }

    @Override
    public Resource<R> put(Resource<R> resource) {
        return this.resources.put(resource.getLocation(), resource);
    }

    @Override
    public Resource<R> computeIfAbsent(ResourceLocation key, Supplier<Resource<R>> resourceSupplier) {
        return this.resources.computeIfAbsent(key, (? super K k) -> (Resource)resourceSupplier.get());
    }

    @Override
    public ResourceAccessor<R> createAccessor() {
        return new SimpleResourceAccessor<R>(this.resources, this::newMap);
    }

    @Override
    public void clear() {
        this.resources = this.mapSupplier.get();
    }

    private <N> Map<ResourceLocation, Resource<N>> newMap() {
        return this.mapSupplier.get();
    }
}

