/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.resource.loading.preparation;

import com.ferreusveritas.dynamictrees.api.resource.Resource;
import com.ferreusveritas.dynamictrees.api.resource.ResourceCollector;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.AbstractResourcePreparer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class TextResourcePreparer
extends AbstractResourcePreparer<List<String>> {
    private static final String EXTENSION = ".txt";

    public TextResourcePreparer(String folder) {
        this(folder, ResourceCollector.unordered());
    }

    public TextResourcePreparer(String folderName, ResourceCollector<List<String>> resourceCollector) {
        super(folderName, EXTENSION, resourceCollector);
    }

    @Override
    protected void readAndPutResource(IResource resource, ResourceLocation resourceName) throws IOException {
        List<String> lines = this.readResource(resource);
        this.resourceCollector.put(new Resource<List<String>>(resourceName, lines));
    }

    private List<String> readResource(IResource resource) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
        return this.readLines(reader, new ArrayList<String>());
    }

    private List<String> readLines(BufferedReader reader, List<String> lines) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            this.offerLine(lines, line);
        }
        return lines;
    }

    protected void offerLine(List<String> lines, String line) {
        lines.add(line);
    }
}

