/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.treedata;

import com.ferreusveritas.dynamictrees.api.cells.Cell;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Family;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public interface TreePart {
    public Cell getHydrationCell(IBlockReader var1, BlockPos var2, BlockState var3, Direction var4, LeavesProperties var5);

    public GrowSignal growSignal(World var1, BlockPos var2, GrowSignal var3);

    public int probabilityForBlock(BlockState var1, IBlockReader var2, BlockPos var3, BranchBlock var4);

    public int getRadiusForConnection(BlockState var1, IBlockReader var2, BlockPos var3, BranchBlock var4, Direction var5, int var6);

    public int getRadius(BlockState var1);

    public boolean shouldAnalyse(BlockState var1, IBlockReader var2, BlockPos var3);

    public MapSignal analyse(BlockState var1, IWorld var2, BlockPos var3, @Nullable Direction var4, MapSignal var5);

    public Family getFamily(BlockState var1, IBlockReader var2, BlockPos var3);

    public int branchSupport(BlockState var1, IBlockReader var2, BranchBlock var3, BlockPos var4, Direction var5, int var6);

    public TreePartType getTreePartType();

    default public boolean isRootNode() {
        return false;
    }

    public static enum TreePartType {
        NULL,
        ROOT,
        BRANCH,
        LEAVES,
        OTHER;

    }
}

