/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.branches;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cell;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.cells.MetadataCell;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BasicBranchBlock
extends BranchBlock
implements IWaterLoggable {
    protected static final IntegerProperty RADIUS = IntegerProperty.func_177719_a((String)"radius", (int)1, (int)8);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected final BlockState[] branchStates;
    private int flammability = 5;
    private int fireSpreadSpeed = 5;
    private final int maxRadiusForWaterLogging = 7;

    public BasicBranchBlock(ResourceLocation name, Material material) {
        this(name, AbstractBlock.Properties.func_200945_a((Material)material).func_200947_a(SoundType.field_185848_a), RADIUS, 8);
    }

    public BasicBranchBlock(ResourceLocation name, AbstractBlock.Properties properties) {
        this(name, properties, RADIUS, 8);
    }

    public BasicBranchBlock(ResourceLocation name, AbstractBlock.Properties properties, IntegerProperty radiusProperty, int maxRadius) {
        super(name, properties);
        this.branchStates = this.createBranchStates(radiusProperty, maxRadius);
    }

    public BlockState[] createBranchStates(IntegerProperty radiusProperty, int maxRadius) {
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)radiusProperty, (Comparable)Integer.valueOf(1))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        BlockState[] branchStates = new BlockState[maxRadius + 1];
        branchStates[0] = Blocks.field_150350_a.func_176223_P();
        for (int radius = 1; radius <= maxRadius; ++radius) {
            branchStates[radius] = (BlockState)this.func_176223_P().func_206870_a((Property)radiusProperty, (Comparable)Integer.valueOf(radius));
        }
        return branchStates;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{RADIUS}).func_206894_a(new Property[]{WATERLOGGED});
    }

    @Override
    public int branchSupport(BlockState state, IBlockReader reader, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return this.isSameTree(branch) ? BasicBranchBlock.setSupport(1, 1) : 0;
    }

    @Override
    public boolean canFall() {
        return true;
    }

    @Override
    public boolean checkForRot(IWorld world, BlockPos pos, Species species, int fertility, int radius, Random rand, float chance, boolean rapid) {
        if (!rapid && (chance == 0.0f || rand.nextFloat() > chance)) {
            return false;
        }
        int neigh = 0;
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.func_177972_a(dir);
            BlockState deltaBlockState = world.func_180495_p(deltaPos);
            if (BasicBranchBlock.getBranchSupport(neigh += TreeHelper.getTreePart(deltaBlockState).branchSupport(deltaBlockState, (IBlockReader)world, this, deltaPos, dir, radius)) < 1 || BasicBranchBlock.getLeavesSupport(neigh) < 2) continue;
            return false;
        }
        boolean didRot = species.rot(world, pos, neigh & 0xF, radius, fertility, rand, rapid, fertility > 0);
        if (rapid && didRot) {
            for (Direction dir : Direction.values()) {
                BlockPos neighPos = pos.func_177972_a(dir);
                BlockState neighState = world.func_180495_p(neighPos);
                if (neighState.func_177230_c() != this) continue;
                this.checkForRot(world, neighPos, species, fertility, this.getRadius(neighState), rand, 1.0f, true);
            }
        }
        return didRot;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        if (this.getRadius(state) > 7) {
            return false;
        }
        return super.func_204510_a(world, pos, state, fluid);
    }

    @Override
    public float getHardness(BlockState state, IBlockReader worldIn, BlockPos pos) {
        int radius = this.getRadius(worldIn.func_180495_p(pos));
        float hardness = this.getFamily().getPrimitiveLog().orElse(Blocks.field_150350_a).func_176223_P().func_185887_b(worldIn, pos) * (float)(radius * radius) / 64.0f * 8.0f;
        return (float)Math.min((double)hardness, (Double)DTConfigs.MAX_TREE_HARDNESS.get());
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        int radius = this.getRadius(world.func_180495_p(pos));
        return this.fireSpreadSpeed * radius / 8;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.flammability;
    }

    public BasicBranchBlock setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public BasicBranchBlock setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
        return this;
    }

    @Override
    public Cell getHydrationCell(IBlockReader reader, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        Family thisTree = this.getFamily();
        if (leavesProperties.getFamily() == thisTree) {
            int radiusAndMeta = thisTree.getRadiusForCellKit(reader, pos, state, dir, this);
            int radius = MetadataCell.getRadius(radiusAndMeta);
            int metadata = MetadataCell.getMeta(radiusAndMeta);
            return leavesProperties.getCellKit().getCellForBranch(radius, metadata);
        }
        return CellNull.NULL_CELL;
    }

    @Override
    public int getRadius(BlockState state) {
        return this.isSameTree(state) ? (Integer)state.func_177229_b((Property)RADIUS) : 0;
    }

    @Override
    public int setRadius(IWorld world, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        boolean replacingWater = world.func_180495_p(pos).func_204520_s() == Fluids.field_204546_a.func_207204_a(false);
        boolean setWaterlogged = replacingWater && radius <= 7;
        world.func_180501_a(pos, (BlockState)this.getStateForRadius(radius).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(setWaterlogged)), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }

    @Override
    public BlockState getStateForRadius(int radius) {
        return this.branchStates[MathHelper.func_76125_a((int)radius, (int)1, (int)this.getMaxRadius())];
    }

    @Override
    public int probabilityForBlock(BlockState state, IBlockReader reader, BlockPos pos, BranchBlock from) {
        return this.isSameTree(from) ? this.getRadius(state) + 2 : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GrowSignal growIntoAir(World world, BlockPos pos, GrowSignal signal, int fromRadius) {
        Species species = signal.getSpecies();
        DynamicLeavesBlock leaves = species.getLeavesBlock().orElse(null);
        if (leaves != null) {
            if (fromRadius != this.getFamily().getPrimaryThickness()) return leaves.branchOut(world, pos, signal);
            signal.success = leaves.growLeavesIfLocationIsSuitable((IWorld)world, species.getLeavesProperties(), pos, 0);
            return signal;
        } else {
            if (BasicBranchBlock.isNextToBranch(world, pos, signal.dir.func_176734_d())) {
                signal.success = false;
                return signal;
            }
            this.setRadius((IWorld)world, pos, this.getFamily().getPrimaryThickness(), null);
            signal.radius = this.getFamily().getSecondaryThickness();
            signal.success = true;
        }
        return signal;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (!signal.step()) {
            return signal;
        }
        BlockState currBlockState = world.func_180495_p(pos);
        Species species = signal.getSpecies();
        boolean inTrunk = signal.isInTrunk();
        Direction originDir = signal.dir.func_176734_d();
        Direction targetDir = species.getGrowthLogicKit().selectNewDirection(new DirectionSelectionContext(world, pos, species, this, signal));
        signal.doTurn(targetDir);
        BlockPos deltaPos = pos.func_177972_a(targetDir);
        Direction[] deltaState = world.func_180495_p(deltaPos);
        TreePart treepart = TreeHelper.getTreePart((BlockState)deltaState);
        if (treepart != TreeHelper.NULL_TREE_PART) {
            signal = treepart.growSignal(world, deltaPos, signal);
        } else if (world.func_175623_d(deltaPos) || deltaState.func_177230_c() instanceof TrunkShellBlock) {
            signal = this.growIntoAir(world, deltaPos, signal, this.getRadius(currBlockState));
        }
        float areaAccum = signal.radius * signal.radius;
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos2;
            BlockState blockState;
            TreePart treepart2;
            if (dir.equals((Object)originDir) || dir.equals((Object)targetDir) || !this.isSameTree(treepart2 = TreeHelper.getTreePart(blockState = world.func_180495_p(deltaPos2 = pos.func_177972_a(dir))))) continue;
            int branchRadius = treepart2.getRadius(blockState);
            areaAccum += (float)(branchRadius * branchRadius);
        }
        if (!signal.choked) {
            int maxRadius = inTrunk ? species.getMaxBranchRadius() : Math.min(species.getMaxBranchRadius(), 8);
            signal.radius = MathHelper.func_76131_a((float)((float)Math.sqrt(areaAccum) + species.getTapering()), (float)this.getRadius(currBlockState), (float)maxRadius);
            int targetRadius = (int)Math.floor(signal.radius);
            int setRad = this.setRadius((IWorld)world, pos, targetRadius, originDir);
            if (setRad < targetRadius) {
                signal.choked = true;
            }
        }
        return signal;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return (Boolean)DTConfigs.ENABLE_BRANCH_CLIMBING.get() != false && entity instanceof PlayerEntity && this.getFamily().branchIsLadder() && (!state.func_235901_b_((Property)WATERLOGGED) || (Boolean)state.func_177229_b((Property)WATERLOGGED) == false);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int thisRadiusInt = this.getRadius(state);
        double radius = (double)thisRadiusInt / 16.0;
        VoxelShape core = VoxelShapes.func_197873_a((double)(0.5 - radius), (double)(0.5 - radius), (double)(0.5 - radius), (double)(0.5 + radius), (double)(0.5 + radius), (double)(0.5 + radius));
        for (Direction dir : Direction.values()) {
            int sideRadiusInt = Math.min(this.getSideConnectionRadius(worldIn, pos, thisRadiusInt, dir), thisRadiusInt);
            double sideRadius = (float)sideRadiusInt / 16.0f;
            if (!(sideRadius > 0.0)) continue;
            double gap = 0.5 - sideRadius;
            AxisAlignedBB aabb = new AxisAlignedBB(0.5 - sideRadius, 0.5 - sideRadius, 0.5 - sideRadius, 0.5 + sideRadius, 0.5 + sideRadius, 0.5 + sideRadius);
            aabb = aabb.func_72321_a((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap);
            core = VoxelShapes.func_197872_a((VoxelShape)core, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb));
        }
        return core;
    }

    @Override
    public int getRadiusForConnection(BlockState state, IBlockReader reader, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getRadius(state);
    }

    protected int getSideConnectionRadius(IBlockReader blockAccess, BlockPos pos, int radius, Direction side) {
        BlockPos deltaPos = pos.func_177972_a(side);
        BlockState blockState = CoordUtils.getStateSafe(blockAccess, deltaPos);
        return blockState == null ? 0 : TreeHelper.getTreePart(blockState).getRadiusForConnection(blockState, blockAccess, deltaPos, this, side, radius);
    }

    protected int getMaxSignalDepth() {
        return this.getFamily().getMaxSignalDepth();
    }

    @Override
    public MapSignal analyse(BlockState blockState, IWorld world, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        if (signal.overflow || signal.trackVisited && signal.doTrackingVisited(pos)) {
            return signal;
        }
        if (signal.depth++ < this.getMaxSignalDepth()) {
            signal.run(blockState, world, pos, fromDir);
            for (Direction dir : Direction.values()) {
                BlockPos deltaPos;
                BlockState deltaState;
                TreePart treePart;
                if (dir == fromDir || !(treePart = TreeHelper.getTreePart(deltaState = world.func_180495_p(deltaPos = pos.func_177972_a(dir)))).shouldAnalyse(deltaState, (IBlockReader)world, deltaPos)) continue;
                signal = treePart.analyse(deltaState, world, deltaPos, dir.func_176734_d(), signal);
                if (!signal.foundRoot || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, world, pos, fromDir);
        } else {
            BlockState state = world.func_180495_p(pos);
            if (signal.destroyLoopedNodes && state.func_177230_c() instanceof BranchBlock) {
                BranchBlock branch = (BranchBlock)state.func_177230_c();
                branch.breakDeliberate(world, pos, DynamicTrees.DestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }
}

