/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.branches;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.FutureBreakable;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockWithDynamicHardness;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.event.FutureBreak;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.nodemappers.DestroyerNode;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NetVolumeNode;
import com.ferreusveritas.dynamictrees.systems.nodemappers.SpeciesNode;
import com.ferreusveritas.dynamictrees.systems.nodemappers.StateNode;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.Connections;
import com.ferreusveritas.dynamictrees.util.LootTableSupplier;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;

public abstract class BranchBlock
extends BlockWithDynamicHardness
implements TreePart,
FutureBreakable {
    public static final int MAX_RADIUS = 8;
    public static final String NAME_SUFFIX = "_branch";
    public static DynamicTrees.DestroyMode destroyMode = DynamicTrees.DestroyMode.SLOPPY;
    private Family family = Family.NULL_FAMILY;
    private ItemStack[] primitiveLogDrops = new ItemStack[0];
    private boolean canBeStripped;
    private final LootTableSupplier lootTableSupplier;

    public BranchBlock(ResourceLocation name, Material material) {
        this(name, AbstractBlock.Properties.func_200945_a((Material)material));
    }

    public BranchBlock(ResourceLocation name, AbstractBlock.Properties properties) {
        super(properties);
        this.lootTableSupplier = new LootTableSupplier("trees/branches/", name);
    }

    public BranchBlock setCanBeStripped(boolean truth) {
        this.canBeStripped = truth;
        return this;
    }

    public void setFamily(Family tree) {
        this.family = tree;
    }

    public Family getFamily() {
        return this.family;
    }

    @Override
    public Family getFamily(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getFamily();
    }

    public boolean isSameTree(TreePart treepart) {
        return this.isSameTree(TreeHelper.getBranch(treepart));
    }

    public boolean isSameTree(BlockState state) {
        return this.isSameTree(TreeHelper.getBranch(state));
    }

    public boolean isSameTree(@Nullable BranchBlock branch) {
        return branch != null && this.getFamily() == branch.getFamily();
    }

    public Optional<Block> getPrimitiveLog() {
        return this.isStrippedBranch() ? this.family.getPrimitiveStrippedLog() : this.family.getPrimitiveLog();
    }

    public boolean isStrippedBranch() {
        return this.getFamily().getStrippedBranch().map(other -> other == this).orElse(false);
    }

    @Override
    public abstract int branchSupport(BlockState var1, IBlockReader var2, BranchBlock var3, BlockPos var4, Direction var5, int var6);

    public abstract boolean checkForRot(IWorld var1, BlockPos var2, Species var3, int var4, int var5, Random var6, float var7, boolean var8);

    public static int setSupport(int branches, int leaves) {
        return (branches & 0xF) << 4 | leaves & 0xF;
    }

    public static int getBranchSupport(int support) {
        return support >> 4 & 0xF;
    }

    public static int getLeavesSupport(int support) {
        return support & 0xF;
    }

    public static boolean isNextToBranch(World world, BlockPos pos, Direction originDir) {
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir) || !TreeHelper.isBranch(world.func_180495_p(pos.func_177972_a(dir)))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        return TreeHelper.getTreePart(state).getFamily(state, (IBlockReader)world, pos).onTreeActivated(new Family.TreeActivationContext(world, TreeHelper.findRootNode(world, pos), pos, state, player, hand, heldItem, hit)) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public boolean canBeStripped(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack heldItem) {
        int stripRadius = (Integer)DTConfigs.MIN_RADIUS_FOR_STRIP.get();
        return stripRadius != 0 && stripRadius <= this.getRadius(state) && this.canBeStripped && this.isAxe(heldItem);
    }

    public void stripBranch(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack heldItem) {
        int radius = this.getRadius(state);
        this.damageTool((LivingEntity)player, heldItem, radius / 2, new NetVolumeNode.Volume(radius * radius * 64 / 2), false);
        this.stripBranch(state, (IWorld)world, pos, radius);
    }

    public void stripBranch(BlockState state, IWorld world, BlockPos pos) {
        this.stripBranch(state, world, pos, this.getRadius(state));
    }

    public void stripBranch(BlockState state, IWorld world, BlockPos pos, int radius) {
        this.getFamily().getStrippedBranch().ifPresent(strippedBranch -> strippedBranch.setRadius(world, pos, Math.max(1, radius - ((Boolean)DTConfigs.ENABLE_STRIP_RADIUS_REDUCTION.get() != false ? 1 : 0)), null));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getFamily().getBranchItem().map(ItemStack::new).orElse(ItemStack.field_190927_a);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public Connections getConnectionData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        Connections connections = new Connections();
        if (state.func_177230_c() != this) {
            return connections;
        }
        int coreRadius = this.getRadius(state);
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.func_177972_a(dir);
            BlockState neighborBlockState = world.func_180495_p(deltaPos);
            int sideRadius = TreeHelper.getTreePart(neighborBlockState).getRadiusForConnection(neighborBlockState, (IBlockReader)world, deltaPos, this, dir, coreRadius);
            connections.setRadius(dir, MathHelper.func_76125_a((int)sideRadius, (int)0, (int)coreRadius));
        }
        return connections;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public int getRadius(BlockState state) {
        return 1;
    }

    public abstract int setRadius(IWorld var1, BlockPos var2, int var3, @Nullable Direction var4, int var5);

    public int setRadius(IWorld world, BlockPos pos, int radius, @Nullable Direction originDir) {
        return this.setRadius(world, pos, radius, originDir, 2);
    }

    public abstract BlockState getStateForRadius(int var1);

    public int getMaxRadius() {
        return 8;
    }

    @Override
    public boolean shouldAnalyse(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public BranchDestructionData destroyBranchFromNode(World world, BlockPos cutPos, Direction toolDir, boolean wholeTree, @Nullable LivingEntity entity) {
        BlockState blockState = world.func_180495_p(cutPos);
        SpeciesNode speciesNode = new SpeciesNode();
        MapSignal signal = this.analyse(blockState, (IWorld)world, cutPos, null, new MapSignal(speciesNode));
        Species species = speciesNode.getSpecies();
        StateNode stateMapper = new StateNode(cutPos);
        this.analyse(blockState, (IWorld)world, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(stateMapper));
        NetVolumeNode volumeSum = new NetVolumeNode();
        DestroyerNode destroyer = new DestroyerNode(species).setPlayer(entity instanceof PlayerEntity ? (PlayerEntity)entity : null);
        destroyMode = DynamicTrees.DestroyMode.HARVEST;
        this.analyse(blockState, (IWorld)world, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(volumeSum, destroyer));
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        List<Object> endPoints = destroyer.getEnds();
        HashMap<BlockPos, BlockState> destroyedLeaves = new HashMap<BlockPos, BlockState>();
        ArrayList<ItemStackPos> leavesDropsList = new ArrayList<ItemStackPos>();
        this.destroyLeaves(world, cutPos, species, entity == null ? ItemStack.field_190927_a : entity.func_184614_ca(), endPoints, destroyedLeaves, leavesDropsList);
        endPoints = endPoints.stream().map(p -> p.func_177973_b((Vector3i)cutPos)).collect(Collectors.toList());
        int trunkHeight = 1;
        BlockPos iter = new BlockPos(0, 1, 0);
        while (stateMapper.getBranchConnectionMap().containsKey(iter)) {
            ++trunkHeight;
            iter = iter.func_177984_a();
        }
        Direction cutDir = signal.localRootDir;
        if (cutDir == null) {
            cutDir = Direction.DOWN;
        }
        return new BranchDestructionData(species, stateMapper.getBranchConnectionMap(), destroyedLeaves, leavesDropsList, endPoints, volumeSum.getVolume(), cutPos, cutDir, toolDir, trunkHeight);
    }

    public void rot(IWorld world, BlockPos pos) {
        this.breakDeliberate(world, pos, DynamicTrees.DestroyMode.ROT);
    }

    public void destroyLeaves(World world, BlockPos cutPos, Species species, ItemStack tool, List<BlockPos> endPoints, Map<BlockPos, BlockState> destroyedLeaves, List<ItemStackPos> drops) {
        if (world.field_72995_K || endPoints.isEmpty()) {
            return;
        }
        BlockBounds bounds = this.getFamily().expandLeavesBlockBounds(new BlockBounds(endPoints));
        SimpleVoxmap leafMap = new SimpleVoxmap(bounds);
        for (BlockPos endPos : endPoints) {
            for (BlockPos leafPos : this.getFamily().expandLeavesBlockBounds(new BlockBounds(endPos))) {
                leafMap.setVoxel(leafPos, (byte)1);
            }
            leafMap.setVoxel(endPos, (byte)0);
        }
        Family family = species.getFamily();
        BranchBlock familyBranch = family.getBranch().get();
        int primaryThickness = family.getPrimaryThickness();
        for (BlockPos findPos : this.getFamily().expandLeavesBlockBounds(bounds)) {
            BlockState findState = world.func_180495_p(findPos);
            if (familyBranch.getRadius(findState) != primaryThickness) continue;
            Iterable<BlockPos.Mutable> leaves = species.getLeavesProperties().getCellKit().getLeafCluster().getAllNonZero();
            for (BlockPos.Mutable leafPos : leaves) {
                leafMap.setVoxel(findPos.func_177958_n() + leafPos.func_177958_n(), findPos.func_177956_o() + leafPos.func_177956_o(), findPos.func_177952_p() + leafPos.func_177952_p(), (byte)0);
            }
        }
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells()) {
            BlockPos.Mutable pos = cell.getPos();
            BlockState state = world.func_180495_p((BlockPos)pos);
            if (!family.isCompatibleGenericLeaves(species, state, (IWorld)world, (BlockPos)pos)) continue;
            dropList.clear();
            LeavesProperties leaves = TreeHelper.getLeavesOpt(state).map(block -> block.getProperties(state)).orElse(LeavesProperties.NULL);
            dropList.addAll(leaves.getDrops(world, (BlockPos)pos, tool, species));
            BlockPos imPos = pos.func_185334_h();
            BlockPos relPos = imPos.func_177973_b((Vector3i)cutPos);
            world.func_180501_a(imPos, BlockStates.AIR, 3);
            destroyedLeaves.put(relPos, state);
            dropList.forEach(i -> drops.add(new ItemStackPos((ItemStack)i, relPos)));
        }
    }

    public boolean canFall() {
        return false;
    }

    public ResourceLocation getLootTableName() {
        return this.lootTableSupplier.getName();
    }

    public LootTable getLootTable(LootTableManager lootTableManager, Species species) {
        return this.lootTableSupplier.get(lootTableManager, species);
    }

    @Deprecated
    public List<ItemStack> getLogDrops(World world, BlockPos pos, Species species, NetVolumeNode.Volume volume) {
        return species.getBranchesDrops(world, volume);
    }

    public LootTable.Builder createBranchDrops() {
        return DTLootTableProvider.createBranchDrops(this.getPrimitiveLog().get(), this.family.getStick(1).func_77973_b());
    }

    public float getPrimitiveLogs(float volumeIn, List<ItemStack> drops) {
        int numLogs = (int)volumeIn;
        for (ItemStack stack : this.primitiveLogDrops) {
            for (int num = numLogs * stack.func_190916_E(); num > 0; num -= stack.func_77976_d()) {
                ItemStack drop = stack.func_77946_l();
                drop.func_190920_e(Math.min(num, stack.func_77976_d()));
                drops.add(drop);
            }
        }
        return volumeIn - (float)numLogs;
    }

    public BranchBlock setPrimitiveLogDrops(ItemStack ... drops) {
        this.primitiveLogDrops = drops;
        return this;
    }

    @Override
    public void futureBreak(BlockState state, World world, BlockPos cutPos, LivingEntity entity) {
        double reachDistance = entity instanceof PlayerEntity ? entity.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() : 5.0;
        BlockRayTraceResult ragTraceResult = this.playerRayTrace(entity, reachDistance, 1.0f);
        Direction toolDir = ragTraceResult != null ? (entity.func_225608_bj_() ? ragTraceResult.func_216354_b().func_176734_d() : ragTraceResult.func_216354_b()) : Direction.DOWN;
        world.func_217378_a(null, 2001, cutPos, BranchBlock.func_196246_j((BlockState)state));
        BranchDestructionData destroyData = this.destroyBranchFromNode(world, cutPos, toolDir, false, entity);
        ItemStack heldItem = entity.func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem);
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        NetVolumeNode.Volume woodVolume = destroyData.woodVolume;
        woodVolume.multiplyVolume(fortuneFactor);
        List<ItemStack> woodItems = destroyData.species.getBranchesDrops(world, woodVolume, heldItem);
        FallingTreeEntity.dropTree(world, destroyData, woodItems, FallingTreeEntity.DestroyType.HARVEST);
        if (heldItem != ItemStack.field_190927_a) {
            this.damageTool(entity, heldItem, this.getRadius(state), woodVolume, true);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return this.removedByEntity(state, world, pos, (LivingEntity)player);
    }

    public boolean removedByEntity(BlockState state, World world, BlockPos cutPos, LivingEntity entity) {
        FutureBreak.add(new FutureBreak(state, world, cutPos, entity, 0));
        return false;
    }

    protected void sloppyBreak(World world, BlockPos cutPos, FallingTreeEntity.DestroyType destroyType) {
        BranchDestructionData destroyData = this.destroyBranchFromNode(world, cutPos, Direction.DOWN, false, null);
        List<ItemStack> woodDropList = destroyData.species.getBranchesDrops(world, destroyData.woodVolume);
        if (!((Boolean)DTConfigs.SLOPPY_BREAK_DROPS.get()).booleanValue()) {
            destroyData.leavesDrops.clear();
            woodDropList.clear();
        }
        FallingTreeEntity.dropTree(world, destroyData, woodDropList, destroyType);
    }

    @Nullable
    public BlockRayTraceResult playerRayTrace(LivingEntity entity, double blockReachDistance, float partialTicks) {
        Vector3d vec3d = entity.func_174824_e(partialTicks);
        Vector3d vec3d1 = entity.func_70676_i(partialTicks);
        Vector3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return entity.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
    }

    public void damageTool(LivingEntity entity, @Nullable ItemStack heldItem, int radius, NetVolumeNode.Volume woodVolume, boolean forBlockBreak) {
        int damage;
        switch ((DynamicTrees.AxeDamage)((Object)DTConfigs.AXE_DAMAGE_MODE.get())) {
            default: {
                damage = 1;
                break;
            }
            case THICKNESS: {
                damage = Math.max(1, radius) / 2;
                break;
            }
            case VOLUME: {
                damage = (int)woodVolume.getVolume();
            }
        }
        if (forBlockBreak) {
            --damage;
        }
        if (damage > 0) {
            heldItem.func_222118_a(damage, entity, LivingEntity::func_70071_h_);
        }
    }

    protected boolean isAxe(ItemStack stack) {
        return stack.func_77973_b() instanceof AxeItem || stack.func_77973_b().getToolTypes(stack).contains(ToolType.AXE);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean flag) {
        if (world.field_72995_K || destroyMode != DynamicTrees.DestroyMode.SLOPPY) {
            super.func_196243_a(state, world, pos, newState, flag);
            return;
        }
        BlockState toBlockState = world.func_180495_p(pos);
        Block toBlock = toBlockState.func_177230_c();
        if (toBlock instanceof BranchBlock) {
            return;
        }
        if (toBlock == Blocks.field_150350_a) {
            world.func_180501_a(pos, state, 0);
            this.sloppyBreak(world, pos, FallingTreeEntity.DestroyType.VOID);
            this.setBlockStateIgnored(world, pos, BlockStates.AIR, 2);
            return;
        }
        if (toBlock == Blocks.field_150480_ab) {
            world.func_180501_a(pos, state, 0);
            this.sloppyBreak(world, pos, FallingTreeEntity.DestroyType.FIRE);
            this.setBlockStateIgnored(world, pos, BlockStates.AIR, 2);
            return;
        }
        if (!toBlock.hasTileEntity(toBlockState) && world.func_175625_s(pos) == null) {
            world.func_180501_a(pos, state, 0);
            this.sloppyBreak(world, pos, FallingTreeEntity.DestroyType.VOID);
            this.setBlockStateIgnored(world, pos, toBlockState, 2);
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockPos offPos = pos.func_177972_a(dir);
            BlockState offState = world.func_180495_p(offPos);
            if (!(offState.func_177230_c() instanceof BranchBlock)) continue;
            this.sloppyBreak(world, offPos, FallingTreeEntity.DestroyType.VOID);
        }
        super.func_196243_a(state, world, pos, newState, flag);
    }

    public void setBlockStateIgnored(World world, BlockPos pos, BlockState state, int flags) {
        destroyMode = DynamicTrees.DestroyMode.IGNORE;
        world.func_180501_a(pos, state, flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
    }

    public void breakDeliberate(IWorld world, BlockPos pos, DynamicTrees.DestroyMode mode) {
        destroyMode = mode;
        world.func_217377_a(pos, false);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        NetVolumeNode.Volume woodVolume;
        List<ItemStack> woodDropList;
        Species species = TreeHelper.getExactSpecies(world, pos);
        BranchDestructionData destroyData = this.destroyBranchFromNode(world, pos, Direction.DOWN, false, null);
        FallingTreeEntity treeEntity = FallingTreeEntity.dropTree(world, destroyData, woodDropList = species.getBranchesDrops(world, woodVolume = destroyData.woodVolume, ItemStack.field_190927_a, Float.valueOf(explosion.field_77280_f)), FallingTreeEntity.DestroyType.BLAST);
        if (treeEntity != null) {
            Vector3d expPos = explosion.getPosition();
            double distance = Math.sqrt(treeEntity.func_70092_e(expPos.field_72450_a, expPos.field_72448_b, expPos.field_72449_c));
            if (distance / (double)explosion.field_77280_f <= 1.0 && distance != 0.0) {
                treeEntity.func_70024_g((treeEntity.func_226277_ct_() - expPos.field_72450_a) / distance, (treeEntity.func_226278_cu_() - expPos.field_72448_b) / distance, (treeEntity.func_226281_cx_() - expPos.field_72449_c) / distance);
            }
        }
        this.func_180652_a(world, pos, explosion);
    }

    @Override
    public final TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.BRANCH;
    }

    public boolean shouldGenerateBranchDrops() {
        return this.getPrimitiveLog().isPresent();
    }

    public static class ItemStackPos {
        public final ItemStack stack;
        public final BlockPos pos;

        public ItemStackPos(ItemStack stack, BlockPos pos) {
            this.stack = stack;
            this.pos = pos;
        }
    }
}

