/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.branches;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.RootConnections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class SurfaceRootBlock
extends Block
implements IWaterLoggable {
    public static final int MAX_RADIUS = 8;
    protected static final IntegerProperty RADIUS = IntegerProperty.func_177719_a((String)"radius", (int)1, (int)8);
    public static final BooleanProperty GROUNDED = BooleanProperty.func_177716_a((String)"grounded");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final Family family;

    public SurfaceRootBlock(Family family) {
        this(Material.field_151575_d, family);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public SurfaceRootBlock(Material material, Family family) {
        super(AbstractBlock.Properties.func_200945_a((Material)material).harvestTool(ToolType.AXE).harvestLevel(0).func_200948_a(2.5f, 1.0f).func_200947_a(SoundType.field_185848_a));
        this.family = family;
    }

    public Family getFamily() {
        return this.family;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.family.getBranchItem().map(ItemStack::new).orElse(ItemStack.field_190927_a);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{RADIUS, GROUNDED, WATERLOGGED});
    }

    public int getRadius(BlockState blockState) {
        return blockState.func_177230_c() == this ? (Integer)blockState.func_177229_b((Property)RADIUS) : 0;
    }

    public int setRadius(IWorld world, BlockPos pos, int radius, int flags) {
        boolean replacingWater = world.func_180495_p(pos).func_204520_s() == Fluids.field_204546_a.func_207204_a(false);
        world.func_180501_a(pos, (BlockState)this.getStateForRadius(radius).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(replacingWater)), flags);
        return radius;
    }

    public BlockState getStateForRadius(int radius) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)RADIUS, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)radius, (int)0, (int)this.getMaxRadius())));
    }

    public int getMaxRadius() {
        return 8;
    }

    public int getRadialHeight(int radius) {
        return radius * 2;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public RootConnections getConnectionData(IBlockDisplayReader world, BlockPos pos) {
        RootConnections connections = new RootConnections();
        for (Direction dir : CoordUtils.HORIZONTALS) {
            RootConnection connection = this.getSideConnectionRadius((IBlockReader)world, pos, dir);
            if (connection == null) continue;
            connections.setRadius(dir, connection.radius);
            connections.setConnectionLevel(dir, connection.level);
        }
        return connections;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        boolean connectionMade = false;
        int thisRadius = this.getRadius(state);
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (Direction dir : CoordUtils.HORIZONTALS) {
            RootConnection conn = this.getSideConnectionRadius(world, pos, dir);
            if (conn == null) continue;
            connectionMade = true;
            int r = MathHelper.func_76125_a((int)conn.radius, (int)1, (int)thisRadius);
            double radius = (double)r / 16.0;
            double radialHeight = (double)this.getRadialHeight(r) / 16.0;
            double gap = 0.5 - radius;
            AxisAlignedBB aabb = new AxisAlignedBB(-radius, 0.0, -radius, radius, radialHeight, radius);
            aabb = aabb.func_72321_a((double)dir.func_82601_c() * gap, 0.0, (double)dir.func_82599_e() * gap).func_72317_d(0.5, 0.0, 0.5);
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (!connectionMade) {
            double radius = (double)thisRadius / 16.0;
            double radialHeight = (double)this.getRadialHeight(thisRadius) / 16.0;
            AxisAlignedBB aabb = new AxisAlignedBB(0.5 - radius, 0.0, 0.5 - radius, 0.5 + radius, radialHeight, 0.5 + radius);
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    private boolean isAirOrWater(BlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_150355_j;
    }

    @Nullable
    protected RootConnection getSideConnectionRadius(IBlockReader blockReader, BlockPos pos, Direction side) {
        RootConnections.ConnectionLevel level;
        if (!side.func_176740_k().func_176722_c()) {
            return null;
        }
        BlockPos dPos = pos.func_177972_a(side);
        BlockState state = CoordUtils.getStateSafe(blockReader, dPos);
        BlockState upState = CoordUtils.getStateSafe(blockReader, pos.func_177984_a());
        RootConnections.ConnectionLevel connectionLevel = upState != null && this.isAirOrWater(upState) && state != null && state.func_215686_e(blockReader, dPos) ? RootConnections.ConnectionLevel.HIGH : (level = state != null && this.isAirOrWater(state) ? RootConnections.ConnectionLevel.LOW : RootConnections.ConnectionLevel.MID);
        if (level != RootConnections.ConnectionLevel.MID) {
            dPos = dPos.func_177981_b(level.getYOffset());
            state = CoordUtils.getStateSafe(blockReader, dPos);
        }
        if (state != null && state.func_177230_c() instanceof SurfaceRootBlock) {
            return new RootConnection(level, ((SurfaceRootBlock)state.func_177230_c()).getRadius(state));
        }
        if (level == RootConnections.ConnectionLevel.MID && TreeHelper.isBranch(state) && TreeHelper.getTreePart(state).getRadius(state) >= 8) {
            return new RootConnection(RootConnections.ConnectionLevel.MID, 8);
        }
        return null;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        BlockState upstate = world.func_180495_p(pos.func_177984_a());
        if (upstate.func_177230_c() instanceof TrunkShellBlock) {
            world.func_175656_a(pos, upstate);
        }
        for (Direction dir : CoordUtils.HORIZONTALS) {
            BlockPos dPos = pos.func_177972_a(dir).func_177977_b();
            world.func_180495_p(dPos).func_215697_a(world, dPos, (Block)this, pos, false);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canBlockStay(world, pos, state)) {
            world.func_217377_a(pos, false);
        }
    }

    protected boolean canBlockStay(World world, BlockPos pos, BlockState state) {
        BlockPos below = pos.func_177977_b();
        BlockState belowState = world.func_180495_p(below);
        int radius = this.getRadius(state);
        if (belowState.func_215686_e((IBlockReader)world, below)) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                RootConnection conn = this.getSideConnectionRadius((IBlockReader)world, pos, dir);
                if (conn == null || conn.radius <= radius) continue;
                return true;
            }
        } else {
            boolean connections = false;
            for (Direction dir : CoordUtils.HORIZONTALS) {
                RootConnection conn = this.getSideConnectionRadius((IBlockReader)world, pos, dir);
                if (conn == null) continue;
                if (conn.level == RootConnections.ConnectionLevel.MID) {
                    return false;
                }
                if (conn.radius <= radius) continue;
                connections = true;
            }
            return connections;
        }
        return false;
    }

    public static class RootConnection {
        public RootConnections.ConnectionLevel level;
        public int radius;

        public RootConnection(RootConnections.ConnectionLevel level, int radius) {
            this.level = level;
            this.radius = radius;
        }

        public String toString() {
            return super.toString() + " Level: " + this.level.toString() + " Radius: " + this.radius;
        }
    }
}

