/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.branches;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.branches.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.Musable;
import com.ferreusveritas.dynamictrees.blocks.branches.SurfaceRootBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ThickBranchBlock
extends BasicBranchBlock
implements Musable {
    public static final int MAX_RADIUS_THICK = 24;
    protected static final IntegerProperty RADIUS_DOUBLE = IntegerProperty.func_177719_a((String)"radius", (int)1, (int)24);

    public ThickBranchBlock(ResourceLocation name, Material material) {
        this(name, AbstractBlock.Properties.func_200945_a((Material)material));
    }

    public ThickBranchBlock(ResourceLocation name, AbstractBlock.Properties properties) {
        super(name, properties, RADIUS_DOUBLE, 24);
    }

    public TrunkShellBlock getTrunkShell() {
        return DTRegistries.TRUNK_SHELL;
    }

    @Override
    public void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{RADIUS_DOUBLE}).func_206894_a(new Property[]{WATERLOGGED});
    }

    @Override
    public int getRadius(BlockState state) {
        if (!(state.func_177230_c() instanceof ThickBranchBlock)) {
            return super.getRadius(state);
        }
        return this.isSameTree(state) ? MathHelper.func_76125_a((int)((Integer)state.func_177229_b((Property)RADIUS_DOUBLE)), (int)1, (int)this.getMaxRadius()) : 0;
    }

    @Override
    public int setRadius(IWorld world, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        if (this.updateTrunkShells(world, pos, radius, flags)) {
            return super.setRadius(world, pos, radius, originDir, flags);
        }
        return super.setRadius(world, pos, 8, originDir, flags);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateTrunkShells((IWorld)worldIn, pos, this.getRadius(state), 6);
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    private boolean updateTrunkShells(IWorld world, BlockPos pos, int radius, int flags) {
        ReplaceableState rep;
        BlockPos dPos;
        if (radius <= 8) {
            return true;
        }
        boolean setable = true;
        ReplaceableState[] repStates = new ReplaceableState[8];
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            dPos = pos.func_177971_a(dir.getOffset());
            repStates[dir.ordinal()] = rep = this.getReplaceability(world, dPos, pos);
            if (rep != ReplaceableState.BLOCKING) continue;
            setable = false;
            break;
        }
        if (setable) {
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                boolean replacingWater;
                dPos = pos.func_177971_a(dir.getOffset());
                rep = repStates[dir.ordinal()];
                boolean bl = replacingWater = world.func_180495_p(dPos).func_204520_s() == Fluids.field_204546_a.func_207204_a(false);
                if (rep != ReplaceableState.REPLACEABLE) continue;
                world.func_180501_a(dPos, (BlockState)((BlockState)this.getTrunkShell().func_176223_P().func_206870_a(TrunkShellBlock.CORE_DIR, (Comparable)((Object)dir.getOpposite()))).func_206870_a((Property)TrunkShellBlock.WATERLOGGED, (Comparable)Boolean.valueOf(replacingWater)), flags);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getRadiusForConnection(BlockState state, IBlockReader reader, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        if (from instanceof ThickBranchBlock) {
            return this.getRadius(state);
        }
        return Math.min(this.getRadius(state), 8);
    }

    @Override
    protected int getSideConnectionRadius(IBlockReader blockAccess, BlockPos pos, int radius, Direction side) {
        BlockPos deltaPos = pos.func_177972_a(side);
        BlockState blockState = CoordUtils.getStateSafe(blockAccess, deltaPos);
        if (blockState == null) {
            return 0;
        }
        int connectionRadius = TreeHelper.getTreePart(blockState).getRadiusForConnection(blockState, blockAccess, deltaPos, this, side, radius);
        return Math.min(8, connectionRadius);
    }

    public ReplaceableState getReplaceability(IWorld world, BlockPos pos, BlockPos corePos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof TrunkShellBlock) {
            CoordUtils.Surround surr = (CoordUtils.Surround)((Object)state.func_177229_b(TrunkShellBlock.CORE_DIR));
            return pos.func_177971_a(surr.getOffset()).equals((Object)corePos) ? ReplaceableState.SHELL : ReplaceableState.BLOCKING;
        }
        if (state.func_185904_a().func_76222_j() || block instanceof BushBlock) {
            return ReplaceableState.REPLACEABLE;
        }
        if (TreeHelper.isTreePart(block)) {
            return ReplaceableState.TREEPART;
        }
        if (block instanceof SurfaceRootBlock) {
            return ReplaceableState.TREEPART;
        }
        if (BranchConnectables.isBlockConnectable(block)) {
            return ReplaceableState.TREEPART;
        }
        if (this.getFamily().getCommonSpecies().isAcceptableSoil((IWorldReader)world, pos, state)) {
            return ReplaceableState.REPLACEABLE;
        }
        return ReplaceableState.BLOCKING;
    }

    @Override
    public int getMaxRadius() {
        return 24;
    }

    @Override
    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext context) {
        int thisRadius = this.getRadius(state);
        if (thisRadius <= 8) {
            return super.func_220053_a(state, blockReader, pos, context);
        }
        double radius = (double)thisRadius / 16.0;
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.5 - radius, 0.0, 0.5 - radius, 0.5 + radius, 1.0, 0.5 + radius));
    }

    @Override
    public boolean isMusable(IBlockReader world, BlockState state, BlockPos pos) {
        return this.getRadius(state) > 8;
    }

    static enum ReplaceableState {
        SHELL,
        REPLACEABLE,
        BLOCKING,
        TREEPART;

    }
}

