/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.leaves;

import com.ferreusveritas.dynamictrees.api.Ageable;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cell;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.init.DTClient;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.loot.DTLootParameters;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.RayTraceCollision;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;

public class DynamicLeavesBlock
extends LeavesBlock
implements TreePart,
Ageable,
RayTraceCollision {
    public LeavesProperties field_235684_aB_ = LeavesProperties.NULL;

    public DynamicLeavesBlock(LeavesProperties leavesProperties, AbstractBlock.Properties properties) {
        this(properties);
        this.setProperties(leavesProperties);
        leavesProperties.setDynamicLeavesState(this.func_176223_P());
    }

    public DynamicLeavesBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_208494_a, (Comparable)Integer.valueOf(7))).func_206870_a((Property)field_208495_b, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149653_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)field_208495_b) == false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_208494_a, field_208495_b});
    }

    public void setProperties(LeavesProperties properties) {
        this.field_235684_aB_ = properties;
    }

    public LeavesProperties getProperties(BlockState blockState) {
        return this.field_235684_aB_;
    }

    @Override
    public Family getFamily(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getProperties(state).getFamily();
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getProperties(world.func_180495_p(pos)).getFlammability();
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getProperties(world.func_180495_p(pos)).getFireSpreadSpeed();
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getFlammability(state, world, pos, face) > 0 || face == Direction.UP;
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState stateIn, Direction facing, BlockState facingState, @Nonnull IWorld worldIn, @Nonnull BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.func_176223_P();
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (rand.nextInt((Integer)DTConfigs.TREE_GROWTH_FOLDING.get()) != 0) {
            return;
        }
        double attempts = (double)((Integer)DTConfigs.TREE_GROWTH_FOLDING.get()).intValue() * (Double)DTConfigs.TREE_GROWTH_MULTIPLIER.get();
        if (attempts >= 1.0 || (double)rand.nextFloat() < attempts) {
            this.doTick((World)world, pos, state, rand);
        }
        int start = rand.nextInt(26);
        while (true) {
            int r;
            BlockPos dPos;
            BlockState dState;
            double d;
            attempts -= 1.0;
            if (!(d > 0.0)) break;
            if (!(attempts >= 1.0) && !((double)rand.nextFloat() < attempts) || !((dState = world.func_180495_p(dPos = pos.func_177982_a((r = (r = start++ % 26 + 14) > 26 ? r - 13 : r - 14) % 3 - 1, r / 3 % 3 - 1, r / 9 % 3 - 1))).func_177230_c() instanceof DynamicLeavesBlock)) continue;
            ((DynamicLeavesBlock)dState.func_177230_c()).doTick((World)world, dPos, dState, rand);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
    }

    protected void doTick(World world, BlockPos pos, BlockState state, Random rand) {
        if (this.canTickAt(world, pos) && this.getProperties(state).updateTick(world, pos, state, rand)) {
            this.age((IWorld)world, pos, state, rand, SafeChunkBounds.ANY);
        }
    }

    protected boolean canTickAt(World world, BlockPos pos) {
        int xm = pos.func_177958_n() - (pos.func_177958_n() >> 4 << 4);
        int zm = pos.func_177952_p() - (pos.func_177952_p() >> 4 << 4);
        if (xm > 1 && xm < 14 && zm > 1 && zm < 14) {
            return world.func_195588_v(pos);
        }
        return world.isAreaLoaded(pos, 2);
    }

    public boolean appearanceChangesWithHydro(int oldHydro, int newHydro) {
        return false;
    }

    @Override
    public int age(IWorld world, BlockPos pos, BlockState state, Random rand, SafeChunkBounds safeBounds) {
        boolean worldGen;
        LeavesProperties leavesProperties = this.getProperties(state);
        int oldHydro = (Integer)state.func_177229_b((Property)field_208494_a);
        boolean bl = worldGen = safeBounds != SafeChunkBounds.ANY;
        if (!this.getProperties(state).shouldAge(worldGen, state)) {
            return oldHydro;
        }
        int newHydro = this.getHydrationLevelFromNeighbors(world, pos, leavesProperties);
        if (newHydro == 0 || !worldGen && !this.hasAdequateLight(state, world, leavesProperties, pos)) {
            world.func_217377_a(pos, false);
            return -1;
        }
        if (oldHydro != newHydro) {
            world.func_180501_a(pos, this.getLeavesBlockStateForPlacement(world, pos, leavesProperties.getDynamicLeavesState(newHydro), oldHydro, worldGen), this.appearanceChangesWithHydro(oldHydro, newHydro) ? 2 : 4);
        }
        for (Direction dir : Direction.values()) {
            int hydro;
            BlockPos offpos;
            if (newHydro <= 1 && rand.nextInt(4) != 0 || !safeBounds.inBounds(offpos = pos.func_177972_a(dir), true) || !this.isLocationSuitableForNewLeaves(world, leavesProperties, offpos) || (hydro = this.getHydrationLevelFromNeighbors(world, offpos, leavesProperties)) <= 0) continue;
            world.func_180501_a(offpos, this.getLeavesBlockStateForPlacement(world, offpos, leavesProperties.getDynamicLeavesState(hydro), 0, worldGen), 2);
        }
        return newHydro;
    }

    public BlockState getLeavesBlockStateForPlacement(IWorld world, BlockPos pos, BlockState leavesStateWithHydro, int oldHydro, boolean worldGen) {
        return leavesStateWithHydro;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return this.getProperties(state).getPrimitiveLeaves().func_185903_a(player, worldIn, pos);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getProperties(state).getPrimitiveLeavesItemStack();
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld world, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() == null) {
            return VoxelShapes.func_197868_b();
        }
        if (this.isLeavesPassable() || this.isEntityPassable(context)) {
            return VoxelShapes.func_197880_a();
        }
        if (((Boolean)DTConfigs.VANILLA_LEAVES_COLLISION.get()).booleanValue()) {
            return VoxelShapes.func_197868_b();
        }
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875));
    }

    protected boolean isLeavesPassable() {
        return (Boolean)DTConfigs.IS_LEAVES_PASSABLE.get() != false || ModList.get().isLoaded("passablefoliage");
    }

    public boolean isEntityPassable(ISelectionContext context) {
        return this.isEntityPassable(context.getEntity());
    }

    public boolean isEntityPassable(@Nullable Entity entity) {
        if (entity instanceof ProjectileEntity) {
            return true;
        }
        if (entity instanceof ItemEntity) {
            return ((ItemEntity)entity).func_92059_d().func_77973_b() instanceof Seed;
        }
        if (entity instanceof LivingEntity) {
            return entity instanceof BeeEntity;
        }
        return false;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!((Boolean)DTConfigs.CANOPY_CRASH.get()).booleanValue() || !(entity instanceof LivingEntity)) {
            return;
        }
        entity.field_70143_R -= 1.0f;
        AxisAlignedBB aabb = entity.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)(aabb.field_72340_a + 0.001));
        int minZ = MathHelper.func_76128_c((double)(aabb.field_72339_c + 0.001));
        int maxX = MathHelper.func_76128_c((double)(aabb.field_72336_d - 0.001));
        int maxZ = MathHelper.func_76128_c((double)(aabb.field_72334_f - 0.001));
        boolean crushing = true;
        boolean hasLeaves = true;
        SoundType stepSound = this.getSoundType(world.func_180495_p(pos), (IWorldReader)world, pos, entity);
        float volume = MathHelper.func_76131_a((float)(stepSound.func_185843_a() / 16.0f * fallDistance), (float)0.0f, (float)3.0f);
        world.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stepSound.func_185845_c(), SoundCategory.BLOCKS, volume, stepSound.func_185847_b(), false);
        int iy = 0;
        while (entity.field_70143_R > 3.0f && crushing && pos.func_177956_o() - iy > 0) {
            if (hasLeaves) {
                entity.field_70143_R *= 0.66f;
                hasLeaves = false;
            }
            for (int ix = minX; ix <= maxX; ++ix) {
                for (int iz = minZ; iz <= maxZ; ++iz) {
                    BlockPos iPos = new BlockPos(ix, pos.func_177956_o() - iy, iz);
                    BlockState state = world.func_180495_p(iPos);
                    if (TreeHelper.isLeaves(state)) {
                        hasLeaves = true;
                        DTClient.crushLeavesBlock(world, iPos, state, entity);
                        world.func_217377_a(iPos, false);
                        continue;
                    }
                    if (world.func_175623_d(iPos)) continue;
                    crushing = false;
                }
            }
            ++iy;
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (this.isLeavesPassable() || this.isEntityPassable(entity)) {
            super.func_196262_a(state, world, pos, entity);
        } else {
            if (entity.func_213322_ci().field_72448_b < 0.0 && entity.field_70143_R < 2.0f) {
                entity.field_70143_R = 0.0f;
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b * 0.5, entity.func_213322_ci().field_72449_c);
            } else if (entity.func_213322_ci().field_72448_b > 0.0 && entity.func_213322_ci().field_72448_b < 0.25) {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b + 0.025, entity.func_213322_ci().field_72449_c);
            }
            entity.func_70031_b(false);
            entity.func_213293_j(entity.func_213322_ci().field_72450_a * 0.25, entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c * 0.25);
        }
    }

    public boolean growLeavesIfLocationIsSuitable(IWorld world, LeavesProperties leavesProp, BlockPos pos, int hydro) {
        int n = hydro = hydro == 0 ? leavesProp.getCellKit().getDefaultHydration() : hydro;
        if (this.isLocationSuitableForNewLeaves(world, leavesProp, pos)) {
            world.func_180501_a(pos, this.getLeavesBlockStateForPlacement(world, pos, leavesProp.getDynamicLeavesState(hydro), 0, false), 2);
            return true;
        }
        return false;
    }

    public boolean isLocationSuitableForNewLeaves(IWorld world, LeavesProperties leavesProperties, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof DynamicLeavesBlock) {
            return false;
        }
        BlockState belowBlockState = world.func_180495_p(pos.func_177977_b());
        if (!leavesProperties.canGrowOnGround() && (belowBlockState.func_200132_m() && !TreeHelper.isBranch(belowBlockState) && !(belowBlockState.func_177230_c() instanceof LeavesBlock) || belowBlockState.func_177230_c() instanceof FlowingFluidBlock)) {
            return false;
        }
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        if (block instanceof DoublePlantBlock && blockState.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER && stateDown.func_177230_c() instanceof DoublePlantBlock && stateDown.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.LOWER) {
            if (block == Blocks.field_196804_gh) {
                world.func_180501_a(pos.func_177977_b(), Blocks.field_150349_c.func_176223_P(), 3);
            } else if (block == Blocks.field_196805_gi) {
                world.func_180501_a(pos.func_177977_b(), Blocks.field_196554_aH.func_176223_P(), 3);
            }
            world.func_217377_a(pos, false);
        }
        return (world.func_175623_d(pos) || world.func_180495_p(pos).func_185904_a().func_76222_j()) && this.hasAdequateLight(blockState, world, leavesProperties, pos);
    }

    public boolean hasAdequateLight(BlockState blockState, IWorld world, LeavesProperties leavesProperties, BlockPos pos) {
        if (world.func_175710_j(pos)) {
            return true;
        }
        int smother = leavesProperties.getSmotherLeavesMax();
        if (smother != 0 && DynamicLeavesBlock.isBottom(world, pos)) {
            int smotherLeaves = 0;
            for (int i = 0; i < smother; ++i) {
                smotherLeaves += TreeHelper.isTreePart(world, pos.func_177981_b(i + 1)) ? 1 : 0;
            }
            if (smotherLeaves >= smother) {
                return false;
            }
        }
        return world.func_226658_a_(LightType.SKY, pos) >= (TreeHelper.isLeaves(blockState) ? leavesProperties.getLightRequirement() - 2 : leavesProperties.getLightRequirement());
    }

    public static boolean isBottom(IWorld world, BlockPos pos) {
        BlockState belowBlockState = world.func_180495_p(pos.func_177977_b());
        TreePart belowTreepart = TreeHelper.getTreePart(belowBlockState);
        if (belowTreepart != TreeHelper.NULL_TREE_PART) {
            return belowTreepart.getRadius(belowBlockState) > 1;
        }
        return true;
    }

    public int getHydrationLevelFromNeighbors(IWorld world, BlockPos pos, LeavesProperties leavesProperties) {
        Cell[] cells = new Cell[6];
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.func_177972_a(dir);
            BlockState state = world.func_180495_p(deltaPos);
            TreePart part = TreeHelper.getTreePart(state);
            cells[dir.ordinal()] = part.getHydrationCell((IBlockReader)world, deltaPos, state, dir, leavesProperties);
        }
        return leavesProperties.getCellKit().getCellSolver().solve(cells);
    }

    @Override
    public Cell getHydrationCell(IBlockReader reader, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        return dir != null ? leavesProperties.getCellKit().getCellForLeaves((Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a)) : CellNull.NULL_CELL;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            this.branchOut(world, pos, signal);
        }
        return signal;
    }

    public boolean needLeaves(World world, BlockPos pos, LeavesProperties leavesProperties, Species species) {
        if (world.func_175623_d(pos)) {
            return this.growLeavesIfLocationIsSuitable((IWorld)world, leavesProperties, pos, leavesProperties.getCellKit().getDefaultHydration());
        }
        TreePart treePart = TreeHelper.getTreePart(world.func_180495_p(pos));
        return treePart instanceof DynamicLeavesBlock && species.isValidLeafBlock((DynamicLeavesBlock)treePart);
    }

    public GrowSignal branchOut(World world, BlockPos pos, GrowSignal signal) {
        Species species = signal.getSpecies();
        LeavesProperties leavesProperties = species.getLeavesProperties();
        if (!this.needLeaves(world, pos, leavesProperties, species)) {
            signal.success = false;
            return signal;
        }
        if (BranchBlock.isNextToBranch(world, pos, signal.dir.func_176734_d())) {
            signal.success = false;
            return signal;
        }
        boolean hasLeaves = false;
        for (Direction dir : Direction.values()) {
            if (!this.needLeaves(world, pos.func_177972_a(dir), leavesProperties, species)) continue;
            hasLeaves = true;
            break;
        }
        if (hasLeaves) {
            Family family = species.getFamily();
            family.getBranchForPlacement((IWorld)world, species, pos).ifPresent(branch -> branch.setRadius((IWorld)world, pos, family.getPrimaryThickness(), null));
            signal.radius = family.getSecondaryThickness();
        }
        signal.success = hasLeaves;
        return signal;
    }

    @Override
    public int probabilityForBlock(BlockState state, IBlockReader reader, BlockPos pos, BranchBlock from) {
        return from.getFamily().isCompatibleDynamicLeaves(from.getFamily().getCommonSpecies(), state, reader, pos) ? 2 : 0;
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.getProperties(world.func_180495_p(pos)).canBeSheared();
    }

    public List<ItemStack> onSheared(@Nullable PlayerEntity player, ItemStack item, World world, BlockPos pos, int fortune) {
        return this.getDrops(player, item, world, pos, fortune);
    }

    public List<ItemStack> getDrops(@Nullable PlayerEntity player, ItemStack item, World world, BlockPos pos, int fortune) {
        return new ArrayList<ItemStack>(Collections.singletonList(this.getProperties(world.func_180495_p(pos)).getPrimitiveLeavesItemStack()));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        LootTable lootTable;
        Vector3d originPos = (Vector3d)builder.func_216019_b(LootParameters.field_237457_g_);
        Species species = Species.NULL_SPECIES;
        BlockPos pos = BlockPos.field_177992_a;
        ServerWorld world = builder.func_216018_a();
        if (originPos == null) {
            lootTable = world.func_73046_m().func_200249_aQ().func_186521_a(this.func_220068_i());
        } else {
            pos = new BlockPos(originPos.func_82615_a(), originPos.func_82617_b(), originPos.func_82616_c());
            LeavesProperties leavesProperties = this.getProperties(state);
            species = this.getExactSpecies((World)world, pos, leavesProperties);
            lootTable = leavesProperties.getBlockLootTable(world.func_73046_m().func_200249_aQ(), species);
        }
        if (lootTable.getLootTableId() == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext context = builder.func_216015_a(LootParameters.field_216287_g, (Object)state).func_216015_a(DTLootParameters.SPECIES, (Object)species).func_216015_a(DTLootParameters.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(species.seasonalSeedDropFactor(WorldContext.create((IWorld)world), pos))).func_216022_a(LootParameterSets.field_216267_h);
        return lootTable.func_216113_a(context);
    }

    Species getExactSpecies(@Nullable World world, BlockPos pos, LeavesProperties leavesProperties) {
        if (world == null) {
            return Species.NULL_SPECIES;
        }
        ArrayList<BlockPos> branchList = new ArrayList<BlockPos>();
        for (BlockPos blockPos : leavesProperties.getCellKit().getLeafCluster().getAllNonZero()) {
            BranchBlock branch;
            BlockPos blockPos2 = pos.func_177971_a((Vector3i)BlockPos.field_177992_a.func_177973_b((Vector3i)blockPos));
            BlockState state = world.func_180495_p(blockPos2);
            if (!TreeHelper.isBranch(state) || (branch = TreeHelper.getBranch(state)).getFamily() != leavesProperties.getFamily() || branch.getRadius(state) != branch.getFamily().getPrimaryThickness()) continue;
            branchList.add(blockPos2);
        }
        if (branchList.isEmpty()) {
            return Species.NULL_SPECIES;
        }
        BlockPos closest = (BlockPos)branchList.get(0);
        double d = 999.0;
        for (BlockPos dPos : branchList) {
            double d2 = pos.func_177951_i((Vector3i)dPos);
            if (!(d2 < d)) continue;
            d = d2;
            closest = dPos;
        }
        return TreeHelper.getExactSpecies(world, closest);
    }

    @Override
    public int getRadiusForConnection(BlockState state, IBlockReader reader, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getProperties(state).getRadiusForConnection(state, reader, pos, from, side, fromRadius);
    }

    @Override
    public int getRadius(BlockState state) {
        return 0;
    }

    @Override
    public boolean shouldAnalyse(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    @Override
    public MapSignal analyse(BlockState state, IWorld world, BlockPos pos, Direction fromDir, MapSignal signal) {
        return signal;
    }

    @Override
    public int branchSupport(BlockState state, IBlockReader reader, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return radius == branch.getFamily().getPrimaryThickness() && branch.getFamily() == this.getFamily(state, reader, pos) ? BranchBlock.setSupport(0, 1) : 0;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    public final TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.LEAVES;
    }

    @Override
    public boolean isRayTraceCollidable() {
        return true;
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0.2f;
    }
}

