/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.leaves;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class PalmLeavesProperties
extends LeavesProperties {
    public static final TypedRegistry.EntryType<LeavesProperties> TYPE = TypedRegistry.newType(PalmLeavesProperties::new);

    public PalmLeavesProperties(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected DynamicLeavesBlock createDynamicLeaves(AbstractBlock.Properties properties) {
        return new DynamicPalmLeavesBlock(this, properties);
    }

    @Override
    public LootTable.Builder createBlockDrops() {
        if (this.primitiveLeaves != null && this.getPrimitiveLeavesBlock().isPresent()) {
            return DTLootTableProvider.createPalmLeavesBlockDrops(this.primitiveLeaves.func_177230_c(), this.seedDropChances);
        }
        return DTLootTableProvider.createPalmLeavesDrops(this.seedDropChances, LootParameterSets.field_216267_h);
    }

    @Override
    public LootTable.Builder createDrops() {
        return DTLootTableProvider.createPalmLeavesDrops(this.seedDropChances, DTLootParameterSets.LEAVES);
    }

    public static class DynamicPalmLeavesBlock
    extends DynamicLeavesBlock {
        public static final IntegerProperty DIRECTION = IntegerProperty.func_177719_a((String)"direction", (int)0, (int)8);
        public static final CoordUtils.Surround[][] hydroSurroundMap = new CoordUtils.Surround[][]{new CoordUtils.Surround[0], {CoordUtils.Surround.NE, CoordUtils.Surround.SE, CoordUtils.Surround.SW, CoordUtils.Surround.NW}, {CoordUtils.Surround.N, CoordUtils.Surround.E, CoordUtils.Surround.S, CoordUtils.Surround.W}, new CoordUtils.Surround[0], new CoordUtils.Surround[0], new CoordUtils.Surround[0], new CoordUtils.Surround[0], new CoordUtils.Surround[0]};

        @Override
        public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
            int dist;
            if (state.func_177230_c() == this && ((dist = ((Integer)state.func_177229_b((Property)field_208494_a)).intValue()) == 1 || dist == 2) && (Integer)state.func_177229_b((Property)DIRECTION) == 0) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                return;
            }
            super.func_225542_b_(state, world, pos, rand);
        }

        public DynamicPalmLeavesBlock(LeavesProperties leavesProperties, AbstractBlock.Properties properties) {
            super(leavesProperties, properties);
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)DIRECTION, (Comparable)Integer.valueOf(0)));
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{DIRECTION});
        }

        public static BlockState getDirectionState(BlockState state, CoordUtils.Surround surround) {
            if (state == null) {
                return null;
            }
            return (BlockState)state.func_206870_a((Property)DIRECTION, (Comparable)Integer.valueOf(surround == null ? 0 : surround.ordinal() + 1));
        }

        @Override
        public int getRadiusForConnection(BlockState state, IBlockReader reader, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
            return side == Direction.UP && from.getFamily().isCompatibleDynamicLeaves(Species.NULL_SPECIES, state, reader, pos) ? fromRadius : 0;
        }

        @Override
        public int branchSupport(BlockState state, IBlockReader reader, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
            return branch.getFamily() == this.getFamily(state, reader, pos) ? BranchBlock.setSupport(0, 1) : 0;
        }

        @Override
        public boolean appearanceChangesWithHydro(int oldHydro, int newHydro) {
            return true;
        }

        @Override
        public BlockState getLeavesBlockStateForPlacement(IWorld world, BlockPos pos, BlockState leavesStateWithHydro, int oldHydro, boolean worldGen) {
            for (CoordUtils.Surround surround : CoordUtils.Surround.values()) {
                BlockState offstate = world.func_180495_p(pos.func_177971_a(surround.getOffset()));
                if (offstate.func_177230_c() != this || (Integer)offstate.func_177229_b((Property)field_208494_a) != 3) continue;
                return DynamicPalmLeavesBlock.getDirectionState(leavesStateWithHydro, surround);
            }
            return leavesStateWithHydro;
        }

        public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
            AxisAlignedBB base = super.func_196247_c(state, world, pos).func_197752_a();
            base.func_72314_b(1.0, 0.0, 1.0);
            base.func_72314_b(-1.0, 0.0, -1.0);
            return VoxelShapes.func_197881_a((AxisAlignedBB)base);
        }
    }
}

