/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.rootyblocks;

import com.ferreusveritas.dynamictrees.api.RootyBlockDecayer;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cell;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockWithDynamicHardness;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tileentity.SpeciesTileEntity;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class RootyBlock
extends BlockWithDynamicHardness
implements TreePart {
    public static RootyBlockDecayer rootyBlockDecayer = null;
    public static final IntegerProperty FERTILITY = IntegerProperty.func_177719_a((String)"fertility", (int)0, (int)15);
    public static final BooleanProperty IS_VARIANT = BooleanProperty.func_177716_a((String)"is_variant");
    private final SoilProperties properties;

    public RootyBlock(SoilProperties properties, AbstractBlock.Properties blockProperties) {
        super(blockProperties.func_200944_c());
        this.properties = properties;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FERTILITY, (Comparable)Integer.valueOf(0))).func_206870_a((Property)IS_VARIANT, (Comparable)Boolean.valueOf(false)));
    }

    public SoilProperties getSoilProperties() {
        return this.properties;
    }

    public Block getPrimitiveSoilBlock() {
        return this.properties.getPrimitiveSoilBlock();
    }

    public BlockState getPrimitiveSoilState(BlockState currentSoilState) {
        return this.properties.getPrimitiveSoilState(currentSoilState);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getPrimitiveSoilBlock().getSoundType(this.getDecayBlockState(state, (IBlockReader)world, pos), world, pos, entity);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getPrimitiveSoilBlock().getLightValue(this.getDecayBlockState(state, world, pos), world, pos);
    }

    public boolean func_200123_i(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getPrimitiveSoilBlock().func_200123_i(this.getDecayBlockState(state, world, pos), world, pos);
    }

    public int func_200011_d(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getPrimitiveSoilBlock().func_200011_d(this.getDecayBlockState(state, world, pos), world, pos);
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.getPrimitiveSoilBlock().getHarvestTool(this.getPrimitiveSoilState(state));
    }

    public int getHarvestLevel(BlockState state) {
        return this.getPrimitiveSoilBlock().getHarvestLevel(this.getPrimitiveSoilState(state));
    }

    public MaterialColor func_235697_s_() {
        return this.getPrimitiveSoilBlock().func_235697_s_();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.getPrimitiveSoilBlock().func_220053_a(this.getDecayBlockState(state, world, pos), world, pos, context);
    }

    public float func_208618_m() {
        return this.getPrimitiveSoilBlock().func_208618_m();
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return this.getPrimitiveSoilBlock().getExplosionResistance(this.getDecayBlockState(state, world, pos), world, pos, explosion);
    }

    public float func_226891_m_() {
        return this.getPrimitiveSoilBlock().func_226891_m_();
    }

    public float func_226892_n_() {
        return this.getPrimitiveSoilBlock().func_226892_n_();
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getPrimitiveSoilBlock().getFireSpreadSpeed(this.getDecayBlockState(state, world, pos), world, pos, face);
    }

    public boolean isFireSource(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return this.getPrimitiveSoilBlock().isFireSource(this.getDecayBlockState(state, (IBlockReader)world, pos), world, pos, side);
    }

    @Nonnull
    public List<ItemStack> func_220076_a(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        return this.getPrimitiveSoilState(state).func_215693_a(builder);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getPrimitiveSoilBlock().getPickBlock(this.getDecayBlockState(state, world, pos), target, world, pos, player);
    }

    @Override
    public float getHardness(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return (float)((double)this.getDecayBlockState(state, worldIn, pos).func_185887_b(worldIn, pos) * (Double)DTConfigs.ROOTY_BLOCK_HARDNESS_MULTIPLIER.get());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FERTILITY}).func_206894_a(new Property[]{IS_VARIANT});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (((Boolean)state.func_177229_b((Property)IS_VARIANT)).booleanValue()) {
            return new SpeciesTileEntity();
        }
        return null;
    }

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((Property)IS_VARIANT);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (random.nextInt((Integer)DTConfigs.TREE_GROWTH_FOLDING.get()) == 0) {
            this.updateTree(state, (World)worldIn, pos, random, true);
        }
    }

    public Direction getTrunkDirection(IBlockReader access, BlockPos rootPos) {
        return Direction.UP;
    }

    public void updateTree(BlockState rootyState, World world, BlockPos rootPos, Random random, boolean natural) {
        if (CoordUtils.isSurroundedByLoadedChunks(world, rootPos)) {
            BlockPos treePos;
            TreePart treeBase;
            boolean viable = false;
            Species species = this.getSpecies(rootyState, (IWorld)world, rootPos);
            if (species.isValid() && (treeBase = TreeHelper.getTreePart(world.func_180495_p(treePos = rootPos.func_177972_a(this.getTrunkDirection((IBlockReader)world, rootPos))))) != TreeHelper.NULL_TREE_PART) {
                viable = species.update(world, this, rootPos, this.getFertility(rootyState, (IBlockReader)world, rootPos), treeBase, treePos, random, natural);
            }
            if (!viable) {
                world.func_180501_a(rootPos, this.getDecayBlockState(rootyState, (IBlockReader)world, rootPos), 3);
            }
        }
    }

    public BlockState getDecayBlockState(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getPrimitiveSoilState(state);
    }

    public void doDecay(World world, BlockPos rootPos, BlockState rootyState, Species species) {
        if (world.field_72995_K || !TreeHelper.isRooty(rootyState)) {
            return;
        }
        this.updateTree(rootyState, world, rootPos, world.field_73012_v, true);
        BlockState newState = world.func_180495_p(rootPos);
        if (TreeHelper.isRooty(newState) || rootyBlockDecayer != null && rootyBlockDecayer.decay(world, rootPos, rootyState, species)) {
            return;
        }
        BlockState primitiveDirt = this.getDecayBlockState(rootyState, (IBlockReader)world, rootPos);
        world.func_180501_a(rootPos, primitiveDirt, 3);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        return this.getFertility(blockState, (IBlockReader)world, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        return this.getFamily(state, (IBlockReader)world, pos).onTreeActivated(new Family.TreeActivationContext(world, TreeHelper.findRootNode(world, pos), pos, state, player, hand, heldItem, hit)) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public void destroyTree(World world, BlockPos rootPos) {
        Optional<BranchBlock> branch = TreeHelper.getBranchOpt(world.func_180495_p(rootPos.func_177984_a()));
        if (branch.isPresent()) {
            BranchDestructionData destroyData = branch.get().destroyBranchFromNode(world, rootPos.func_177984_a(), Direction.DOWN, true, null);
            FallingTreeEntity.dropTree(world, destroyData, new ArrayList<ItemStack>(0), FallingTreeEntity.DestroyType.ROOT);
        }
    }

    public void func_176208_a(World world, @Nonnull BlockPos pos, BlockState state, @Nonnull PlayerEntity player) {
        this.destroyTree(world, pos);
        super.func_176208_a(world, pos, state, player);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        this.destroyTree(world, pos);
        super.onBlockExploded(state, world, pos, explosion);
    }

    @Nonnull
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public int getFertility(BlockState blockState, IBlockReader blockAccess, BlockPos pos) {
        return (Integer)blockState.func_177229_b((Property)FERTILITY);
    }

    public void setFertility(World world, BlockPos rootPos, int fertility) {
        BlockState currentState = world.func_180495_p(rootPos);
        Species species = this.getSpecies(currentState, (IWorld)world, rootPos);
        world.func_180501_a(rootPos, (BlockState)currentState.func_206870_a((Property)FERTILITY, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)fertility, (int)0, (int)15))), 3);
        world.func_195593_d(rootPos, (Block)this);
        this.setSpecies(world, rootPos, species);
    }

    public boolean fertilize(World world, BlockPos pos, int amount) {
        int fertility = this.getFertility(world.func_180495_p(pos), (IBlockReader)world, pos);
        if (fertility == 0 && amount < 0 || fertility == 15 && amount > 0) {
            return false;
        }
        this.setFertility(world, pos, fertility + amount);
        return true;
    }

    @Override
    public Cell getHydrationCell(IBlockReader reader, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesTree) {
        return CellNull.NULL_CELL;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    @Override
    public int getRadius(BlockState state) {
        return 8;
    }

    @Override
    public int getRadiusForConnection(BlockState state, IBlockReader reader, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return 8;
    }

    @Override
    public int probabilityForBlock(BlockState state, IBlockReader reader, BlockPos pos, BranchBlock from) {
        return 0;
    }

    public MapSignal startAnalysis(IWorld world, BlockPos rootPos, MapSignal signal) {
        Direction dir = this.getTrunkDirection((IBlockReader)world, rootPos);
        BlockPos treePos = rootPos.func_177972_a(dir);
        BlockState treeState = world.func_180495_p(treePos);
        TreeHelper.getTreePart(treeState).analyse(treeState, world, treePos, null, signal);
        return signal;
    }

    @Override
    public boolean shouldAnalyse(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Override
    public MapSignal analyse(BlockState state, IWorld world, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        signal.run(state, world, pos, fromDir);
        if (signal.root == null) {
            signal.root = pos;
        } else {
            signal.multiroot = true;
        }
        signal.foundRoot = true;
        return signal;
    }

    @Override
    public int branchSupport(BlockState state, IBlockReader reader, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return dir == Direction.DOWN ? BranchBlock.setSupport(1, 1) : 0;
    }

    @Override
    public Family getFamily(BlockState state, IBlockReader reader, BlockPos rootPos) {
        BlockPos treePos = rootPos.func_177972_a(this.getTrunkDirection(reader, rootPos));
        BlockState treeState = reader.func_180495_p(treePos);
        return TreeHelper.isBranch(treeState) ? TreeHelper.getBranch(treeState).getFamily(treeState, reader, treePos) : Family.NULL_FAMILY;
    }

    @Nullable
    private SpeciesTileEntity getTileEntitySpecies(IWorld world, BlockPos pos) {
        TileEntity blockEntity = world.func_175625_s(pos);
        return blockEntity instanceof SpeciesTileEntity ? (SpeciesTileEntity)blockEntity : null;
    }

    public Species getSpecies(BlockState state, IWorld world, BlockPos rootPos) {
        Species species;
        Family tree = this.getFamily(state, (IBlockReader)world, rootPos);
        SpeciesTileEntity rootyDirtTE = this.getTileEntitySpecies(world, rootPos);
        if (rootyDirtTE != null && (species = rootyDirtTE.getSpecies()).getFamily() == tree) {
            return rootyDirtTE.getSpecies();
        }
        return tree.getSpeciesForLocation(world, rootPos.func_177972_a(this.getTrunkDirection((IBlockReader)world, rootPos)));
    }

    public void setSpecies(World world, BlockPos rootPos, Species species) {
        SpeciesTileEntity rootyDirtTE = this.getTileEntitySpecies((IWorld)world, rootPos);
        if (rootyDirtTE != null) {
            rootyDirtTE.setSpecies(species);
        }
    }

    @Override
    public final TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.ROOT;
    }

    @Override
    public final boolean isRootNode() {
        return true;
    }

    public int colorMultiplier(BlockColors blockColors, BlockState state, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int tintIndex) {
        int white = -1;
        switch (tintIndex) {
            case 0: {
                return blockColors.func_228054_a_(this.getPrimitiveSoilState(state), world, pos, tintIndex);
            }
            case 1: {
                return state.func_177230_c() instanceof RootyBlock ? this.rootColor(state, (IBlockReader)world, pos) : -1;
            }
        }
        return -1;
    }

    public boolean getColorFromBark() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int rootColor(BlockState state, IBlockReader blockAccess, BlockPos pos) {
        return this.getFamily(state, blockAccess, pos).getRootColor(state, this.getColorFromBark());
    }

    public boolean fallWithTree(BlockState state, World world, BlockPos pos) {
        return false;
    }
}

