/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.rootyblocks;

import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoilHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DIRT_LIKE = "dirt_like";
    public static final String SAND_LIKE = "sand_like";
    public static final String GRAVEL_LIKE = "gravel_like";
    public static final String WATER_LIKE = "water_like";
    public static final String NETHER_LIKE = "nether_like";
    public static final String NETHER_SOIL_LIKE = "nether_soil_like";
    public static final String END_LIKE = "end_like";
    public static final String MUD_LIKE = "mud_like";
    public static final String TERRACOTTA_LIKE = "terracotta_like";
    public static final String SLIME_LIKE = "slime_like";
    public static final String FUNGUS_LIKE = "fungus_like";
    private static final Map<String, Integer> adjectiveMap = new HashMap<String, Integer>();
    private static final Map<Block, SoilProperties> dirtMap = new HashMap<Block, SoilProperties>();

    public static void createNewAdjective(String adjName) {
        adjectiveMap.put(adjName, 1 << adjectiveMap.size());
    }

    private static int getFlags(String adjName) {
        return adjectiveMap.getOrDefault(adjName, 0);
    }

    public static void addSoilPropertiesToMap(SoilProperties properties) {
        if (!dirtMap.containsKey(properties.getPrimitiveSoilBlock()) && properties.getPrimitiveSoilBlock() != Blocks.field_150350_a) {
            dirtMap.put(properties.getPrimitiveSoilBlock(), properties);
        }
    }

    public static void registerSoil(SoilProperties properties, String ... adjNames) {
        SoilHelper.addSoilPropertiesToMap(properties);
        SoilHelper.registerSoil(properties.getRegistryName(), properties.getPrimitiveSoilBlock(), adjNames);
    }

    public static SoilProperties registerSoil(ResourceLocation name, Block soilBlock, String ... adjNames) {
        if (soilBlock == Blocks.field_150350_a) {
            return SoilProperties.NULL_SOIL_PROPERTIES;
        }
        int flag = 0;
        for (String adjName : adjNames) {
            if (adjectiveMap.containsKey(adjName)) {
                flag |= adjectiveMap.get(adjName).intValue();
                continue;
            }
            LOGGER.error("Adjective \"" + adjName + "\" not found while registering soil block: " + soilBlock);
            return SoilProperties.NULL_SOIL_PROPERTIES;
        }
        return SoilHelper.registerSoil(name, soilBlock, flag);
    }

    public static SoilProperties registerSoil(ResourceLocation name, Block soilBlock, int adjFlag) {
        return dirtMap.compute(soilBlock, (bl, prop) -> prop == null ? new SoilProperties(soilBlock, name, adjFlag, true) : prop.addSoilFlags(adjFlag));
    }

    public static boolean isSoilAcceptable(BlockState soilState, int soilFlags) {
        SoilProperties properties;
        Block soilBlock = soilState.func_177230_c();
        if (soilBlock instanceof RootyBlock) {
            soilBlock = ((RootyBlock)soilBlock).getPrimitiveSoilBlock();
        }
        return ((properties = dirtMap.getOrDefault(soilBlock, SoilProperties.NULL_SOIL_PROPERTIES)).getSoilFlags() & soilFlags) != 0 && properties.isValidState(soilState);
    }

    public static boolean isSoilRegistered(Block block) {
        return dirtMap.containsKey(block);
    }

    public static SoilProperties getProperties(Block block) {
        return dirtMap.getOrDefault(block, SoilProperties.NULL_SOIL_PROPERTIES);
    }

    public static Set<RootyBlock> getRootyBlocksList() {
        return dirtMap.values().stream().map(SoilProperties::getBlock).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public static int getSoilFlags(String ... types) {
        int flags = 0;
        for (String t : types) {
            flags |= SoilHelper.getFlags(t);
        }
        return flags;
    }

    static {
        SoilHelper.createNewAdjective(DIRT_LIKE);
        SoilHelper.createNewAdjective(SAND_LIKE);
        SoilHelper.createNewAdjective(GRAVEL_LIKE);
        SoilHelper.createNewAdjective(WATER_LIKE);
        SoilHelper.createNewAdjective(NETHER_LIKE);
        SoilHelper.createNewAdjective(NETHER_SOIL_LIKE);
        SoilHelper.createNewAdjective(END_LIKE);
        SoilHelper.createNewAdjective(MUD_LIKE);
        SoilHelper.createNewAdjective(TERRACOTTA_LIKE);
        SoilHelper.createNewAdjective(SLIME_LIKE);
        SoilHelper.createNewAdjective(FUNGUS_LIKE);
    }
}

