/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.rootyblocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.SoilStateGenerator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilHelper;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.trees.Resettable;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;

public class SoilProperties
extends RegistryEntry<SoilProperties>
implements Resettable<SoilProperties> {
    public static final Codec<SoilProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf(Resources.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName)).apply((Applicative)instance, SoilProperties::new));
    public static final SoilProperties NULL_SOIL_PROPERTIES = ((SoilProperties)new SoilProperties(){

        @Override
        public Block getPrimitiveSoilBlock() {
            return Blocks.field_150350_a;
        }

        @Override
        public Optional<RootyBlock> getBlock() {
            return Optional.empty();
        }

        @Override
        public Integer getSoilFlags() {
            return 0;
        }

        @Override
        public void generateBlock(AbstractBlock.Properties properties) {
        }
    }.setRegistryName(DTTrees.NULL)).setBlockRegistryName(DTTrees.NULL);
    public static final TypedRegistry<SoilProperties> REGISTRY = new TypedRegistry<SoilProperties>(SoilProperties.class, NULL_SOIL_PROPERTIES, new TypedRegistry.EntryType<SoilProperties>(CODEC));
    protected Block primitiveSoilBlock;
    protected RootyBlock block;
    protected Integer soilFlags = 0;
    private ResourceLocation blockRegistryName;
    protected boolean hasSubstitute;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, SoilProperties>> soilStateGenerator = MutableLazyValue.supplied(SoilStateGenerator::new);

    protected SoilProperties() {
    }

    protected SoilProperties(Block primitiveBlock, ResourceLocation name, Integer soilFlags, boolean generate) {
        this(primitiveBlock, name);
        this.soilFlags = soilFlags;
        if (generate) {
            this.generateBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)primitiveBlock));
        }
    }

    public SoilProperties(ResourceLocation registryName) {
        this(null, registryName);
    }

    public SoilProperties(@Nullable Block primitiveBlock, ResourceLocation registryName) {
        super(registryName);
        this.primitiveSoilBlock = primitiveBlock != null ? primitiveBlock : Blocks.field_150350_a;
    }

    public Block getPrimitiveSoilBlock() {
        return this.primitiveSoilBlock;
    }

    public Optional<Block> getPrimitiveSoilBlockOptional() {
        return Optionals.ofBlock(this.primitiveSoilBlock);
    }

    public void setPrimitiveSoilBlock(Block primitiveSoil) {
        if (this.primitiveSoilBlock == null || primitiveSoil != this.primitiveSoilBlock.getBlock()) {
            this.primitiveSoilBlock = primitiveSoil;
        }
        SoilHelper.addSoilPropertiesToMap(this);
    }

    public boolean isValidState(BlockState primitiveSoilState) {
        return true;
    }

    public BlockState getSoilState(BlockState primitiveSoilState, int fertility, boolean requireTileEntity) {
        return (BlockState)((BlockState)this.block.func_176223_P().func_206870_a((Property)RootyBlock.FERTILITY, (Comparable)Integer.valueOf(fertility))).func_206870_a((Property)RootyBlock.IS_VARIANT, (Comparable)Boolean.valueOf(requireTileEntity));
    }

    public BlockState getPrimitiveSoilState(BlockState currentSoilState) {
        return this.primitiveSoilBlock.func_176223_P();
    }

    protected String getBlockRegistryNamePrefix() {
        return "rooty_";
    }

    public ResourceLocation getBlockRegistryName() {
        return this.blockRegistryName;
    }

    public SoilProperties setBlockRegistryName(ResourceLocation blockRegistryName) {
        this.blockRegistryName = blockRegistryName;
        return this;
    }

    private void setBlockRegistryNameIfNull() {
        if (this.blockRegistryName == null) {
            this.blockRegistryName = ResourceLocationUtils.prefix(this.getRegistryName(), this.getBlockRegistryNamePrefix());
        }
    }

    public Optional<RootyBlock> getBlock() {
        return Optionals.ofBlock(this.block);
    }

    public Optional<RootyBlock> getSoilBlock() {
        return Optional.ofNullable(this.block == Blocks.field_150350_a ? null : this.block);
    }

    public void generateBlock(AbstractBlock.Properties blockProperties) {
        this.setBlockRegistryNameIfNull();
        this.block = RegistryHandler.addBlock(this.blockRegistryName, this.createBlock(blockProperties));
    }

    protected RootyBlock createBlock(AbstractBlock.Properties blockProperties) {
        return new RootyBlock(this, blockProperties);
    }

    public void setBlock(RootyBlock rootyBlock) {
        this.block = rootyBlock;
    }

    public boolean hasSubstitute() {
        return this.hasSubstitute;
    }

    public void setHasSubstitute(boolean hasSubstitute) {
        this.hasSubstitute = hasSubstitute;
    }

    public Material getDefaultMaterial() {
        return Material.field_151578_c;
    }

    public AbstractBlock.Properties getDefaultBlockProperties(Material material, MaterialColor materialColor) {
        return AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b);
    }

    public Integer getSoilFlags() {
        return this.soilFlags;
    }

    public SoilProperties setSoilFlags(Integer adjFlag) {
        this.soilFlags = adjFlag;
        return this;
    }

    public SoilProperties addSoilFlags(Integer adjFlag) {
        SoilProperties soilProperties = this;
        soilProperties.soilFlags = soilProperties.soilFlags | adjFlag;
        return this;
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        this.soilStateGenerator.get().generate(provider, this);
    }

    public ResourceLocation getRootsOverlayLocation() {
        return DynamicTrees.resLoc("block/roots");
    }

    @Override
    public String toString() {
        return this.getRegistryName().toString();
    }
}

