/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;

public class ModelUtils {
    public static float[] getUVs(AxisAlignedBB box, Direction face) {
        switch (face) {
            default: {
                return new float[]{(float)box.field_72340_a, 16.0f - (float)box.field_72339_c, (float)box.field_72336_d, 16.0f - (float)box.field_72334_f};
            }
            case UP: {
                return new float[]{(float)box.field_72340_a, (float)box.field_72339_c, (float)box.field_72336_d, (float)box.field_72334_f};
            }
            case NORTH: {
                return new float[]{16.0f - (float)box.field_72336_d, (float)box.field_72338_b, 16.0f - (float)box.field_72340_a, (float)box.field_72337_e};
            }
            case SOUTH: {
                return new float[]{(float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72336_d, (float)box.field_72337_e};
            }
            case WEST: {
                return new float[]{(float)box.field_72339_c, (float)box.field_72338_b, (float)box.field_72334_f, (float)box.field_72337_e};
            }
            case EAST: 
        }
        return new float[]{16.0f - (float)box.field_72334_f, (float)box.field_72338_b, 16.0f - (float)box.field_72339_c, (float)box.field_72337_e};
    }

    public static int getFaceAngle(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return 0;
        }
        if (axis == Direction.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
                case NORTH: {
                    return 270;
                }
            }
            return 90;
        }
        return face == Direction.NORTH ? 270 : 90;
    }

    public static float[] modUV(float[] uvs) {
        uvs[0] = (int)uvs[0] & 0xF;
        uvs[1] = (int)uvs[1] & 0xF;
        uvs[2] = ((int)uvs[2] - 1 & 0xF) + 1;
        uvs[3] = ((int)uvs[3] - 1 & 0xF) + 1;
        return uvs;
    }

    public static Vector3f[] AABBLimits(AxisAlignedBB aabb) {
        return new Vector3f[]{new Vector3f((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c), new Vector3f((float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f)};
    }

    public static BakedQuad makeBakedQuad(BlockPart blockPart, BlockPartFace partFace, TextureAtlasSprite atlasSprite, Direction dir, ModelRotation modelRotation, ResourceLocation modelResLoc) {
        return new FaceBakery().func_228824_a_(blockPart.field_178241_a, blockPart.field_178239_b, partFace, atlasSprite, dir, (IModelTransform)modelRotation, blockPart.field_178237_d, true, modelResLoc);
    }

    public static TextureAtlasSprite getTexture(ResourceLocation resLoc) {
        return ModelUtils.getTexture(resLoc, AtlasTexture.field_110575_b);
    }

    public static TextureAtlasSprite getTexture(ResourceLocation resLoc, ResourceLocation atlasResLoc) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(atlasResLoc).apply(resLoc);
    }
}

