/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class QuadManipulator {
    public static final Direction[] everyFace = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, null};

    public static List<BakedQuad> getQuads(IBakedModel modelIn, BlockState stateIn, IModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, Vector3d.field_186680_a, everyFace, new Random(), modelData);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, BlockState stateIn, Direction[] sides, IModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, Vector3d.field_186680_a, sides, new Random(), modelData);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, BlockState stateIn, Random rand, IModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, Vector3d.field_186680_a, everyFace, rand, modelData);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, BlockState stateIn, Vector3d offset, Random rand, IModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, everyFace, rand, modelData);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, BlockState stateIn, Vector3d offset, IModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, everyFace, new Random(), modelData);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, BlockState stateIn, Vector3d offset, Direction[] sides, IModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, sides, new Random(), modelData);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, BlockState stateIn, Vector3d offset, Direction[] sides, Random rand, IModelData modelData) {
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        if (stateIn != null) {
            for (Direction dir : sides) {
                outQuads.addAll(modelIn.getQuads(stateIn, dir, rand, modelData));
            }
        }
        return offset.equals((Object)Vector3d.field_186680_a) ? outQuads : QuadManipulator.moveQuads(outQuads, offset);
    }

    public static List<BakedQuad> moveQuads(List<BakedQuad> inQuads, Vector3d offset) {
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        for (BakedQuad inQuad : inQuads) {
            BakedQuad quadCopy = new BakedQuad((int[])inQuad.func_178209_a().clone(), inQuad.func_178211_c(), inQuad.func_178210_d(), inQuad.func_187508_a(), inQuad.func_239287_f_());
            int[] vertexData = quadCopy.func_178209_a();
            block1: for (int i = 0; i < vertexData.length; i += DefaultVertexFormats.field_176600_a.func_181719_f()) {
                int pos = 0;
                for (VertexFormatElement vfe : DefaultVertexFormats.field_176600_a.func_227894_c_()) {
                    if (vfe.func_177375_c() == VertexFormatElement.Usage.POSITION) {
                        float x = Float.intBitsToFloat(vertexData[i + pos + 0]);
                        float y = Float.intBitsToFloat(vertexData[i + pos + 1]);
                        float z = Float.intBitsToFloat(vertexData[i + pos + 2]);
                        x = (float)((double)x + offset.field_72450_a);
                        y = (float)((double)y + offset.field_72448_b);
                        z = (float)((double)z + offset.field_72449_c);
                        vertexData[i + pos + 0] = Float.floatToIntBits(x);
                        vertexData[i + pos + 1] = Float.floatToIntBits(y);
                        vertexData[i + pos + 2] = Float.floatToIntBits(z);
                        continue block1;
                    }
                    pos += vfe.func_177368_f() / 4;
                }
            }
            outQuads.add(quadCopy);
        }
        outQuads.trimToSize();
        return outQuads;
    }

    public static IBakedModel getModelForState(BlockState state) {
        IBakedModel model = null;
        try {
            model = QuadManipulator.getModel(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public static ModelManager getModelManager() {
        return Minecraft.func_71410_x().func_209506_al();
    }

    public static IBakedModel getModel(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
    }

    public static ResourceLocation getModelTexture(IBakedModel model, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, BlockState state, Direction dir) {
        float[] uvs = QuadManipulator.getSpriteUVFromBlockState(state, dir);
        if (uvs != null) {
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>();
            float closest = Float.POSITIVE_INFINITY;
            ResourceLocation closestTex = new ResourceLocation("missingno");
            if (model != null) {
                for (ResourceLocation tex : model.func_177554_e().getDependencies()) {
                    TextureAtlasSprite tas = bakedTextureGetter.apply(tex);
                    float u = tas.func_94214_a(8.0);
                    float v = tas.func_94207_b(8.0);
                    sprites.add(tas);
                    float du = u - uvs[0];
                    float dv = v - uvs[1];
                    float distSq = du * du + dv * dv;
                    if (!(distSq < closest)) continue;
                    closest = distSq;
                    closestTex = tex;
                }
            }
            return closestTex;
        }
        return null;
    }

    public static float[] getSpriteUVFromBlockState(BlockState state, Direction side) {
        IBakedModel bakedModel = QuadManipulator.getModelManager().func_174954_c().func_178125_b(state);
        ArrayList quads = new ArrayList();
        quads.addAll(bakedModel.getQuads(state, side, null, null));
        quads.addAll(bakedModel.getQuads(state, null, null, null));
        Optional<BakedQuad> quad = quads.stream().filter(q -> q.func_178210_d() == side).findFirst();
        if (quad.isPresent()) {
            float u = 0.0f;
            float v = 0.0f;
            int[] vertexData = quad.get().func_178209_a();
            int numVertices = 0;
            for (int i = 0; i < vertexData.length; i += DefaultVertexFormats.field_176600_a.func_181719_f()) {
                int pos = 0;
                for (VertexFormatElement vfe : DefaultVertexFormats.field_176600_a.func_227894_c_()) {
                    if (vfe.func_177375_c() == VertexFormatElement.Usage.UV) {
                        u += Float.intBitsToFloat(vertexData[i + pos + 0]);
                        v += Float.intBitsToFloat(vertexData[i + pos + 1]);
                    }
                    pos += vfe.func_177368_f() / 4;
                }
                ++numVertices;
            }
            return new float[]{u / (float)numVertices, v / (float)numVertices};
        }
        System.err.println("Warning: Could not get \"" + side + "\" side quads from blockstate: " + state);
        return null;
    }
}

