/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class TooltipHandler {
    public static void setupTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (!(item instanceof Seed)) {
            return;
        }
        Seed seed = (Seed)item;
        PlayerEntity player = event.getPlayer();
        if (player == null || player.field_70170_p == null || SeasonHelper.getSeasonValue((IWorld)player.field_70170_p, BlockPos.field_177992_a) == null) {
            return;
        }
        Species species = seed.getSpecies();
        if (species == null || !species.isValid()) {
            return;
        }
        int flags = seed.getSpecies().getSeasonalTooltipFlags(player.field_70170_p);
        TooltipHandler.applySeasonalTooltips(event.getToolTip(), flags);
    }

    public static void applySeasonalTooltips(List<ITextComponent> tipList, int flags) {
        if (flags != 0) {
            tipList.add((ITextComponent)new TranslationTextComponent("desc.sereneseasons.fertile_seasons").func_240702_b_(":"));
            if ((flags & 0xF) == 15) {
                tipList.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.year_round").func_240699_a_(TextFormatting.LIGHT_PURPLE)));
            } else {
                if ((flags & 1) != 0) {
                    tipList.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.spring").func_240699_a_(TextFormatting.GREEN)));
                }
                if ((flags & 2) != 0) {
                    tipList.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.summer").func_240699_a_(TextFormatting.YELLOW)));
                }
                if ((flags & 4) != 0) {
                    tipList.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.autumn").func_240699_a_(TextFormatting.GOLD)));
                }
                if ((flags & 8) != 0) {
                    tipList.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.winter").func_240699_a_(TextFormatting.AQUA)));
                }
            }
        }
    }
}

