/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client.thickrings;

import com.ferreusveritas.dynamictrees.client.thickrings.ThickRingTextureAtlasSprite;
import com.ferreusveritas.dynamictrees.client.thickrings.ThickRingTextureManager;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThickRingAtlasTexture
extends AtlasTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int maximumTextureSize = RenderSystem.maxSupportedTextureSize();
    private static final int spriteSizeMultiplier = 3;
    private static boolean uploaded = false;

    public ThickRingAtlasTexture() {
        super(ThickRingTextureManager.LOCATION_THICKRINGS_TEXTURE);
    }

    public void func_215260_a(AtlasTexture.SheetData sheetData) {
        if (!uploaded) {
            super.func_215260_a(sheetData);
            uploaded = true;
        }
    }

    public AtlasTexture.SheetData func_229220_a_(IResourceManager resourceManagerIn, Stream<ResourceLocation> resourceLocationsIn, IProfiler profilerIn, int maxMipmapLevelIn) {
        profilerIn.func_76320_a("preparing");
        Set<ResourceLocation> set = resourceLocationsIn.peek(resloc -> {
            if (resloc == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
        }).collect(Collectors.toSet());
        int i = this.maximumTextureSize;
        Stitcher stitcher = new Stitcher(i, i, maxMipmapLevelIn);
        int j = Integer.MAX_VALUE;
        int k = 1 << maxMipmapLevelIn;
        profilerIn.func_219895_b("extracting_frames");
        ForgeHooksClient.onTextureStitchedPre((AtlasTexture)this, set);
        for (TextureAtlasSprite.Info spriteInfo : this.makeSprites(resourceManagerIn, set)) {
            int spriteWidth = spriteInfo.func_229250_b_() * 3;
            int spriteHeight = spriteInfo.func_229252_c_() * 3;
            j = Math.min(j, Math.min(spriteWidth, spriteHeight));
            int l = Math.min(Integer.lowestOneBit(spriteWidth), Integer.lowestOneBit(spriteHeight));
            if (l < k) {
                LOGGER.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)spriteInfo.func_229248_a_(), (Object)spriteWidth, (Object)spriteHeight, (Object)MathHelper.func_151239_c((int)k), (Object)MathHelper.func_151239_c((int)l));
                k = l;
            }
            stitcher.func_229211_a_(spriteInfo);
        }
        int i1 = Math.min(j, k);
        int j1 = MathHelper.func_151239_c((int)i1);
        int k1 = maxMipmapLevelIn;
        profilerIn.func_219895_b("register");
        stitcher.func_229211_a_(MissingTextureSprite.func_229177_b_());
        profilerIn.func_219895_b("stitching");
        try {
            stitcher.func_94305_f();
        }
        catch (StitcherException stitcherexception) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)stitcherexception, (String)"Stitching");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Stitcher");
            crashreportcategory.func_71507_a("Sprites", (Object)stitcherexception.func_225331_a().stream().map(p_229216_0_ -> String.format("%s[%dx%d]", p_229216_0_.func_229248_a_(), p_229216_0_.func_229250_b_(), p_229216_0_.func_229252_c_())).collect(Collectors.joining(",")));
            crashreportcategory.func_71507_a("Max Texture Size", (Object)i);
            throw new ReportedException(crashreport);
        }
        profilerIn.func_219895_b("loading");
        List<TextureAtlasSprite> list = this.getStitchedSprites(resourceManagerIn, stitcher, k1);
        profilerIn.func_76319_b();
        return new AtlasTexture.SheetData(set, stitcher.func_110935_a(), stitcher.func_110936_b(), k1, list);
    }

    private Collection<TextureAtlasSprite.Info> makeSprites(IResourceManager resourceManagerIn, Set<ResourceLocation> spriteLocationsIn) {
        ArrayList list = Lists.newArrayList();
        ConcurrentLinkedQueue<TextureAtlasSprite.Info> concurrentlinkedqueue = new ConcurrentLinkedQueue<TextureAtlasSprite.Info>();
        for (ResourceLocation thickSpriteLocation : spriteLocationsIn) {
            if (MissingTextureSprite.func_195675_b().equals((Object)thickSpriteLocation)) continue;
            list.add(CompletableFuture.runAsync(() -> {
                TextureAtlasSprite.Info textureatlassprite$info;
                ResourceLocation baseSpriteLocation = ThickRingTextureManager.getBaseRingFromThickRing(thickSpriteLocation);
                ResourceLocation baseSpritePath = this.getSpritePath(baseSpriteLocation);
                try (IResource baseRingResource = resourceManagerIn.func_199002_a(baseSpritePath);){
                    PngSizeInfo pngsizeinfo = new PngSizeInfo(baseRingResource.toString(), baseRingResource.func_199027_b());
                    AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)baseRingResource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                    if (animationmetadatasection == null) {
                        animationmetadatasection = AnimationMetadataSection.field_229300_b_;
                    }
                    Pair pair = animationmetadatasection.func_225641_a_(pngsizeinfo.field_188533_a, pngsizeinfo.field_188534_b);
                    textureatlassprite$info = new TextureAtlasSprite.Info(baseSpriteLocation, ((Integer)pair.getFirst()).intValue(), ((Integer)pair.getSecond()).intValue(), animationmetadatasection);
                }
                catch (RuntimeException runtimeexception) {
                    LOGGER.error("Unable to parse metadata from {} : {}", (Object)baseSpritePath, (Object)runtimeexception);
                    return;
                }
                catch (IOException ioexception) {
                    LOGGER.error("Using missing texture, unable to load {} : {}", (Object)baseSpritePath, (Object)ioexception);
                    return;
                }
                concurrentlinkedqueue.add(textureatlassprite$info);
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return concurrentlinkedqueue;
    }

    private List<TextureAtlasSprite> getStitchedSprites(IResourceManager resourceManagerIn, Stitcher stitcherIn, int mipmapLevelIn) {
        ConcurrentLinkedQueue concurrentlinkedqueue = new ConcurrentLinkedQueue();
        ArrayList list = Lists.newArrayList();
        stitcherIn.func_229209_a_((spriteInfo, width, height, x, y) -> {
            if (spriteInfo == MissingTextureSprite.func_229177_b_()) {
                MissingTextureSprite missingtexturesprite = MissingTextureSprite.func_229176_a_((AtlasTexture)this, (int)mipmapLevelIn, (int)width, (int)height, (int)x, (int)y);
                concurrentlinkedqueue.add(missingtexturesprite);
            } else {
                list.add(CompletableFuture.runAsync(() -> {
                    TextureAtlasSprite textureatlassprite = this.loadSprite(resourceManagerIn, spriteInfo, width, height, mipmapLevelIn, x, y);
                    if (textureatlassprite != null) {
                        concurrentlinkedqueue.add(textureatlassprite);
                    }
                }, Util.func_215072_e()));
            }
        });
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return Lists.newArrayList(concurrentlinkedqueue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private TextureAtlasSprite loadSprite(IResourceManager resourceManagerIn, TextureAtlasSprite.Info spriteInfoIn, int widthIn, int heightIn, int mipmapLevelIn, int originX, int originY) {
        ResourceLocation baseSpritePath = this.getSpritePath(spriteInfoIn.func_229248_a_());
        TextureAtlasSprite.Info thickSpriteInfo = new TextureAtlasSprite.Info(ThickRingTextureManager.getThickRingFromBaseRing(spriteInfoIn.func_229248_a_()), spriteInfoIn.func_229250_b_() * 3, spriteInfoIn.func_229252_c_() * 3, AnimationMetadataSection.field_229300_b_);
        try (IResource iresource = resourceManagerIn.func_199002_a(baseSpritePath);){
            NativeImage nativeimage = NativeImage.func_195713_a((InputStream)iresource.func_199027_b());
            TextureAtlasSprite thinRings = new TextureAtlasSprite(this, spriteInfoIn, mipmapLevelIn, widthIn, heightIn, originX, originY, nativeimage){};
            ThickRingTextureAtlasSprite thickRingTextureAtlasSprite = new ThickRingTextureAtlasSprite(this, thickSpriteInfo, mipmapLevelIn, widthIn, heightIn, originX, originY, thinRings, baseSpritePath);
            return thickRingTextureAtlasSprite;
        }
        catch (RuntimeException runtimeexception) {
            LOGGER.error("Unable to parse metadata from {}", (Object)baseSpritePath, (Object)runtimeexception);
            return null;
        }
        catch (IOException ioexception) {
            LOGGER.error("Using missing texture, unable to load {}", (Object)baseSpritePath, (Object)ioexception);
            return null;
        }
    }

    private ResourceLocation getSpritePath(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), String.format("textures/%s%s", location.func_110623_a(), ".png"));
    }
}

