/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.command.HexColorArgument;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.items.Staff;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public final class CreateStaffCommand
extends SubCommand {
    private static final String COLOR = "color";
    private static final String READ_ONLY = "readOnly";
    private static final String MAX_USES = "maxUses";
    private static final int DEFAULT_COLOUR = 65535;
    private static final boolean DEFAULT_READ_ONLY = false;
    private static final int DEFAULT_MAX_USES = 64;

    @Override
    protected String getName() {
        return "createstaff";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSource, ?> registerArgument() {
        return CreateStaffCommand.blockPosArgument().then(((RequiredArgumentBuilder)CreateStaffCommand.speciesArgument().executes(context -> this.spawnStaff((CommandSource)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSource>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSource>)context), "JP", 65535, false, 64))).then(((RequiredArgumentBuilder)CreateStaffCommand.stringArgument("jo_code").suggests((context, builder) -> ISuggestionProvider.func_197005_b((Iterable)CreateStaffCommand.speciesArgument((CommandContext<CommandSource>)context).getJoCodes().stream().map(JoCode::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> this.spawnStaff((CommandSource)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSource>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSource>)context), CreateStaffCommand.stringArgument((CommandContext<CommandSource>)context, "jo_code"), 65535, false, 64))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)COLOR, (ArgumentType)HexColorArgument.hex()).executes(context -> this.spawnStaff((CommandSource)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSource>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSource>)context), CreateStaffCommand.stringArgument((CommandContext<CommandSource>)context, "jo_code"), HexColorArgument.getHexCode(context, COLOR), false, 64))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)READ_ONLY, (ArgumentType)BoolArgumentType.bool()).executes(context -> this.spawnStaff((CommandSource)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSource>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSource>)context), CreateStaffCommand.stringArgument((CommandContext<CommandSource>)context, "jo_code"), HexColorArgument.getHexCode(context, COLOR), BoolArgumentType.getBool((CommandContext)context, (String)READ_ONLY), 64))).then(CreateStaffCommand.intArgument(MAX_USES).suggests((context, builder) -> ISuggestionProvider.func_197005_b((Iterable)Stream.of(1, 3, 32, 64, 128).map(String::valueOf).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> this.spawnStaff((CommandSource)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSource>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSource>)context), CreateStaffCommand.stringArgument((CommandContext<CommandSource>)context, "jo_code"), HexColorArgument.getHexCode(context, COLOR), BoolArgumentType.getBool((CommandContext)context, (String)READ_ONLY), CreateStaffCommand.intArgument((CommandContext<CommandSource>)context, MAX_USES))))))));
    }

    private int spawnStaff(CommandSource source, BlockPos pos, Species species, String code, int colour, boolean readOnly, int maxUses) {
        Staff staff = DTRegistries.STAFF;
        ItemStack wandStack = new ItemStack((IItemProvider)staff, 1);
        staff.setSpecies(wandStack, species).setCode(wandStack, code).setColor(wandStack, colour).setReadOnly(wandStack, readOnly).setMaxUses(wandStack, maxUses).setUses(wandStack, maxUses);
        ItemUtils.spawnItemStack((World)source.func_197023_e(), pos, wandStack, true);
        CreateStaffCommand.sendSuccessAndLog(source, (ITextComponent)new TranslationTextComponent("commands.dynamictrees.success.create_staff", new Object[]{species.getTextComponent(), new JoCode(code).getTextComponent(), CreateStaffCommand.aqua(String.format("#%08X", colour)), CreateStaffCommand.aqua(readOnly), CreateStaffCommand.aqua(maxUses), CommandHelper.posComponent((Vector3i)pos, TextFormatting.AQUA)}));
        return 1;
    }
}

