/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.command.CommandConstants;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class FertilityCommand
extends SubCommand {
    private static final String FERTILITY = "fertility";

    @Override
    protected String getName() {
        return FERTILITY;
    }

    @Override
    protected int getPermissionLevel() {
        return 0;
    }

    @Override
    public ArgumentBuilder<CommandSource, ?> registerArgument() {
        return ((RequiredArgumentBuilder)((RequiredArgumentBuilder)FertilityCommand.blockPosArgument().executes(context -> FertilityCommand.executesSuccess(() -> this.getFertility((CommandSource)context.getSource(), FertilityCommand.rootPosArgument((CommandContext<CommandSource>)context), false)))).then(FertilityCommand.booleanArgument("raw").executes(context -> FertilityCommand.executesSuccess(() -> this.getFertility((CommandSource)context.getSource(), FertilityCommand.rootPosArgument((CommandContext<CommandSource>)context), FertilityCommand.booleanArgument((CommandContext<CommandSource>)context, "raw")))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)FERTILITY, (ArgumentType)IntegerArgumentType.integer((int)0, (int)15)).suggests(CommandConstants.FERTILITY_SUGGESTIONS).requires(commandSource -> commandSource.func_197034_c(2))).executes(context -> FertilityCommand.executesSuccess(() -> this.setFertility((CommandSource)context.getSource(), FertilityCommand.rootPosArgument((CommandContext<CommandSource>)context), FertilityCommand.intArgument((CommandContext<CommandSource>)context, FERTILITY)))));
    }

    private void getFertility(CommandSource source, BlockPos rootPos, boolean raw) {
        BlockState state = source.func_197023_e().func_180495_p(rootPos);
        int fertility = Objects.requireNonNull(TreeHelper.getRooty(state)).getFertility(state, (IBlockReader)source.func_197023_e(), rootPos);
        if (raw) {
            FertilityCommand.sendSuccess(source, (ITextComponent)new StringTextComponent(String.valueOf(fertility)));
            return;
        }
        FertilityCommand.sendSuccess(source, (ITextComponent)new TranslationTextComponent("commands.dynamictrees.success.get_fertility", new Object[]{CommandHelper.posComponent((Vector3i)rootPos, TextFormatting.AQUA), CommandHelper.colour(String.valueOf(fertility), TextFormatting.AQUA)}));
    }

    private void setFertility(CommandSource source, BlockPos rootPos, int fertility) {
        BlockState state = source.func_197023_e().func_180495_p(rootPos);
        Objects.requireNonNull(TreeHelper.getRooty(state)).setFertility((World)source.func_197023_e(), rootPos, fertility);
        FertilityCommand.sendSuccessAndLog(source, (ITextComponent)new TranslationTextComponent("commands.dynamictrees.success.set_fertility", new Object[]{CommandHelper.posComponent((Vector3i)rootPos, TextFormatting.AQUA), CommandHelper.colour(String.valueOf(fertility), TextFormatting.AQUA)}));
    }
}

